/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.itemfilter;

import java.awt.Rectangle;
import mcjty.base.ModBase;
import mcjty.container.GenericGuiContainer;
import mcjty.entity.GenericTileEntity;
import mcjty.gui.Window;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.layout.Layout;
import mcjty.gui.layout.LayoutHint;
import mcjty.gui.layout.PositionalLayout;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.Widget;
import mcjty.network.Argument;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.itemfilter.ItemFilterContainer;
import mcjty.rftools.blocks.itemfilter.ItemFilterTileEntity;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;

public class GuiItemFilter
extends GenericGuiContainer<ItemFilterTileEntity> {
    public static final int ITEMFILTER_WIDTH = 195;
    public static final int ITEMFILTER_HEIGHT = 212;
    private static final ResourceLocation iconLocation = new ResourceLocation("rftools", "textures/gui/itemfilter.png");
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");
    private ImageChoiceLabel[] bits = new ImageChoiceLabel[54];

    public GuiItemFilter(ItemFilterTileEntity itemFilterTileEntity, ItemFilterContainer container) {
        super((ModBase)RFTools.instance, RFToolsMessages.INSTANCE, (GenericTileEntity)itemFilterTileEntity, (Container)container, RFTools.GUI_MANUAL_MAIN, "filter");
        this.field_146999_f = 195;
        this.field_147000_g = 212;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setBackground(iconLocation)).setLayout((Layout)new PositionalLayout());
        int[] inputMode = ((ItemFilterTileEntity)this.tileEntity).getInputMode();
        int[] outputMode = ((ItemFilterTileEntity)this.tileEntity).getOutputMode();
        for (ForgeDirection direction : ForgeDirection.values()) {
            if (ForgeDirection.UNKNOWN.equals((Object)direction)) continue;
            final int side = direction.ordinal();
            int slot = 0;
            while (slot < 9) {
                ImageChoiceLabel choiceLabel;
                this.bits[side * 9 + slot] = choiceLabel = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(25 + slot * 18, 4 + side * 13, 12, 12))).addChoice("0", "Disabled", iconGuiElements, 160, 0).addChoice("1", "Input", iconGuiElements, 96, 16).addChoice("2", "Output", iconGuiElements, 80, 16);
                if ((inputMode[side] & 1 << slot) != 0) {
                    choiceLabel.setCurrentChoice(1);
                } else if ((outputMode[side] & 1 << slot) != 0) {
                    choiceLabel.setCurrentChoice(2);
                } else {
                    choiceLabel.setCurrentChoice(0);
                }
                final int finalSlot = slot++;
                choiceLabel.addChoiceEvent(new ChoiceEvent(){

                    public void choiceChanged(Widget parent, String newChoice) {
                        GuiItemFilter.this.changeMode(side, finalSlot);
                    }
                });
                toplevel.addChild((Widget)choiceLabel);
            }
        }
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, this.field_146999_f, this.field_147000_g));
        this.window = new Window((GuiScreen)this, (Widget)toplevel);
    }

    private void changeMode(int side, int slot) {
        ImageChoiceLabel choiceLabel = this.bits[side * 9 + slot];
        int c = choiceLabel.getCurrentChoiceIndex();
        boolean input = false;
        boolean output = false;
        if (c == 1) {
            input = true;
            output = false;
        } else if (c == 2) {
            input = false;
            output = true;
        }
        this.sendServerCommand(RFToolsMessages.INSTANCE, "setMode", new Argument[]{new Argument("side", side), new Argument("slot", slot), new Argument("input", input), new Argument("output", output)});
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.drawWindow();
    }
}

