/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools;

import java.util.List;
import mcjty.gui.RenderHelper;
import mcjty.rftools.PlayerBuff;
import mcjty.rftools.blocks.environmental.EnvironmentalSetup;
import mcjty.rftools.playerprops.PlayerExtendedProperties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class RenderGameOverlayEventHandler {
    private static final int BUFF_ICON_SIZE = 16;
    private static RenderItem itemRender = new RenderItem();
    public static final ResourceLocation texture = new ResourceLocation("textures/atlas/items.png");
    public static List<PlayerBuff> buffs = null;

    public static void onRender(RenderGameOverlayEvent event) {
        if (event.isCancelable() || event.type != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        RenderGameOverlayEventHandler.renderBuffs();
    }

    private static void renderBuffs() {
        if (buffs == null || buffs.isEmpty()) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        PlayerExtendedProperties properties = PlayerExtendedProperties.getProperties((EntityPlayer)player);
        int x = properties.getPreferencesProperties().getBuffX();
        int y = properties.getPreferencesProperties().getBuffY();
        if (x == -1 || y == -1) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
        for (PlayerBuff buff : buffs) {
            Item item;
            switch (buff) {
                case BUFF_FEATHERFALLING: {
                    item = EnvironmentalSetup.featherFallingEModuleItem;
                    break;
                }
                case BUFF_FEATHERFALLINGPLUS: {
                    item = EnvironmentalSetup.featherFallingPlusEModuleItem;
                    break;
                }
                case BUFF_HASTE: {
                    item = EnvironmentalSetup.hasteEModuleItem;
                    break;
                }
                case BUFF_HASTEPLUS: {
                    item = EnvironmentalSetup.hastePlusEModuleItem;
                    break;
                }
                case BUFF_REGENERATION: {
                    item = EnvironmentalSetup.regenerationEModuleItem;
                    break;
                }
                case BUFF_REGENERATIONPLUS: {
                    item = EnvironmentalSetup.regenerationPlusEModuleItem;
                    break;
                }
                case BUFF_SATURATION: {
                    item = EnvironmentalSetup.saturationEModuleItem;
                    break;
                }
                case BUFF_SATURATIONPLUS: {
                    item = EnvironmentalSetup.saturationPlusEModuleItem;
                    break;
                }
                case BUFF_SPEED: {
                    item = EnvironmentalSetup.speedEModuleItem;
                    break;
                }
                case BUFF_SPEEDPLUS: {
                    item = EnvironmentalSetup.speedPlusEModuleItem;
                    break;
                }
                case BUFF_FLIGHT: {
                    item = EnvironmentalSetup.flightEModuleItem;
                    break;
                }
                case BUFF_PEACEFUL: {
                    item = EnvironmentalSetup.peacefulEModuleItem;
                    break;
                }
                case BUFF_WATERBREATHING: {
                    item = EnvironmentalSetup.waterBreathingEModuleItem;
                    break;
                }
                case BUFF_NIGHTVISION: {
                    item = EnvironmentalSetup.nightVisionEModuleItem;
                    break;
                }
                case BUFF_BLINDNESS: {
                    item = EnvironmentalSetup.blindnessEModuleItem;
                    break;
                }
                case BUFF_WEAKNESS: {
                    item = EnvironmentalSetup.weaknessEModuleItem;
                    break;
                }
                case BUFF_POISON: {
                    item = EnvironmentalSetup.poisonEModuleItem;
                    break;
                }
                case BUFF_SLOWNESS: {
                    item = EnvironmentalSetup.slownessEModuleItem;
                    break;
                }
                default: {
                    item = null;
                }
            }
            if (item == null) continue;
            IIcon icon = item.func_77617_a(0);
            RenderHelper.renderIcon((Minecraft)Minecraft.func_71410_x(), (RenderItem)itemRender, (IIcon)icon, (int)x, (int)y, (boolean)false);
            x += 16;
        }
    }
}

