/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.world.gen.feature.kulist;

import com.scottkillen.mod.dendrology.world.gen.feature.kulist.NormalKulistTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class LargeKulistTree
extends NormalKulistTree {
    public LargeKulistTree(boolean fromSapling) {
        super(fromSapling);
    }

    @Override
    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Random rng = new Random();
        rng.setSeed(rand.nextLong());
        int height = rng.nextInt(9) + 9;
        if (this.isPoorGrowthConditions(world, x, y, z, height, (IPlantable)this.getSaplingBlock())) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        block.onPlantGrow(world, x, y - 1, z, x, y, z);
        for (int level = 0; level <= height; ++level) {
            this.placeLog(world, x, y + level, z);
            if (level == height) {
                this.leafGen(world, x, y + level, z);
            }
            if (level <= 3 || level >= height) continue;
            int branchRarity = height / level + 1;
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, -1, 0);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 1, 0);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 0, -1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 0, 1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, -1, 1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, -1, -1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 1, 1);
            }
            if (rng.nextInt(branchRarity) != 0) continue;
            this.branch(world, rng, x, y, z, height, level, 1, -1);
        }
        return true;
    }
}

