/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.world.gen.feature;

import com.google.common.base.Objects;
import com.scottkillen.mod.dendrology.world.gen.feature.AbstractTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class NucisTree
extends AbstractTree {
    private int logDirection = 0;

    public NucisTree(boolean fromSapling) {
        super(fromSapling);
    }

    public NucisTree() {
        this(true);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Random rng = new Random();
        rng.setSeed(rand.nextLong());
        int height = rng.nextInt(15) + 8;
        if (this.isPoorGrowthConditions(world, x, y, z, height, (IPlantable)this.getSaplingBlock())) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        block.onPlantGrow(world, x, y - 1, z, x, y, z);
        for (int level = 0; level < height; ++level) {
            this.placeLog(world, x, y + level, z);
            if (level <= 3) continue;
            int branchRarity = height / (level - 2) + 1;
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, -1, 0);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 1, 0);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 0, -1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 0, 1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, -1, 1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, -1, -1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 1, 1);
            }
            if (rng.nextInt(branchRarity) != 0) continue;
            this.branch(world, rng, x, y, z, height, level, 1, -1);
        }
        this.leafGen(world, x, y + height, z);
        return true;
    }

    private void branch(World world, Random random, int x, int y, int z, int height, int level, int dX, int dZ) {
        int level1 = level + y;
        int lengthToGo = height - level1;
        int x1 = x;
        int z1 = z;
        for (int index = 0; index <= lengthToGo; ++index) {
            if (dX == -1 && random.nextInt(3) > 0) {
                --x1;
                this.logDirection = 4;
                if (dZ == 0 && random.nextInt(4) == 0) {
                    z1 = z1 + random.nextInt(3) - 1;
                }
            } else if (dX == 1 && random.nextInt(3) > 0) {
                ++x1;
                this.logDirection = 4;
                if (dZ == 0 && random.nextInt(4) == 0) {
                    z1 = z1 + random.nextInt(3) - 1;
                }
            }
            if (dZ == -1 && random.nextInt(3) > 0) {
                --z1;
                this.logDirection = 8;
                if (dX == 0 && random.nextInt(4) == 0) {
                    x1 = x1 + random.nextInt(3) - 1;
                }
            } else if (dZ == 1 && random.nextInt(3) > 0) {
                ++z1;
                this.logDirection = 8;
                if (dX == 0 && random.nextInt(4) == 0) {
                    x1 = x1 + random.nextInt(3) - 1;
                }
            }
            this.placeLog(world, x1, level1, z1);
            if (random.nextInt(3) > 0) {
                ++level1;
            }
            if (index == lengthToGo || random.nextInt(6) == 0) {
                this.placeLog(world, x1, level1, z1);
                this.leafGen(world, x1, level1, z1);
            }
            this.logDirection = 0;
        }
    }

    private void leafGen(World world, int x, int y, int z) {
        for (int dX = -3; dX <= 3; ++dX) {
            for (int dZ = -3; dZ <= 3; ++dZ) {
                if (!(Math.abs(dX) == 3 && Math.abs(dZ) == 3 || Math.abs(dX) == 2 && Math.abs(dZ) == 3 || Math.abs(dX) == 3 && Math.abs(dZ) == 2)) {
                    this.placeLeaves(world, x + dX, y, z + dZ);
                }
                if (Math.abs(dX) < 3 && Math.abs(dZ) < 3 && (Math.abs(dX) != 2 || Math.abs(dZ) != 2)) {
                    this.placeLeaves(world, x + dX, y + 1, z + dZ);
                    this.placeLeaves(world, x + dX, y - 1, z + dZ);
                }
                if (Math.abs(dX) + Math.abs(dZ) >= 2) continue;
                this.placeLeaves(world, x + dX, y + 2, z + dZ);
                this.placeLeaves(world, x + dX, y - 2, z + dZ);
            }
        }
    }

    @Override
    protected int getLogMetadata() {
        return super.getLogMetadata() | this.logDirection;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("logDirection", this.logDirection).toString();
    }
}

