/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.world.gen.feature;

import com.google.common.base.Objects;
import com.scottkillen.mod.dendrology.world.gen.feature.AbstractTree;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class LataTree
extends AbstractTree {
    private int logDirection = 0;

    public LataTree(boolean fromSapling) {
        super(fromSapling);
    }

    public LataTree() {
        this(true);
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        Random rng = new Random();
        rng.setSeed(rand.nextLong());
        int height = rng.nextInt(15) + 6;
        if (this.isPoorGrowthConditions(world, x, y, z, height, (IPlantable)this.getSaplingBlock())) {
            return false;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        block.onPlantGrow(world, x, y - 1, z, x, y, z);
        for (int level = 0; level <= height; ++level) {
            if (level == height) {
                this.leafGen(world, x, y + level, z);
            } else {
                this.placeLog(world, x, y + level, z);
            }
            if (level <= 3 || level >= height) continue;
            int branchRarity = height / level + 1;
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, -1, 0);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 1, 0);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 0, -1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 0, 1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, -1, 1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, -1, -1);
            }
            if (rng.nextInt(branchRarity) == 0) {
                this.branch(world, rng, x, y, z, height, level, 1, 1);
            }
            if (rng.nextInt(branchRarity) != 0) continue;
            this.branch(world, rng, x, y, z, height, level, 1, -1);
        }
        return true;
    }

    private void branch(World world, Random rand, int x, int y, int z, int treeHeight, int branchLevel, int dX, int dZ) {
        int length = treeHeight - branchLevel;
        int x1 = x;
        int y1 = y + branchLevel;
        int z1 = z;
        for (int i = 0; i <= length; ++i) {
            if (dX == -1 && rand.nextInt(3) > 0) {
                --x1;
                this.logDirection = 4;
                if (dZ == 0 && rand.nextInt(4) == 0) {
                    z1 += rand.nextInt(3) - 1;
                }
            } else if (dX == 1 && rand.nextInt(3) > 0) {
                ++x1;
                this.logDirection = 4;
                if (dZ == 0 && rand.nextInt(4) == 0) {
                    z1 += rand.nextInt(3) - 1;
                }
            }
            if (dZ == -1 && rand.nextInt(3) > 0) {
                --z1;
                this.logDirection = 8;
                if (dX == 0 && rand.nextInt(4) == 0) {
                    x1 += rand.nextInt(3) - 1;
                }
            } else if (dZ == 1 && rand.nextInt(3) > 0) {
                ++z1;
                this.logDirection = 8;
                if (dX == 0 && rand.nextInt(4) == 0) {
                    x1 += rand.nextInt(3) - 1;
                }
            }
            this.placeLog(world, x1, y1, z1);
            this.logDirection = 0;
            if (rand.nextInt(3) == 0) {
                this.leafGen(world, x1, y1, z1);
            }
            if (rand.nextInt(3) > 0) {
                ++y1;
            }
            if (i != length) continue;
            this.placeLog(world, x1, y1, z1);
            this.leafGen(world, x1, y1, z1);
        }
    }

    private void leafGen(World world, int x, int y, int z) {
        for (int dX = -3; dX <= 3; ++dX) {
            for (int dZ = -3; dZ <= 3; ++dZ) {
                if (!(Math.abs(dX) == 3 && Math.abs(dZ) == 3 || Math.abs(dX) == 2 && Math.abs(dZ) == 3 || Math.abs(dX) == 3 && Math.abs(dZ) == 2)) {
                    this.placeLeaves(world, x + dX, y, z + dZ);
                }
                if (Math.abs(dX) < 3 && Math.abs(dZ) < 3 && (Math.abs(dX) != 2 || Math.abs(dZ) != 2)) {
                    this.placeLeaves(world, x + dX, y + 1, z + dZ);
                    this.placeLeaves(world, x + dX, y - 1, z + dZ);
                }
                if (Math.abs(dX) + Math.abs(dZ) >= 2) continue;
                this.placeLeaves(world, x + dX, y + 2, z + dZ);
                this.placeLeaves(world, x + dX, y - 2, z + dZ);
            }
        }
    }

    @Override
    protected int getLogMetadata() {
        return super.getLogMetadata() | this.logDirection;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("logDirection", this.logDirection).toString();
    }
}

