/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.world.gen.feature;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.scottkillen.mod.koresample.tree.DefinesTree;
import com.scottkillen.mod.koresample.tree.block.LeavesBlock;
import com.scottkillen.mod.koresample.tree.block.LogBlock;
import com.scottkillen.mod.koresample.tree.block.SaplingBlock;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;
import org.apache.commons.lang3.tuple.ImmutablePair;

public abstract class AbstractTree
extends WorldGenAbstractTree {
    protected static final ImmutableList<ImmutablePair<Integer, Integer>> BRANCH_DIRECTIONS = ImmutableList.of((Object)ImmutablePair.of((Object)-1, (Object)0), (Object)ImmutablePair.of((Object)1, (Object)0), (Object)ImmutablePair.of((Object)0, (Object)-1), (Object)ImmutablePair.of((Object)0, (Object)1), (Object)ImmutablePair.of((Object)-1, (Object)1), (Object)ImmutablePair.of((Object)-1, (Object)-1), (Object)ImmutablePair.of((Object)1, (Object)1), (Object)ImmutablePair.of((Object)1, (Object)-1));
    private DefinesTree tree = null;

    protected AbstractTree(boolean fromSapling) {
        super(fromSapling);
    }

    protected boolean canBeReplacedByLog(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block.isAir((IBlockAccess)world, x, y, z) || block.isLeaves((IBlockAccess)world, x, y, z);
    }

    public void setTree(DefinesTree tree) {
        this.tree = tree;
    }

    protected boolean isPoorGrowthConditions(World world, int x, int y, int z, int height, IPlantable plantable) {
        Preconditions.checkArgument((height > 0 ? 1 : 0) != 0);
        if (y < 1 || y + height + 1 > world.func_72800_K()) {
            return true;
        }
        if (!this.hasRoomToGrow(world, x, y, z, height)) {
            return true;
        }
        Block block = world.func_147439_a(x, y - 1, z);
        return !block.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, plantable);
    }

    protected boolean hasRoomToGrow(World world, int x, int y, int z, int height) {
        for (int y1 = y; y1 <= y + 1 + height; ++y1) {
            if (this.isReplaceable(world, x, y1, z)) continue;
            return false;
        }
        return true;
    }

    LeavesBlock getLeavesBlock() {
        return this.tree.leavesBlock();
    }

    int getLeavesMetadata() {
        return this.tree.leavesSubBlockIndex();
    }

    protected LogBlock getLogBlock() {
        return this.tree.logBlock();
    }

    protected int getLogMetadata() {
        return this.tree.leavesSubBlockIndex();
    }

    protected SaplingBlock getSaplingBlock() {
        return this.tree.saplingBlock();
    }

    protected void placeLeaves(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).canBeReplacedByLeaves((IBlockAccess)world, x, y, z)) {
            this.func_150516_a(world, x, y, z, (Block)this.getLeavesBlock(), this.getLeavesMetadata());
        }
    }

    protected void placeLog(World world, int x, int y, int z) {
        if (this.canBeReplacedByLog(world, x, y, z)) {
            this.func_150516_a(world, x, y, z, (Block)this.getLogBlock(), this.getLogMetadata());
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("tree", (Object)this.tree).toString();
    }
}

