/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.content.overworld;

import com.google.common.base.Preconditions;
import com.scottkillen.mod.dendrology.content.ProvidesPotionEffect;
import com.scottkillen.mod.dendrology.world.AcemusColorizer;
import com.scottkillen.mod.dendrology.world.CerasuColorizer;
import com.scottkillen.mod.dendrology.world.KulistColorizer;
import com.scottkillen.mod.dendrology.world.gen.feature.AbstractTree;
import com.scottkillen.mod.dendrology.world.gen.feature.AcemusTree;
import com.scottkillen.mod.dendrology.world.gen.feature.CedrumTree;
import com.scottkillen.mod.dendrology.world.gen.feature.CerasuTree;
import com.scottkillen.mod.dendrology.world.gen.feature.DelnasTree;
import com.scottkillen.mod.dendrology.world.gen.feature.EwcalyTree;
import com.scottkillen.mod.dendrology.world.gen.feature.HekurTree;
import com.scottkillen.mod.dendrology.world.gen.feature.KiparisTree;
import com.scottkillen.mod.dendrology.world.gen.feature.KulistTree;
import com.scottkillen.mod.dendrology.world.gen.feature.LataTree;
import com.scottkillen.mod.dendrology.world.gen.feature.NucisTree;
import com.scottkillen.mod.dendrology.world.gen.feature.PorfforTree;
import com.scottkillen.mod.dendrology.world.gen.feature.SalyxTree;
import com.scottkillen.mod.dendrology.world.gen.feature.TuopaTree;
import com.scottkillen.mod.koresample.common.block.SlabBlock;
import com.scottkillen.mod.koresample.common.block.StairsBlock;
import com.scottkillen.mod.koresample.tree.DefinesLeaves;
import com.scottkillen.mod.koresample.tree.DefinesLog;
import com.scottkillen.mod.koresample.tree.DefinesSapling;
import com.scottkillen.mod.koresample.tree.DefinesSlab;
import com.scottkillen.mod.koresample.tree.DefinesStairs;
import com.scottkillen.mod.koresample.tree.DefinesTree;
import com.scottkillen.mod.koresample.tree.DefinesWood;
import com.scottkillen.mod.koresample.tree.block.LeavesBlock;
import com.scottkillen.mod.koresample.tree.block.LogBlock;
import com.scottkillen.mod.koresample.tree.block.SaplingBlock;
import com.scottkillen.mod.koresample.tree.block.WoodBlock;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.potion.PotionHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.gen.feature.WorldGenerator;

public enum OverworldTreeSpecies implements DefinesLeaves,
DefinesLog,
DefinesSapling,
DefinesSlab,
DefinesStairs,
DefinesTree,
DefinesWood,
ProvidesPotionEffect
{
    ACEMUS(Colorizer.ACEMUS_COLOR, new AcemusTree(), new AcemusTree(false)),
    CEDRUM(Colorizer.NO_COLOR, new CedrumTree(), new CedrumTree(false)),
    CERASU(Colorizer.CERASU_COLOR, new CerasuTree(), new CerasuTree(false)),
    DELNAS(Colorizer.NO_COLOR, new DelnasTree(), new DelnasTree(false)),
    EWCALY(Colorizer.NO_COLOR, new EwcalyTree(), new EwcalyTree(false), PotionHelper.field_77922_b),
    HEKUR(Colorizer.BASIC_COLOR, new HekurTree(), new HekurTree(false)),
    KIPARIS(Colorizer.NO_COLOR, new KiparisTree(), new KiparisTree(false), PotionHelper.field_77920_d),
    KULIST(Colorizer.KULIST_COLOR, new KulistTree(), new KulistTree(false)),
    LATA(Colorizer.BASIC_COLOR, new LataTree(), new LataTree(false)),
    NUCIS(Colorizer.BASIC_COLOR, new NucisTree(), new NucisTree(false)),
    PORFFOR(Colorizer.NO_COLOR, new PorfforTree(), new PorfforTree(false)),
    SALYX(Colorizer.NO_COLOR, new SalyxTree(), new SalyxTree(false)),
    TUOPA(Colorizer.BASIC_COLOR, new TuopaTree(), new TuopaTree(false));

    private final AbstractTree saplingTreeGen;
    private final AbstractTree worldTreeGen;
    private final Colorizer colorizer;
    private final String potionEffect;
    private int leavesMeta;
    private int logMeta;
    private int planksMeta;
    private int saplingMeta;
    private int slabMetadata;
    private SlabBlock doubleSlabBlock = null;
    private LeavesBlock leavesBlock = null;
    private LogBlock logBlock = null;
    private WoodBlock woodBlock = null;
    private SaplingBlock saplingBlock = null;
    private SlabBlock singleSlabBlock = null;
    private StairsBlock stairsBlock = null;

    private OverworldTreeSpecies(Colorizer colorizer, AbstractTree saplingTreeGen, AbstractTree worldTreeGen, String potionEffect) {
        this.colorizer = colorizer;
        this.saplingTreeGen = saplingTreeGen;
        this.worldTreeGen = worldTreeGen;
        this.potionEffect = potionEffect;
    }

    private OverworldTreeSpecies(Colorizer colorizer, AbstractTree saplingTreeGen, AbstractTree worldTreeGen) {
        this(colorizer, saplingTreeGen, worldTreeGen, null);
    }

    @Override
    public String potionEffect() {
        return this.potionEffect;
    }

    @SideOnly(value=Side.CLIENT)
    public int getLeavesInventoryColor() {
        switch (this.colorizer) {
            case NO_COLOR: {
                return 0xFFFFFF;
            }
            case ACEMUS_COLOR: {
                return AcemusColorizer.getInventoryColor();
            }
            case CERASU_COLOR: {
                return CerasuColorizer.getInventoryColor();
            }
            case KULIST_COLOR: {
                return KulistColorizer.getInventoryColor();
            }
        }
        return Blocks.field_150362_t.func_149741_i(0);
    }

    @SideOnly(value=Side.CLIENT)
    public int getLeavesColor(IBlockAccess blockAccess, int x, int y, int z) {
        switch (this.colorizer) {
            case NO_COLOR: {
                return 0xFFFFFF;
            }
            case ACEMUS_COLOR: {
                return AcemusColorizer.getColor(x, z);
            }
            case CERASU_COLOR: {
                return CerasuColorizer.getColor(x, y, z);
            }
            case KULIST_COLOR: {
                return KulistColorizer.getColor(x, y, z);
            }
        }
        return Blocks.field_150362_t.func_149720_d(blockAccess, x, y, z);
    }

    public void assignLeavesBlock(LeavesBlock leavesBlock) {
        Preconditions.checkState((this.leavesBlock == null ? 1 : 0) != 0);
        this.leavesBlock = leavesBlock;
    }

    public void assignLeavesSubBlockIndex(int leavesMeta) {
        this.leavesMeta = leavesMeta;
    }

    public LeavesBlock leavesBlock() {
        Preconditions.checkState((this.leavesBlock != null ? 1 : 0) != 0);
        return this.leavesBlock;
    }

    public int leavesSubBlockIndex() {
        return this.leavesMeta;
    }

    public DefinesSapling saplingDefinition() {
        return this;
    }

    public String speciesName() {
        return this.name().toLowerCase();
    }

    public void assignLogBlock(LogBlock logBlock) {
        Preconditions.checkState((this.logBlock == null ? 1 : 0) != 0);
        this.logBlock = logBlock;
    }

    public void assignLogSubBlockIndex(int logMeta) {
        this.logMeta = logMeta;
    }

    public LogBlock logBlock() {
        Preconditions.checkState((this.logBlock != null ? 1 : 0) != 0);
        return this.logBlock;
    }

    public int logSubBlockIndex() {
        return this.logMeta;
    }

    public WoodBlock woodBlock() {
        Preconditions.checkState((this.woodBlock != null ? 1 : 0) != 0);
        return this.woodBlock;
    }

    public int woodSubBlockIndex() {
        return this.planksMeta;
    }

    public void assignWoodBlock(WoodBlock woodBlock) {
        Preconditions.checkState((this.woodBlock == null ? 1 : 0) != 0);
        this.woodBlock = woodBlock;
    }

    public void assignWoodSubBlockIndex(int planksMeta) {
        this.planksMeta = planksMeta;
    }

    public void assignStairsBlock(StairsBlock stairsBlock) {
        Preconditions.checkState((this.stairsBlock == null ? 1 : 0) != 0);
        this.stairsBlock = stairsBlock;
    }

    public StairsBlock stairsBlock() {
        Preconditions.checkState((this.stairsBlock != null ? 1 : 0) != 0);
        return this.stairsBlock;
    }

    public Block stairsModelBlock() {
        return this.woodBlock();
    }

    public int stairsModelSubBlockIndex() {
        return this.woodSubBlockIndex();
    }

    public String stairsName() {
        return this.speciesName();
    }

    public void assignSaplingBlock(SaplingBlock saplingBlock) {
        Preconditions.checkState((this.saplingBlock == null ? 1 : 0) != 0);
        this.saplingBlock = saplingBlock;
    }

    public void assignSaplingSubBlockIndex(int saplingMeta) {
        this.saplingMeta = saplingMeta;
    }

    public SaplingBlock saplingBlock() {
        Preconditions.checkState((this.saplingBlock != null ? 1 : 0) != 0);
        return this.saplingBlock;
    }

    public int saplingSubBlockIndex() {
        return this.saplingMeta;
    }

    @Deprecated
    public WorldGenerator treeGenerator() {
        return this.saplingTreeGen;
    }

    public WorldGenerator saplingTreeGenerator() {
        return this.saplingTreeGen;
    }

    public WorldGenerator worldTreeGenerator() {
        return this.worldTreeGen;
    }

    public void assignDoubleSlabBlock(SlabBlock block) {
        Preconditions.checkState((this.doubleSlabBlock == null ? 1 : 0) != 0);
        this.doubleSlabBlock = block;
    }

    public void assignSingleSlabBlock(SlabBlock block) {
        Preconditions.checkState((this.singleSlabBlock == null ? 1 : 0) != 0);
        this.singleSlabBlock = block;
    }

    public void assignSlabSubBlockIndex(int slabMetadata) {
        this.slabMetadata = slabMetadata;
    }

    public SlabBlock doubleSlabBlock() {
        Preconditions.checkState((this.doubleSlabBlock != null ? 1 : 0) != 0);
        return this.doubleSlabBlock;
    }

    public SlabBlock singleSlabBlock() {
        Preconditions.checkState((this.singleSlabBlock != null ? 1 : 0) != 0);
        return this.singleSlabBlock;
    }

    public int slabSubBlockIndex() {
        return this.slabMetadata;
    }

    public Block slabModelBlock() {
        return this.woodBlock();
    }

    public int slabModelSubBlockIndex() {
        return this.woodSubBlockIndex();
    }

    public String slabName() {
        return this.speciesName();
    }

    static {
        for (OverworldTreeSpecies tree : OverworldTreeSpecies.values()) {
            tree.saplingTreeGen.setTree(tree);
            tree.worldTreeGen.setTree(tree);
        }
    }

    public static enum Colorizer {
        ACEMUS_COLOR,
        BASIC_COLOR,
        CERASU_COLOR,
        KULIST_COLOR,
        NO_COLOR;

    }
}

