/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.compat.storagedrawers;

import com.google.common.base.Objects;
import com.jaquadro.minecraft.storagedrawers.api.IStorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.StorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.config.IAddonConfig;
import com.jaquadro.minecraft.storagedrawers.api.config.IBlockConfig;
import com.jaquadro.minecraft.storagedrawers.api.config.IIntegrationConfig;
import com.jaquadro.minecraft.storagedrawers.api.config.IUserConfig;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackBlockFactory;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackDataResolver;
import com.scottkillen.mod.dendrology.compat.storagedrawers.SDBlocks;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public final class SDRefinedRelocationBlocks {
    private Block fullDrawers1 = null;
    private Block fullDrawers2 = null;
    private Block fullDrawers4 = null;
    private Block halfDrawers2 = null;
    private Block halfDrawers4 = null;

    private static IStorageDrawersApi getAPI() {
        return StorageDrawersApi.instance();
    }

    @Optional.Method(modid="StorageDrawers")
    void setup(SDBlocks blocks) {
        IStorageDrawersApi api = SDRefinedRelocationBlocks.getAPI();
        if (api == null) {
            return;
        }
        IUserConfig userConfig = api.userConfig();
        IIntegrationConfig config = userConfig.integrationConfig();
        if (!Loader.isModLoaded((String)"RefinedRelocation") || !config.isRefinedRelocationEnabled()) {
            return;
        }
        IPackBlockFactory factory = api.packFactory();
        this.createBlocks(blocks, factory);
        blocks.bindSortingBlocks(factory, this.fullDrawers1, this.fullDrawers2, this.fullDrawers4, this.halfDrawers2, this.halfDrawers4);
        this.registerBlocks(factory, userConfig);
        this.configureNEI(factory, userConfig);
    }

    @Optional.Method(modid="StorageDrawers")
    private void configureNEI(IPackBlockFactory factory, IUserConfig userConfig) {
        IAddonConfig config = userConfig.addonConfig();
        if (!config.showAddonItemsNEI()) {
            factory.hideBlock(SDRefinedRelocationBlocks.getQualifiedName(this.fullDrawers1));
            factory.hideBlock(SDRefinedRelocationBlocks.getQualifiedName(this.fullDrawers2));
            factory.hideBlock(SDRefinedRelocationBlocks.getQualifiedName(this.fullDrawers4));
            factory.hideBlock(SDRefinedRelocationBlocks.getQualifiedName(this.halfDrawers2));
            factory.hideBlock(SDRefinedRelocationBlocks.getQualifiedName(this.halfDrawers4));
        }
    }

    @Optional.Method(modid="StorageDrawers")
    private void registerBlocks(IPackBlockFactory factory, IUserConfig userConfig) {
        IBlockConfig config = userConfig.blockConfig();
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.SortingFull1))) {
            factory.registerBlock(this.fullDrawers1, "fullDrawersSort1");
        }
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.SortingFull2))) {
            factory.registerBlock(this.fullDrawers2, "fullDrawersSort2");
        }
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.SortingFull4))) {
            factory.registerBlock(this.fullDrawers4, "fullDrawersSort4");
        }
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.SortingHalf2))) {
            factory.registerBlock(this.halfDrawers2, "halfDrawersSort2");
        }
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.SortingHalf4))) {
            factory.registerBlock(this.halfDrawers4, "halfDrawersSort4");
        }
    }

    @Optional.Method(modid="StorageDrawers")
    private void createBlocks(SDBlocks blocks, IPackBlockFactory factory) {
        IPackDataResolver resolver = blocks.getResolver();
        this.fullDrawers1 = factory.createBlock(BlockConfiguration.SortingFull1, resolver);
        this.fullDrawers2 = factory.createBlock(BlockConfiguration.SortingFull2, resolver);
        this.fullDrawers4 = factory.createBlock(BlockConfiguration.SortingFull4, resolver);
        this.halfDrawers2 = factory.createBlock(BlockConfiguration.SortingHalf2, resolver);
        this.halfDrawers4 = factory.createBlock(BlockConfiguration.SortingHalf4, resolver);
    }

    public static String getQualifiedName(Block block) {
        return GameData.getBlockRegistry().func_148750_c((Object)block);
    }

    @Optional.Method(modid="StorageDrawers")
    public void writeRecipes(SDBlocks blocks) {
        IStorageDrawersApi api = SDRefinedRelocationBlocks.getAPI();
        if (api == null) {
            return;
        }
        IUserConfig userConfig = api.userConfig();
        IIntegrationConfig integrationConfig = userConfig.integrationConfig();
        if (!Loader.isModLoaded((String)"RefinedRelocation") || !integrationConfig.isRefinedRelocationEnabled()) {
            return;
        }
        IBlockConfig config = api.userConfig().blockConfig();
        IPackDataResolver resolver = blocks.getResolver();
        for (int drawerMetadata = 0; drawerMetadata < 16; ++drawerMetadata) {
            if (!resolver.isValidMetaValue(drawerMetadata)) continue;
            this.writeRecipesSet(blocks, drawerMetadata, config);
        }
    }

    @Optional.Method(modid="StorageDrawers")
    private void writeRecipesSet(SDBlocks blocks, int drawerMetadata, IBlockConfig config) {
        String half4Name;
        String half2Name;
        String full4Name;
        String full2Name;
        String full1Name = config.getBlockConfigName(BlockConfiguration.SortingFull1);
        if (config.isBlockEnabled(full1Name)) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.fullDrawers1, config.getBlockRecipeOutput(full1Name), drawerMetadata), (Object[])new Object[]{"x x", " y ", "x x", Character.valueOf('x'), Items.field_151074_bl, Character.valueOf('y'), new ItemStack(blocks.fullDrawers1, 1, drawerMetadata)});
        }
        if (config.isBlockEnabled(full2Name = config.getBlockConfigName(BlockConfiguration.SortingFull2))) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.fullDrawers2, config.getBlockRecipeOutput(full2Name), drawerMetadata), (Object[])new Object[]{"x x", " y ", "x x", Character.valueOf('x'), Items.field_151074_bl, Character.valueOf('y'), new ItemStack(blocks.fullDrawers2, 1, drawerMetadata)});
        }
        if (config.isBlockEnabled(full4Name = config.getBlockConfigName(BlockConfiguration.SortingFull4))) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.fullDrawers4, config.getBlockRecipeOutput(full4Name), drawerMetadata), (Object[])new Object[]{"x x", " y ", "x x", Character.valueOf('x'), Items.field_151074_bl, Character.valueOf('y'), new ItemStack(blocks.fullDrawers4, 1, drawerMetadata)});
        }
        if (config.isBlockEnabled(half2Name = config.getBlockConfigName(BlockConfiguration.SortingHalf2))) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.halfDrawers2, config.getBlockRecipeOutput(half2Name), drawerMetadata), (Object[])new Object[]{"x x", " y ", "x x", Character.valueOf('x'), Items.field_151074_bl, Character.valueOf('y'), new ItemStack(blocks.halfDrawers2, 1, drawerMetadata)});
        }
        if (config.isBlockEnabled(half4Name = config.getBlockConfigName(BlockConfiguration.SortingHalf4))) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.halfDrawers4, config.getBlockRecipeOutput(half4Name), drawerMetadata), (Object[])new Object[]{"x x", " y ", "x x", Character.valueOf('x'), Items.field_151074_bl, Character.valueOf('y'), new ItemStack(blocks.halfDrawers4, 1, drawerMetadata)});
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("fullDrawers1", (Object)this.fullDrawers1).add("fullDrawers2", (Object)this.fullDrawers2).add("fullDrawers4", (Object)this.fullDrawers4).add("halfDrawers2", (Object)this.halfDrawers2).add("halfDrawers4", (Object)this.halfDrawers4).toString();
    }
}

