/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.compat.storagedrawers;

import com.google.common.collect.Lists;
import com.jaquadro.minecraft.storagedrawers.api.IStorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.StorageDrawersApi;
import com.jaquadro.minecraft.storagedrawers.api.config.IAddonConfig;
import com.jaquadro.minecraft.storagedrawers.api.config.IBlockConfig;
import com.jaquadro.minecraft.storagedrawers.api.config.IUserConfig;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackBlockFactory;
import com.jaquadro.minecraft.storagedrawers.api.pack.IPackDataResolver;
import com.jaquadro.minecraft.storagedrawers.api.pack.StandardDataResolver;
import com.scottkillen.mod.dendrology.TheMod;
import com.scottkillen.mod.dendrology.content.overworld.OverworldTreeSpecies;
import com.scottkillen.mod.koresample.common.block.SlabBlock;
import com.scottkillen.mod.koresample.tree.block.WoodBlock;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameData;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public final class SDBlocks {
    Block fullDrawers1 = null;
    Block fullDrawers2 = null;
    Block fullDrawers4 = null;
    Block halfDrawers2 = null;
    Block halfDrawers4 = null;
    private Block trim = null;
    private Object packResolver = null;
    public final CreativeTabs creativeTab = new CreativeTabs("storageDrawersAncientTrees"){

        @SideOnly(value=Side.CLIENT)
        public Item func_78016_d() {
            IStorageDrawersApi api = SDBlocks.getAPI();
            if (api == null) {
                return Item.func_150898_a((Block)Blocks.field_150486_ae);
            }
            IBlockConfig config = api.userConfig().blockConfig();
            if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicFull2))) {
                return Item.func_150898_a((Block)SDBlocks.this.fullDrawers2);
            }
            if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicFull4))) {
                return Item.func_150898_a((Block)SDBlocks.this.fullDrawers4);
            }
            if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicFull1))) {
                return Item.func_150898_a((Block)SDBlocks.this.fullDrawers1);
            }
            if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicHalf2))) {
                return Item.func_150898_a((Block)SDBlocks.this.halfDrawers2);
            }
            if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicHalf4))) {
                return Item.func_150898_a((Block)SDBlocks.this.halfDrawers4);
            }
            return Item.func_150898_a((Block)Blocks.field_150486_ae);
        }

        @SideOnly(value=Side.CLIENT)
        public int func_151243_f() {
            return 9;
        }
    };

    private static List<String> speciesNames() {
        ArrayList names = Lists.newArrayList();
        for (OverworldTreeSpecies species : OverworldTreeSpecies.values()) {
            names.add(species.speciesName());
        }
        return names;
    }

    @Optional.Method(modid="StorageDrawers")
    void setup() {
        IStorageDrawersApi api = SDBlocks.getAPI();
        if (api == null) {
            return;
        }
        IPackBlockFactory factory = api.packFactory();
        this.createBlocks(factory);
        IUserConfig userConfig = api.userConfig();
        this.registerBlocks(factory, userConfig);
        this.configureNEI(factory, userConfig);
    }

    @Optional.Method(modid="StorageDrawers")
    private void configureNEI(IPackBlockFactory factory, IUserConfig userConfig) {
        IAddonConfig config = userConfig.addonConfig();
        if (!config.showAddonItemsNEI()) {
            factory.hideBlock(SDBlocks.getQualifiedName(this.fullDrawers1));
            factory.hideBlock(SDBlocks.getQualifiedName(this.fullDrawers2));
            factory.hideBlock(SDBlocks.getQualifiedName(this.fullDrawers4));
            factory.hideBlock(SDBlocks.getQualifiedName(this.halfDrawers2));
            factory.hideBlock(SDBlocks.getQualifiedName(this.halfDrawers4));
            factory.hideBlock(SDBlocks.getQualifiedName(this.trim));
        }
    }

    private void registerBlocks(IPackBlockFactory factory, IUserConfig userConfig) {
        IBlockConfig config = userConfig.blockConfig();
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicFull1))) {
            factory.registerBlock(this.fullDrawers1, "fullDrawers1");
        }
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicFull2))) {
            factory.registerBlock(this.fullDrawers2, "fullDrawers2");
        }
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicFull4))) {
            factory.registerBlock(this.fullDrawers4, "fullDrawers4");
        }
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicHalf2))) {
            factory.registerBlock(this.halfDrawers2, "halfDrawers2");
        }
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.BasicHalf4))) {
            factory.registerBlock(this.halfDrawers4, "halfDrawers4");
        }
        if (config.isBlockEnabled(config.getBlockConfigName(BlockConfiguration.Trim))) {
            factory.registerBlock(this.trim, "trim");
        }
    }

    @Optional.Method(modid="StorageDrawers")
    private void createBlocks(IPackBlockFactory factory) {
        IPackDataResolver resolver = this.getResolver();
        this.fullDrawers1 = factory.createBlock(BlockConfiguration.BasicFull1, resolver).func_149647_a(this.creativeTab);
        this.fullDrawers2 = factory.createBlock(BlockConfiguration.BasicFull2, resolver).func_149647_a(this.creativeTab);
        this.fullDrawers4 = factory.createBlock(BlockConfiguration.BasicFull4, resolver).func_149647_a(this.creativeTab);
        this.halfDrawers2 = factory.createBlock(BlockConfiguration.BasicHalf2, resolver).func_149647_a(this.creativeTab);
        this.halfDrawers4 = factory.createBlock(BlockConfiguration.BasicHalf4, resolver).func_149647_a(this.creativeTab);
        this.trim = factory.createBlock(BlockConfiguration.Trim, resolver).func_149647_a(this.creativeTab);
    }

    @Optional.Method(modid="StorageDrawers")
    private static IStorageDrawersApi getAPI() {
        return StorageDrawersApi.instance();
    }

    @Optional.Method(modid="StorageDrawers")
    IPackDataResolver getResolver() {
        if (this.packResolver == null) {
            this.packResolver = new StandardDataResolver("dendrology", SDBlocks.speciesNames().toArray(new String[0]), TheMod.INSTANCE.creativeTab());
        }
        return (IPackDataResolver)this.packResolver;
    }

    public static String getQualifiedName(Block block) {
        return GameData.getBlockRegistry().func_148750_c((Object)block);
    }

    @Optional.Method(modid="StorageDrawers")
    public void writeRecipes() {
        IStorageDrawersApi api = SDBlocks.getAPI();
        if (api == null) {
            return;
        }
        IBlockConfig config = api.userConfig().blockConfig();
        int drawerMetadata = 0;
        for (OverworldTreeSpecies species : OverworldTreeSpecies.values()) {
            this.writeRecipesforSpecies(species, drawerMetadata, config);
            ++drawerMetadata;
        }
        ItemStack upgradeTemplate = new ItemStack(GameRegistry.findItem((String)"StorageDrawers", (String)"upgradeTemplate"), 2);
        if (config.isBlockEnabled("fulldrawers1")) {
            GameRegistry.addRecipe((ItemStack)upgradeTemplate, (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151055_y, Character.valueOf('y'), new ItemStack(this.fullDrawers1, 1, Short.MAX_VALUE)});
        }
        if (config.isBlockEnabled("fulldrawers2")) {
            GameRegistry.addRecipe((ItemStack)upgradeTemplate, (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151055_y, Character.valueOf('y'), new ItemStack(this.fullDrawers2, 1, Short.MAX_VALUE)});
        }
        if (config.isBlockEnabled("halfdrawers2")) {
            GameRegistry.addRecipe((ItemStack)upgradeTemplate, (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151055_y, Character.valueOf('y'), new ItemStack(this.halfDrawers2, 1, Short.MAX_VALUE)});
        }
        if (config.isBlockEnabled("fulldrawers4")) {
            GameRegistry.addRecipe((ItemStack)upgradeTemplate, (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151055_y, Character.valueOf('y'), new ItemStack(this.fullDrawers4, 1, Short.MAX_VALUE)});
        }
        if (config.isBlockEnabled("halfdrawers4")) {
            GameRegistry.addRecipe((ItemStack)upgradeTemplate, (Object[])new Object[]{"xxx", "xyx", "xxx", Character.valueOf('x'), Items.field_151055_y, Character.valueOf('y'), new ItemStack(this.halfDrawers4, 1, Short.MAX_VALUE)});
        }
    }

    @Optional.Method(modid="StorageDrawers")
    private void writeRecipesforSpecies(OverworldTreeSpecies species, int drawerMetadata, IBlockConfig config) {
        String half4Name;
        String trimName;
        String full4Name;
        String full2Name;
        WoodBlock planks = species.woodBlock();
        int woodSubBlockIndex = species.woodSubBlockIndex();
        String full1Name = config.getBlockConfigName(BlockConfiguration.BasicFull1);
        if (config.isBlockEnabled(full1Name)) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.fullDrawers1, config.getBlockRecipeOutput(full1Name), drawerMetadata), (Object[])new Object[]{"xxx", " y ", "xxx", Character.valueOf('x'), new ItemStack((Block)planks, 1, woodSubBlockIndex), Character.valueOf('y'), Blocks.field_150486_ae});
        }
        if (config.isBlockEnabled(full2Name = config.getBlockConfigName(BlockConfiguration.BasicFull2))) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.fullDrawers2, config.getBlockRecipeOutput(full2Name), drawerMetadata), (Object[])new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), new ItemStack((Block)planks, 1, woodSubBlockIndex), Character.valueOf('y'), Blocks.field_150486_ae});
        }
        if (config.isBlockEnabled(full4Name = config.getBlockConfigName(BlockConfiguration.BasicFull4))) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.fullDrawers4, config.getBlockRecipeOutput(full4Name), drawerMetadata), (Object[])new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), new ItemStack((Block)planks, 1, woodSubBlockIndex), Character.valueOf('y'), Blocks.field_150486_ae});
        }
        if (config.isBlockEnabled(trimName = config.getBlockConfigName(BlockConfiguration.Trim))) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.trim, config.getBlockRecipeOutput(trimName), drawerMetadata), (Object[])new Object[]{"xyx", "yyy", "xyx", Character.valueOf('x'), Items.field_151055_y, Character.valueOf('y'), new ItemStack((Block)planks, 1, woodSubBlockIndex)});
        }
        SlabBlock recipeSlab = species.singleSlabBlock();
        int slabSubBlockIndex = species.slabSubBlockIndex();
        String half2Name = config.getBlockConfigName(BlockConfiguration.BasicHalf2);
        if (config.isBlockEnabled(half2Name)) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.halfDrawers2, config.getBlockRecipeOutput(half2Name), drawerMetadata), (Object[])new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), new ItemStack((Block)recipeSlab, 1, slabSubBlockIndex), Character.valueOf('y'), Blocks.field_150486_ae});
        }
        if (config.isBlockEnabled(half4Name = config.getBlockConfigName(BlockConfiguration.BasicHalf4))) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(this.halfDrawers4, config.getBlockRecipeOutput(half4Name), drawerMetadata), (Object[])new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), new ItemStack((Block)recipeSlab, 1, slabSubBlockIndex), Character.valueOf('y'), Blocks.field_150486_ae});
        }
    }

    @Optional.Method(modid="StorageDrawers")
    public void bindSortingBlocks(IPackBlockFactory factory, Block fullDrawers1, Block fullDrawers2, Block fullDrawers4, Block halfDrawers2, Block halfDrawers4) {
        factory.bindSortingBlock(this.fullDrawers1, fullDrawers1);
        factory.bindSortingBlock(this.fullDrawers2, fullDrawers2);
        factory.bindSortingBlock(this.fullDrawers4, fullDrawers4);
        factory.bindSortingBlock(this.halfDrawers2, halfDrawers2);
        factory.bindSortingBlock(this.halfDrawers4, halfDrawers4);
    }
}

