/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.compat.mfr;

import com.scottkillen.mod.dendrology.TheMod;
import com.scottkillen.mod.dendrology.block.ModBlocks;
import com.scottkillen.mod.dendrology.compat.mfr.MFRLeaves;
import com.scottkillen.mod.dendrology.compat.mfr.MFRSapling;
import com.scottkillen.mod.dendrology.compat.mfr.MFRWood;
import com.scottkillen.mod.dendrology.config.Settings;
import com.scottkillen.mod.koresample.compat.Integrator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import powercrystals.minefactoryreloaded.api.FactoryRegistry;

public final class MineFactoryReloadedMod
extends Integrator {
    static final String MOD_ID = "MineFactoryReloaded";
    private static final String MOD_NAME = "MineFactoryReloaded";

    public static void notifyNeighbors(World world, int x, int y, int z, Block block) {
        for (int xD = -1; xD < 2; ++xD) {
            for (int yD = -1; yD < 2; ++yD) {
                for (int zD = -1; zD < 2; ++zD) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    MineFactoryReloadedMod.notifyBlock(world, x + xD, y + yD, z + zD, block);
                }
            }
        }
    }

    private static void notifyBlock(World world, int x, int y, int z, Block block) {
        Block targetBlock = world.func_147439_a(x, y, z);
        if (!targetBlock.isLeaves((IBlockAccess)world, x, y, z)) {
            world.func_147460_e(x, y, z, block);
        }
    }

    @Optional.Method(modid="MineFactoryReloaded")
    private static void registerLeaves() {
        MineFactoryReloadedMod.reportProgress("leaves");
        for (BlockLeaves blockLeaves : ModBlocks.leavesBlocks()) {
            MFRLeaves mfrLeaves = new MFRLeaves(blockLeaves);
            FactoryRegistry.sendMessage((String)"registerHarvestable", (Object)mfrLeaves);
        }
    }

    @Optional.Method(modid="MineFactoryReloaded")
    private static void registerLogs() {
        MineFactoryReloadedMod.reportProgress("logs");
        for (BlockLog blockLog : ModBlocks.logBlocks()) {
            FactoryRegistry.sendMessage((String)"registerHarvestable", (Object)new MFRWood(blockLog));
        }
    }

    @Optional.Method(modid="MineFactoryReloaded")
    private static void registerSaplings() {
        MineFactoryReloadedMod.reportProgress("saplings");
        for (BlockSapling blockSapling : ModBlocks.saplingBlocks()) {
            MFRSapling mfrSapling = new MFRSapling(blockSapling);
            FactoryRegistry.sendMessage((String)"registerPlantable", (Object)mfrSapling);
            FactoryRegistry.sendMessage((String)"registerFertilizable", (Object)mfrSapling);
        }
    }

    private static void reportProgress(String phase) {
        TheMod.logger().info("Registering %s with MineFactory Reloaded.", new Object[]{phase});
    }

    private static void init() {
        MineFactoryReloadedMod.registerSaplings();
        MineFactoryReloadedMod.registerLogs();
        MineFactoryReloadedMod.registerLeaves();
    }

    public void doIntegration(LoaderState.ModState modState) {
        if (Loader.isModLoaded((String)"MineFactoryReloaded") && Settings.INSTANCE.integrateMFR()) {
            switch (modState) {
                case INITIALIZED: {
                    MineFactoryReloadedMod.init();
                    break;
                }
            }
        }
    }

    protected String modID() {
        return "MineFactoryReloaded";
    }

    protected String modName() {
        return "MineFactoryReloaded";
    }
}

