/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.compat.mfr;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.scottkillen.mod.dendrology.compat.mfr.MineFactoryReloadedMod;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.api.IFactoryHarvestable;

@Optional.Interface(iface="powercrystals.minefactoryreloaded.api.IFactoryHarvestable", modid="MineFactoryReloaded")
public final class MFRLeaves
implements IFactoryHarvestable {
    private final Block leavesBlock;

    public MFRLeaves(BlockLeaves leavesBlock) {
        this.leavesBlock = leavesBlock;
    }

    public Block getPlant() {
        return this.leavesBlock;
    }

    @Optional.Method(modid="MineFactoryReloaded")
    public HarvestType getHarvestType() {
        return HarvestType.TreeLeaf;
    }

    public boolean breakBlock() {
        return true;
    }

    public boolean canBeHarvested(World world, Map<String, Boolean> harvesterSettings, int x, int y, int z) {
        return true;
    }

    public List<ItemStack> getDrops(World world, Random unused, Map<String, Boolean> harvesterSettings, int x, int y, int z) {
        Block targetBlock = world.func_147439_a(x, y, z);
        if (harvesterSettings.get("silkTouch").equals(Boolean.TRUE)) {
            ItemStack shears;
            IShearable shearable;
            if (targetBlock instanceof IShearable && (shearable = (IShearable)targetBlock).isShearable(shears = new ItemStack((Item)Items.field_151097_aZ, 1, 0), (IBlockAccess)world, x, y, z)) {
                return shearable.onSheared(shears, (IBlockAccess)world, x, y, z, 0);
            }
            if (Item.func_150898_a((Block)targetBlock) != null) {
                ArrayList drops = Lists.newArrayList();
                drops.add(new ItemStack(targetBlock, 1, targetBlock.func_149643_k(world, x, y, z)));
                return drops;
            }
        }
        return targetBlock.getDrops(world, x, y, z, world.func_72805_g(x, y, z), 0);
    }

    public void preHarvest(World world, int x, int y, int z) {
    }

    public void postHarvest(World world, int x, int y, int z) {
        MineFactoryReloadedMod.notifyNeighbors(world, x, y, z, this.leavesBlock);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("leavesBlock", (Object)this.leavesBlock).toString();
    }
}

