/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.compat.chisel;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.scottkillen.mod.koresample.common.util.multiblock.SubBlockManager;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

public final class ChiselWoodSubBlockManager
implements SubBlockManager {
    private final String speciesName;
    private final List<IIcon> icons = Lists.newArrayListWithCapacity((int)16);
    private static final ImmutableList<String> TEXTURES = ImmutableList.of((Object)"clean", (Object)"short", (Object)"vertical", (Object)"vertical-uneven", (Object)"parquet", (Object)"fancy", (Object)"blinds", (Object)"panel-nails", (Object)"double-side", (Object)"crate", (Object)"crate-fancy", (Object)"crateex", (Object[])new String[]{"large", "chaotic-hor", "chaotic", "double-top"});

    public ChiselWoodSubBlockManager(String speciesName) {
        this.speciesName = speciesName;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(int side, int meta) {
        return meta != 9 || side != 0 && side != 1 ? this.icons.get(meta) : this.icons.get(15);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons.clear();
        for (String texture : TEXTURES) {
            this.icons.add(iconRegister.func_94245_a(String.format("chisel:planks-%s/%s", this.speciesName, texture)));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item item, CreativeTabs unused, List subBlocks) {
        int numSubBlocks = TEXTURES.size() - 1;
        for (int i = 0; i < numSubBlocks; ++i) {
            subBlocks.add(new ItemStack(item, 1, i));
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("speciesName", (Object)this.speciesName).add("icons", this.icons).toString();
    }
}

