/*
 * Decompiled with CFR 0.152.
 */
package com.scottkillen.mod.dendrology.compat.chisel;

import com.cricketcraft.chisel.api.carving.CarvableHelper;
import com.cricketcraft.chisel.api.carving.CarvingUtils;
import com.cricketcraft.chisel.api.carving.ICarvingRegistry;
import com.scottkillen.mod.dendrology.compat.chisel.ChiselWoodBlock;
import com.scottkillen.mod.dendrology.config.Settings;
import com.scottkillen.mod.dendrology.content.overworld.OverworldTreeSpecies;
import com.scottkillen.mod.koresample.compat.Integrator;
import com.scottkillen.mod.koresample.tree.block.WoodBlock;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public final class ChiselMod
extends Integrator {
    private static final String MOD_ID = "chisel";
    private static final String MOD_NAME = "Chisel 2";
    private final CreativeTabs creativeTab = new CreativeTabs("chiselAncientTrees"){
        private final OverworldTreeSpecies ICON;
        {
            this.ICON = OverworldTreeSpecies.PORFFOR;
        }

        @SideOnly(value=Side.CLIENT)
        public ItemStack func_151244_d() {
            return new ItemStack((Block)this.ICON.woodBlock(), 1, this.ICON.woodSubBlockIndex());
        }

        @SideOnly(value=Side.CLIENT)
        public Item func_78016_d() {
            return null;
        }
    };

    @Optional.Method(modid="chisel")
    private void preInit() {
        this.loadBlocks();
    }

    private void assignAttributes(ChiselWoodBlock chiselWoodBlock) {
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)chiselWoodBlock, 1, Short.MAX_VALUE));
        chiselWoodBlock.func_149647_a(this.creativeTab);
        Blocks.field_150480_ab.setFireInfo((Block)chiselWoodBlock, 5, 20);
    }

    @Optional.Method(modid="chisel")
    private static void finalizeVariationGroup(WoodBlock woodBlock, int subBlockIndex, String variationGroupName) {
        ICarvingRegistry chisel = CarvingUtils.getChiselRegistry();
        chisel.addVariation(variationGroupName, (Block)woodBlock, subBlockIndex, 0);
        chisel.setVariationSound(variationGroupName, "chisel:chisel.wood");
    }

    @Optional.Method(modid="chisel")
    private void loadBlocks() {
        for (OverworldTreeSpecies species : OverworldTreeSpecies.values()) {
            String speciesName = species.speciesName();
            String variationGroupName = String.format("%s%s", speciesName, "_planks");
            ChiselWoodBlock chiselWoodBlock = ChiselMod.newChiselWoodBlock(speciesName);
            ChiselMod.registerVariations(variationGroupName, chiselWoodBlock);
            ChiselMod.finalizeVariationGroup(species.woodBlock(), species.woodSubBlockIndex(), variationGroupName);
            this.assignAttributes(chiselWoodBlock);
        }
    }

    private static ChiselWoodBlock newChiselWoodBlock(String speciesName) {
        return new ChiselWoodBlock(speciesName);
    }

    @Optional.Method(modid="chisel")
    private static void registerVariations(String variationGroupName, ChiselWoodBlock chiselWoodBlock) {
        CarvableHelper carvableHelper = new CarvableHelper((Block)chiselWoodBlock);
        for (int i = 0; i < 15; ++i) {
            carvableHelper.addVariation(chiselWoodBlock.getVariationName(i), i, (Block)chiselWoodBlock);
        }
        carvableHelper.registerAll((Block)chiselWoodBlock, variationGroupName);
    }

    public void doIntegration(LoaderState.ModState modState) {
        if (Loader.isModLoaded((String)MOD_ID) && Settings.INSTANCE.integrateChisel()) {
            switch (modState) {
                case PREINITIALIZED: {
                    this.preInit();
                    break;
                }
            }
        }
    }

    protected String modID() {
        return MOD_ID;
    }

    protected String modName() {
        return MOD_NAME;
    }
}

