/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.amtgenerators.tileentity;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glassmaker.amtgenerators.networking.NetworkHandler;
import glassmaker.amtgenerators.networking.message.MessageGeneratorRunning;
import glassmaker.amtgenerators.tileentity.TileEntityBaseGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;

public class TileEntityFuelGenerator
extends TileEntityBaseGenerator
implements ISidedInventory {
    public int burningTime = 0;
    public int itemBurningTime = 0;
    private static final int chargeRate = 2;
    private ItemStack fuelSlot;

    public TileEntityFuelGenerator() {
        super(51200);
        this.setTransferRate(2);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.burningTime = nbtTag.func_74762_e("burningTime");
        this.itemBurningTime = nbtTag.func_74762_e("itemBurningTime");
        this.fuelSlot = ItemStack.func_77949_a((NBTTagCompound)nbtTag.func_74775_l("fuelSlot"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        nbtTag.func_74768_a("burningTime", this.burningTime);
        nbtTag.func_74768_a("itemBurningTime", this.itemBurningTime);
        if (this.fuelSlot != null) {
            NBTTagCompound fuelSlotNbt = new NBTTagCompound();
            this.fuelSlot.func_77955_b(fuelSlotNbt);
            nbtTag.func_74782_a("fuelSlot", (NBTBase)fuelSlotNbt);
        }
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int slotId) {
        if (slotId == 0) {
            return this.fuelSlot;
        }
        return null;
    }

    public ItemStack func_70298_a(int slotId, int decAmount) {
        if (slotId != 0 || this.fuelSlot == null) {
            return null;
        }
        int availableAmount = this.fuelSlot.field_77994_a;
        if (availableAmount >= decAmount) {
            availableAmount -= decAmount;
        } else {
            decAmount = availableAmount;
            availableAmount = 0;
        }
        ItemStack returnedStack = this.fuelSlot.func_77946_l();
        returnedStack.field_77994_a = decAmount;
        if (availableAmount <= 0) {
            this.fuelSlot = null;
        } else {
            this.fuelSlot.field_77994_a = availableAmount;
        }
        return returnedStack;
    }

    public ItemStack func_70304_b(int slotId) {
        if (slotId == 0) {
            return this.fuelSlot;
        }
        return null;
    }

    public void func_70299_a(int slotId, ItemStack itemStack) {
        if (slotId == 0) {
            this.fuelSlot = itemStack;
        }
    }

    public String func_145825_b() {
        return "container.amtgen.fuelGenerator";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slotId, ItemStack itemStack) {
        if (slotId != 0) {
            return false;
        }
        if (TileEntityFurnace.func_145954_b((ItemStack)itemStack)) {
            return true;
        }
        return this.fuelSlot != null && this.fuelSlot.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)this.fuelSlot, (ItemStack)itemStack);
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotId, ItemStack itemStack, int side) {
        return this.func_94041_b(slotId, itemStack);
    }

    public boolean func_102008_b(int slotId, ItemStack itemStack, int side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int scaleBurningTime(int scale) {
        return this.itemBurningTime > 0 ? (int)Math.floor(this.burningTime * scale / this.itemBurningTime) : 0;
    }

    public boolean isBurning() {
        return this.burningTime > 0;
    }

    public void func_145845_h() {
        super.func_145845_h();
        boolean burning = this.burningTime > 0;
        boolean requiresUpdate = false;
        if (burning) {
            --this.burningTime;
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.burningTime != 0 || this.fuelSlot != null) {
            if (this.burningTime == 0 && this.currentCharge < this.maxCharge) {
                this.itemBurningTime = this.burningTime = TileEntityFurnace.func_145952_a((ItemStack)this.fuelSlot);
                if (this.burningTime > 0) {
                    requiresUpdate = true;
                    if (this.fuelSlot != null) {
                        --this.fuelSlot.field_77994_a;
                        if (this.fuelSlot.field_77994_a <= 0) {
                            this.fuelSlot = this.fuelSlot.func_77973_b().getContainerItem(this.fuelSlot);
                        }
                    }
                }
            }
            if (this.isBurning() && this.currentCharge < this.maxCharge) {
                this.currentCharge += 2;
                if (this.currentCharge > this.maxCharge) {
                    this.currentCharge = this.maxCharge;
                }
            }
        }
        if (burning != this.burningTime > 0) {
            this.setRunning(this.burningTime > 0);
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 64.0);
            NetworkHandler.CHANNEL.sendToAllAround((IMessage)new MessageGeneratorRunning(this), point);
            requiresUpdate = true;
        }
        if (requiresUpdate) {
            this.func_70296_d();
        }
    }
}

