/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.amtgenerators.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mods.defeatedcrow.api.charge.IChargeGenerator;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBaseGenerator
extends TileEntity
implements IChargeGenerator {
    private int facing = 2;
    protected int maxCharge;
    public int currentCharge = 0;
    private int transferChargeRate = 1;
    private boolean running = false;

    public TileEntityBaseGenerator(int maxCharge) {
        this.maxCharge = maxCharge;
    }

    public boolean canGenerate() {
        return true;
    }

    public int generateCharge(ForgeDirection dir, boolean simulate) {
        int transferedCharge = this.transferChargeRate;
        if (this.currentCharge - transferedCharge <= 0) {
            transferedCharge = this.currentCharge;
        }
        if (!simulate) {
            this.currentCharge -= transferedCharge;
            if (this.currentCharge < 0) {
                this.currentCharge = 0;
            }
        }
        return transferedCharge;
    }

    protected void setTransferRate(int rate) {
        this.transferChargeRate = rate;
    }

    public void setFacing(int direction) {
        this.facing = direction;
    }

    public int getFacing() {
        return this.facing;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public void func_145839_a(NBTTagCompound nbtTag) {
        super.func_145839_a(nbtTag);
        this.facing = nbtTag.func_74762_e("facing");
        if (this.facing == 0) {
            this.facing = 2;
        }
        this.running = nbtTag.func_74767_n("running");
        this.currentCharge = nbtTag.func_74762_e("charge");
        if (this.currentCharge > this.maxCharge) {
            this.currentCharge = this.maxCharge;
        }
    }

    public void func_145841_b(NBTTagCompound nbtTag) {
        super.func_145841_b(nbtTag);
        nbtTag.func_74768_a("facing", this.facing);
        nbtTag.func_74757_a("running", this.running);
        nbtTag.func_74768_a("charge", this.currentCharge);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbtTag = pkt.func_148857_g();
        this.func_145839_a(nbtTag);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }

    @SideOnly(value=Side.CLIENT)
    public int scaleCurrentCharge(int scale) {
        return this.maxCharge > 0 ? (int)Math.floor(this.currentCharge * scale / this.maxCharge) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getCurrentCharge() {
        return this.currentCharge;
    }

    @SideOnly(value=Side.CLIENT)
    public int getMaxCharge() {
        return this.maxCharge;
    }
}

