/*
 * Decompiled with CFR 0.152.
 */
package glassmaker.amtgenerators.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import glassmaker.amtgenerators.AmtGenerators;
import glassmaker.amtgenerators.block.BlockBaseGenerator;
import glassmaker.amtgenerators.tileentity.TileEntityFuelGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.world.World;

public class BlockFuelGenerator
extends BlockBaseGenerator {
    private final Random random = new Random();

    public BlockFuelGenerator() {
        super(Material.field_151576_e);
        this.func_149663_c("amtgen.fuelGenerator");
        this.setBaseTextureName("fuel_generator");
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFuelGenerator();
    }

    public boolean func_149727_a(World world, int xPos, int yPos, int zPos, EntityPlayer player, int side, float xDistance, float yDistance, float zDistance) {
        TileEntity tileEntity;
        ItemStack equippedItemStack = player.func_71045_bC();
        if (equippedItemStack != null && TileEntityFurnace.func_145954_b((ItemStack)equippedItemStack) && (tileEntity = world.func_147438_o(xPos, yPos, zPos)) instanceof TileEntityFuelGenerator && ((TileEntityFuelGenerator)tileEntity).func_102007_a(0, equippedItemStack, side)) {
            TileEntityFuelGenerator tileEntityFuelGenerator = (TileEntityFuelGenerator)tileEntity;
            ItemStack fuelStack = tileEntityFuelGenerator.func_70301_a(0);
            if (fuelStack == null) {
                tileEntityFuelGenerator.func_70299_a(0, equippedItemStack);
                player.func_70062_b(0, null);
                return true;
            }
            if (fuelStack.func_77969_a(equippedItemStack) && ItemStack.func_77970_a((ItemStack)fuelStack, (ItemStack)equippedItemStack)) {
                if (fuelStack.field_77994_a + equippedItemStack.field_77994_a > equippedItemStack.func_77976_d()) {
                    equippedItemStack.field_77994_a -= equippedItemStack.func_77976_d() - fuelStack.field_77994_a;
                    fuelStack.field_77994_a = equippedItemStack.func_77976_d();
                    player.func_70062_b(0, equippedItemStack);
                } else {
                    fuelStack.field_77994_a += equippedItemStack.field_77994_a;
                    player.func_70062_b(0, null);
                }
                return true;
            }
        }
        player.openGui((Object)AmtGenerators.instance, 0, world, xPos, yPos, zPos);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityFuelGenerator fuelGenerator = (TileEntityFuelGenerator)world.func_147438_o(x, y, z);
        if (fuelGenerator != null) {
            ItemStack itemstack = fuelGenerator.func_70301_a(0);
            if (itemstack != null) {
                double offsetX = this.random.nextDouble() * 0.8 + 0.1;
                double offsetY = this.random.nextDouble() * 0.8 + 0.1;
                double offsetZ = this.random.nextDouble() * 0.8 + 0.1;
                while (itemstack.field_77994_a > 0) {
                    int entityStackSize = this.random.nextInt(21) + 10;
                    if (entityStackSize > itemstack.field_77994_a) {
                        entityStackSize = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= entityStackSize;
                    EntityItem entityitem = new EntityItem(world, (double)x + offsetX, (double)y + offsetY, (double)z + offsetZ, new ItemStack(itemstack.func_77973_b(), entityStackSize, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    double noise = 0.05;
                    entityitem.field_70159_w = this.random.nextGaussian() * noise;
                    entityitem.field_70181_x = this.random.nextGaussian() * noise + 0.2;
                    entityitem.field_70179_y = this.random.nextGaussian() * noise;
                    world.func_72838_d((Entity)entityitem);
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntity fuelGenerator = world.func_147438_o(x, y, z);
        if (!(fuelGenerator instanceof TileEntityFuelGenerator) || !((TileEntityFuelGenerator)fuelGenerator).isRunning()) {
            return;
        }
        int facing = ((TileEntityFuelGenerator)fuelGenerator).getFacing();
        float xParticle = (float)x + 0.5f;
        float yParticle = (float)y + random.nextFloat() * 6.0f / 16.0f;
        float zParticle = (float)z + 0.5f;
        float particleOffset = 0.6f;
        float randomDirection = random.nextFloat() * 0.6f - 0.3f;
        switch (facing) {
            case 2: {
                particleOffset *= -1.0f;
            }
            case 3: {
                world.func_72869_a("smoke", (double)(xParticle + randomDirection), (double)yParticle, (double)(zParticle + particleOffset), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xParticle + randomDirection), (double)yParticle, (double)(zParticle + particleOffset), 0.0, 0.0, 0.0);
                break;
            }
            case 4: {
                particleOffset *= -1.0f;
            }
            case 5: {
                world.func_72869_a("smoke", (double)(xParticle + particleOffset), (double)yParticle, (double)(zParticle + randomDirection), 0.0, 0.0, 0.0);
                world.func_72869_a("flame", (double)(xParticle + particleOffset), (double)yParticle, (double)(zParticle + randomDirection), 0.0, 0.0, 0.0);
            }
        }
    }
}

