/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.simplecondenser.inventory;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import java.util.UUID;
import net.lomeli.lomlib.util.entity.EntityUtil;
import net.lomeli.simplecondenser.item.ModItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class InventoryPortableTablet
implements IInventory {
    public static final String INVENTORY_TAG = "Items";
    public static final String UUID_MOST_SIG = "UUIDMostSig";
    public static final String UUID_LEAST_SIG = "UUIDLeastSig";
    public static final String CUSTOM_NAME = "customName";
    public static final String TABLE_LOCAL = "tile.ee3:transmutationTablet.name";
    public static final int ITEM_INPUT_1 = 0;
    public static final int ITEM_INPUT_2 = 1;
    public static final int ITEM_INPUT_3 = 2;
    public static final int ITEM_INPUT_4 = 3;
    public static final int ITEM_INPUT_5 = 4;
    public static final int ITEM_INPUT_6 = 5;
    public static final int ITEM_INPUT_7 = 6;
    public static final int ITEM_INPUT_8 = 7;
    public static final int STONE_INDEX = 8;
    public static final int ALCHEMICAL_TOME_INDEX = 9;
    private EnergyValue storedEnergyValue;
    private EnergyValue availableEnergyValue;
    private ItemStack[] inventory;
    private ItemStack parentStack;
    private UUID uuid;
    private String customName;
    private World world;

    public InventoryPortableTablet(World world, int size, ItemStack parentStack) {
        this.inventory = new ItemStack[size];
        this.parentStack = parentStack;
        this.world = world;
        this.storedEnergyValue = new EnergyValue();
        this.availableEnergyValue = new EnergyValue();
        this.readFromNBT(parentStack.func_77978_p());
    }

    public void consumeInventoryForEnergyValue(ItemStack outputItemStack) {
        EnergyValue outputEnergyValue = EnergyValueRegistryProxy.getEnergyValue((Object)outputItemStack);
        if (this.storedEnergyValue.compareTo(outputEnergyValue) >= 0) {
            this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() - outputEnergyValue.getValue());
        } else {
            while (this.storedEnergyValue.compareTo(outputEnergyValue) < 0 && this.availableEnergyValue.compareTo(outputEnergyValue) >= 0) {
                for (int i = 0; i < 8; ++i) {
                    ItemStack stackInSlot = this.func_70301_a(i);
                    if (stackInSlot == null || !EnergyValueRegistryProxy.hasEnergyValue((Object)stackInSlot)) continue;
                    this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() + EnergyValueRegistryProxy.getEnergyValue((Object)stackInSlot).getValue());
                    this.func_70298_a(i, 1);
                }
            }
            if (this.storedEnergyValue.getValue() >= outputEnergyValue.getValue()) {
                this.storedEnergyValue = new EnergyValue(this.storedEnergyValue.getValue() - outputEnergyValue.getValue());
            }
        }
        this.updateEnergyValueFromInventory();
    }

    public void updateEnergyValueFromInventory() {
        float newEnergyValue = this.storedEnergyValue.getValue();
        for (int i = 0; i <= 8; ++i) {
            if (this.inventory[i] == null || !EnergyValueRegistryProxy.hasEnergyValue((Object)this.inventory[i])) continue;
            newEnergyValue += EnergyValueRegistryProxy.getEnergyValueForStack((Object)this.inventory[i]).getValue();
        }
        this.availableEnergyValue = new EnergyValue(newEnergyValue);
    }

    public void tickInventory() {
        this.updateEnergyValueFromInventory();
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return slot >= 0 && slot < this.func_70302_i_() ? this.inventory[slot] : null;
    }

    public ItemStack func_70298_a(int slot, int decrementAmount) {
        ItemStack itemStack = this.func_70301_a(slot);
        if (itemStack != null) {
            if (itemStack.field_77994_a <= decrementAmount) {
                this.func_70299_a(slot, null);
            } else {
                itemStack = itemStack.func_77979_a(decrementAmount);
                if (itemStack.field_77994_a == 0) {
                    this.func_70299_a(slot, null);
                }
            }
        }
        return itemStack;
    }

    public ItemStack func_70304_b(int slot) {
        if (slot >= 0 && slot < this.func_70302_i_() && this.inventory[slot] != null) {
            ItemStack itemStack = this.inventory[slot];
            this.inventory[slot] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (slot >= 0 && slot < this.func_70302_i_()) {
            this.inventory[slot] = stack;
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : TABLE_LOCAL;
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return !EntityUtil.isFakePlayer((EntityPlayer)player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public ItemStack getParentStack() {
        return this.parentStack;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag != null) {
            if (tag.func_150297_b(UUID_MOST_SIG, 4) && tag.func_150297_b(UUID_LEAST_SIG, 4)) {
                long most = tag.func_74763_f(UUID_MOST_SIG);
                long least = tag.func_74763_f(UUID_LEAST_SIG);
                this.uuid = new UUID(most, least);
            }
            NBTTagList tagList = tag.func_150295_c(INVENTORY_TAG, 10);
            this.inventory = new ItemStack[this.func_70302_i_()];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tagCompound = tagList.func_150305_b(i);
                byte slotIndex = tagCompound.func_74771_c("Slot");
                if (slotIndex < 0 || slotIndex >= this.inventory.length) continue;
                this.inventory[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)tagCompound);
            }
            NBTTagCompound energyValueTagCompound = tag.func_74775_l("storedEnergyValue");
            this.storedEnergyValue = !energyValueTagCompound.func_82582_d() ? EnergyValue.loadEnergyValueFromNBT((NBTTagCompound)energyValueTagCompound) : new EnergyValue(0.0f);
            if (tag.func_150297_b(CUSTOM_NAME, 8)) {
                this.customName = tag.func_74779_i(CUSTOM_NAME);
            }
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        if (tag != null) {
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID();
            }
            tag.func_74772_a(UUID_MOST_SIG, this.uuid.getMostSignificantBits());
            tag.func_74772_a(UUID_LEAST_SIG, this.uuid.getLeastSignificantBits());
            NBTTagList tagList = new NBTTagList();
            for (int currentIndex = 0; currentIndex < this.inventory.length; ++currentIndex) {
                if (this.inventory[currentIndex] == null) continue;
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74774_a("Slot", (byte)currentIndex);
                this.inventory[currentIndex].func_77955_b(tagCompound);
                tagList.func_74742_a((NBTBase)tagCompound);
            }
            tag.func_74782_a(INVENTORY_TAG, (NBTBase)tagList);
            NBTTagCompound energyValueTagCompound = new NBTTagCompound();
            if (this.storedEnergyValue != null) {
                this.storedEnergyValue.writeToNBT(energyValueTagCompound);
            }
            tag.func_74782_a("storedEnergyValue", (NBTBase)energyValueTagCompound);
            if (this.func_145818_k_()) {
                tag.func_74778_a(CUSTOM_NAME, this.customName);
            }
        }
    }

    public void onGuiSave() {
        if (this.parentStack != null) {
            this.save();
        }
    }

    public void save() {
        NBTTagCompound nbtTagCompound = this.parentStack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
            UUID uuid = UUID.randomUUID();
            nbtTagCompound.func_74772_a(UUID_MOST_SIG, uuid.getMostSignificantBits());
            nbtTagCompound.func_74772_a(UUID_LEAST_SIG, uuid.getLeastSignificantBits());
        }
        this.writeToNBT(nbtTagCompound);
        this.parentStack.func_77982_d(nbtTagCompound);
    }

    public boolean matchesParentStack(ItemStack stack) {
        if (stack != null && ModItems.portableTablet == stack.func_77973_b()) {
            if (this.uuid == null) {
                return true;
            }
            if (stack.field_77990_d != null && stack.field_77990_d.func_150297_b(UUID_MOST_SIG, 4) && stack.field_77990_d.func_150297_b(UUID_LEAST_SIG, 4)) {
                return this.uuid.getMostSignificantBits() == stack.field_77990_d.func_74763_f(UUID_MOST_SIG) && this.uuid.getLeastSignificantBits() == stack.field_77990_d.func_74763_f(UUID_LEAST_SIG);
            }
        }
        return false;
    }

    public EnergyValue getAvailableEnergyValue() {
        return this.availableEnergyValue;
    }

    public EnergyValue getStoredEnergyValue() {
        return this.storedEnergyValue;
    }

    public World getWorld() {
        return this.world;
    }
}

