/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.simplecondenser.core.network;

import com.pahimar.ee3.knowledge.TransmutationKnowledge;
import com.pahimar.ee3.util.CompressionHelper;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.Collection;
import java.util.UUID;
import net.lomeli.lomlib.core.network.AbstractPacket;
import net.lomeli.lomlib.core.network.SidedPacket;
import net.lomeli.simplecondenser.inventory.ContainerPortableTablet;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

@SidedPacket(acceptedServerSide=false)
public class PacketKnowledgeUpdate
extends AbstractPacket {
    private TransmutationKnowledge transmutationKnowledge;
    private UUID playerUUID;
    private int dim;

    public PacketKnowledgeUpdate() {
    }

    public PacketKnowledgeUpdate(int dim, UUID uuid, Collection<ItemStack> knownTransmutationsCollection) {
        this.dim = dim;
        this.playerUUID = uuid;
        this.transmutationKnowledge = new TransmutationKnowledge();
        if (knownTransmutationsCollection != null) {
            this.transmutationKnowledge = new TransmutationKnowledge(knownTransmutationsCollection);
        }
    }

    public void encodeInto(ByteBuf buffer) {
        buffer.writeLong(this.playerUUID.getMostSignificantBits());
        buffer.writeLong(this.playerUUID.getLeastSignificantBits());
        buffer.writeInt(this.dim);
        byte[] compressedString = null;
        if (this.transmutationKnowledge != null) {
            compressedString = CompressionHelper.compressStringToByteArray((String)this.transmutationKnowledge.toJson());
        }
        if (compressedString != null) {
            buffer.writeInt(compressedString.length);
            buffer.writeBytes(compressedString);
        } else {
            buffer.writeInt(0);
        }
    }

    public void decodeInto(ByteBuf buffer) {
        long most = buffer.readLong();
        long least = buffer.readLong();
        this.playerUUID = new UUID(most, least);
        this.dim = buffer.readInt();
        byte[] compressedString = null;
        int readableBytes = buffer.readInt();
        if (readableBytes > 0) {
            compressedString = buffer.readBytes(readableBytes).array();
        }
        if (compressedString != null) {
            String uncompressedString = CompressionHelper.decompressStringFromByteArray(compressedString);
            this.transmutationKnowledge = TransmutationKnowledge.createFromJson((String)uncompressedString);
        }
    }

    public void handlePacket(Side side) {
        EntityPlayer player = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dim).func_152378_a(this.playerUUID);
        if (player != null && FMLClientHandler.instance().getClient().field_71462_r != null && FMLClientHandler.instance().getClient().field_71462_r instanceof GuiContainer) {
            ContainerPortableTablet tablet;
            GuiContainer guiContainer = (GuiContainer)FMLClientHandler.instance().getClient().field_71462_r;
            if (guiContainer.field_147002_h instanceof ContainerPortableTablet && (tablet = (ContainerPortableTablet)guiContainer.field_147002_h).func_75145_c(player)) {
                tablet.handleTransmutationKnowledgeUpdate(this.transmutationKnowledge);
            }
        }
    }
}

