/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.main.event;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.IGrowable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.enchant.EnchantmentManager;
import pixlepix.auracascade.main.AuraUtil;

public class EnchantEventHandler {
    static Method dropCommon;
    static Method dropRare;
    Block[] ores = new Block[]{Blocks.field_150450_ax, Blocks.field_150369_x, Blocks.field_150366_p, Blocks.field_150352_o, Blocks.field_150365_q, Blocks.field_150365_q, Blocks.field_150482_ag, Blocks.field_150412_bA, Blocks.field_150439_ay, Blocks.field_150449_bY};

    public static void init() {
        dropCommon = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"func_70628_a", "dropFewItems"}, (Class[])new Class[]{Boolean.TYPE, Integer.TYPE});
        dropRare = ReflectionHelper.findMethod(EntityLivingBase.class, null, (String[])new String[]{"func_70600_l", "dropRareDrop"}, (Class[])new Class[]{Integer.TYPE});
    }

    public static ItemStack getDoubleResult(ItemStack stack) {
        int[] oreIds;
        for (int id : oreIds = OreDictionary.getOreIDs((ItemStack)stack)) {
            String dustName;
            String oreName = OreDictionary.getOreName((int)id);
            if (!StringUtils.startsWith((CharSequence)oreName, (CharSequence)"ore") || OreDictionary.getOres((String)(dustName = StringUtils.replace((String)oreName, (String)"ore", (String)"ingot"))).size() == 0) continue;
            ItemStack result = (ItemStack)OreDictionary.getOres((String)dustName).get(0);
            result.field_77994_a = 2;
            return result;
        }
        return stack;
    }

    public int[] getEffectData(ItemStack stack) {
        return new int[]{EnchantmentHelper.func_77506_a((int)EnchantmentManager.red.field_77352_x, (ItemStack)stack), EnchantmentHelper.func_77506_a((int)EnchantmentManager.orange.field_77352_x, (ItemStack)stack), EnchantmentHelper.func_77506_a((int)EnchantmentManager.yellow.field_77352_x, (ItemStack)stack), EnchantmentHelper.func_77506_a((int)EnchantmentManager.green.field_77352_x, (ItemStack)stack), EnchantmentHelper.func_77506_a((int)EnchantmentManager.blue.field_77352_x, (ItemStack)stack), EnchantmentHelper.func_77506_a((int)EnchantmentManager.purple.field_77352_x, (ItemStack)stack)};
    }

    public int getIndexFromAura(EnumAura aura) {
        if (aura == EnumAura.RED_AURA) {
            return 0;
        }
        if (aura == EnumAura.ORANGE_AURA) {
            return 1;
        }
        if (aura == EnumAura.YELLOW_AURA) {
            return 2;
        }
        if (aura == EnumAura.GREEN_AURA) {
            return 3;
        }
        if (aura == EnumAura.BLUE_AURA) {
            return 4;
        }
        if (aura == EnumAura.VIOLET_AURA) {
            return 5;
        }
        return -1;
    }

    public int getEffectStrength(ItemStack stack, EnumAura aura) {
        return this.getEffectData(stack)[this.getIndexFromAura(aura)];
    }

    public int getEffectStrength(ItemStack stack, EnumAura aura, EnumAura aura2) {
        return (int)Math.ceil(Math.sqrt(this.getEffectStrength(stack, aura) * this.getEffectStrength(stack, aura2)));
    }

    public boolean canMultiplyDrops(BlockEvent.HarvestDropsEvent event) {
        for (ItemStack drop : event.drops) {
            if (EnchantEventHandler.getDoubleResult(drop) == drop) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onHarvestEvent(BlockEvent.HarvestDropsEvent event) {
        Block block = event.block;
        World world = event.world;
        if (event.harvester != null && event.harvester.field_71071_by.func_70448_g() != null) {
            ItemStack stack = event.harvester.field_71071_by.func_70448_g();
            int multiply = this.getEffectStrength(stack, EnumAura.RED_AURA, EnumAura.YELLOW_AURA);
            if (new Random().nextInt(4) < multiply && this.canMultiplyDrops(event)) {
                ArrayList<ItemStack> newDrops = new ArrayList<ItemStack>(event.drops.size());
                for (ItemStack dropStack : event.drops) {
                    newDrops.add(EnchantEventHandler.getDoubleResult(dropStack));
                }
                event.drops.clear();
                event.drops.addAll(newDrops);
            } else if (this.getEffectStrength(stack, EnumAura.RED_AURA) > 0 && block.canSilkHarvest(world, event.harvester, event.x, event.y, event.z, event.blockMetadata)) {
                event.dropChance = 0.0f;
                event.drops.clear();
                ItemStack itemstack = this.createStackedBlock(block, event.blockMetadata);
                if (itemstack != null) {
                    this.dropBlockAsItem(world, event.x, event.y, event.z, itemstack);
                }
            } else {
                int fortune = this.getEffectStrength(stack, EnumAura.YELLOW_AURA, EnumAura.YELLOW_AURA);
                if (fortune != 0 && event.fortuneLevel < fortune && !(event.block instanceof BlockCrops)) {
                    event.dropChance = 0.0f;
                    event.drops.clear();
                    event.block.func_149690_a(event.world, event.x, event.y, event.z, event.blockMetadata, 1.0f, fortune);
                }
            }
        }
    }

    @SubscribeEvent
    public void onAttack(AttackEntityEvent event) {
        int fire;
        int lifeSteal;
        int recoil;
        int knockback;
        EntityPlayer player = event.entityPlayer;
        ItemStack tool = player.func_70694_bm();
        int areaOfEffect = this.getEffectStrength(tool, EnumAura.VIOLET_AURA, EnumAura.BLUE_AURA);
        if (areaOfEffect != 0) {
            World world = event.target.field_70170_p;
            List list = world.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)(event.target.field_70165_t - 2.0), (double)(event.target.field_70163_u - 2.0), (double)(event.target.field_70161_v - 2.0), (double)(event.target.field_70165_t + 2.0), (double)(event.target.field_70163_u + 2.0), (double)(event.target.field_70161_v + 2.0)));
            for (EntityLivingBase entityLivingBase : list) {
                if (entityLivingBase == event.entityLiving || entityLivingBase == event.target) continue;
                entityLivingBase.func_70097_a(DamageSource.func_76354_b((Entity)event.entityPlayer, (Entity)event.target), (float)areaOfEffect);
                int fire2 = this.getEffectStrength(tool, EnumAura.YELLOW_AURA, EnumAura.BLUE_AURA);
                if (fire2 <= 0) continue;
                entityLivingBase.func_70015_d(10 * fire2);
            }
        }
        if ((knockback = this.getEffectStrength(tool, EnumAura.BLUE_AURA, EnumAura.BLUE_AURA)) > 0 && !event.target.func_85032_ar()) {
            event.target.func_70024_g((double)(-MathHelper.func_76126_a((float)(event.entity.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(event.entity.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
        }
        if ((recoil = this.getEffectStrength(tool, EnumAura.RED_AURA, EnumAura.BLUE_AURA)) > 0) {
            event.entityPlayer.func_70097_a(DamageSource.func_76354_b((Entity)event.entityPlayer, (Entity)event.entityPlayer), (float)recoil);
        }
        if ((lifeSteal = this.getEffectStrength(tool, EnumAura.GREEN_AURA, EnumAura.BLUE_AURA)) > 0) {
            event.entityPlayer.func_70691_i((float)Math.ceil(lifeSteal / 2));
        }
        if ((fire = this.getEffectStrength(tool, EnumAura.YELLOW_AURA, EnumAura.BLUE_AURA)) > 0) {
            event.target.func_70015_d(20 * fire);
        }
    }

    @SubscribeEvent
    public void getDamage(LivingHurtEvent attackEvent) {
        int protection;
        ItemStack heldStack;
        if (attackEvent.source != null && attackEvent.source.func_76346_g() instanceof EntityPlayer) {
            int dullness;
            ItemStack tool = ((EntityPlayer)attackEvent.source.func_76346_g()).func_70694_bm();
            int sharpness = this.getEffectStrength(tool, EnumAura.VIOLET_AURA, EnumAura.VIOLET_AURA);
            if (sharpness > 0) {
                attackEvent.ammount = (float)((double)attackEvent.ammount + 0.5 * (double)sharpness);
            }
            if ((dullness = this.getEffectStrength(tool, EnumAura.VIOLET_AURA, EnumAura.GREEN_AURA)) > 0) {
                attackEvent.ammount -= (float)dullness;
                if (attackEvent.ammount < 0.0f) {
                    attackEvent.ammount = 0.0f;
                }
            }
        }
        if (attackEvent.entity instanceof EntityPlayer && (heldStack = ((EntityPlayer)attackEvent.entity).func_70694_bm()) != null && (protection = this.getEffectStrength(heldStack, EnumAura.RED_AURA, EnumAura.VIOLET_AURA)) > 0) {
            attackEvent.ammount = (float)((double)attackEvent.ammount * Math.pow(0.9, protection));
        }
    }

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        int silk;
        int harvester;
        Block block;
        ItemStack stack = event.getPlayer().func_71045_bC();
        int treeFeller = this.getEffectStrength(stack, EnumAura.GREEN_AURA, EnumAura.GREEN_AURA) * 25;
        if (treeFeller > 0 && !event.world.field_72995_K && ((block = event.world.func_147439_a(event.x, event.y, event.z)) == Blocks.field_150364_r || block == Blocks.field_150363_s || this.containsOredict(block, "log"))) {
            ArrayList<CoordTuple> checkedLocations = new ArrayList<CoordTuple>();
            ArrayList<CoordTuple> toSearch = new ArrayList<CoordTuple>();
            toSearch.add(new CoordTuple(event.x, event.y, event.z));
            while (toSearch.size() > 0 && treeFeller > 0) {
                CoordTuple nextTuple = (CoordTuple)toSearch.remove(0);
                event.world.func_147480_a(nextTuple.getX(), nextTuple.getY(), nextTuple.getZ(), true);
                --treeFeller;
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    CoordTuple newTuple = nextTuple.add(direction);
                    if (newTuple.getBlock(event.world) != block || checkedLocations.contains(newTuple)) continue;
                    toSearch.add(newTuple);
                    checkedLocations.add(newTuple);
                }
            }
        }
        if ((harvester = this.getEffectStrength(stack, EnumAura.GREEN_AURA, EnumAura.YELLOW_AURA) * 25) > 0 && !event.world.field_72995_K) {
            Block block2 = event.world.func_147439_a(event.x, event.y, event.z);
            int meta = event.world.func_72805_g(event.x, event.y, event.z);
            if (block2 instanceof IGrowable && block2 != Blocks.field_150349_c) {
                ArrayList<CoordTuple> checkedLocations = new ArrayList<CoordTuple>();
                ArrayList<CoordTuple> toSearch = new ArrayList<CoordTuple>();
                toSearch.add(new CoordTuple(event.x, event.y, event.z));
                while (toSearch.size() > 0 && harvester > 0) {
                    CoordTuple nextTuple = (CoordTuple)toSearch.remove(0);
                    event.world.func_147480_a(nextTuple.getX(), nextTuple.getY(), nextTuple.getZ(), true);
                    --harvester;
                    for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                        CoordTuple newTuple = nextTuple.add(direction);
                        if (newTuple.getBlock(event.world) != block2 || checkedLocations.contains(newTuple) || newTuple.getMeta(event.world) != meta) continue;
                        toSearch.add(newTuple);
                        checkedLocations.add(newTuple);
                    }
                }
            }
        }
        if ((silk = this.getEffectStrength(stack, EnumAura.RED_AURA)) > 0) {
            event.setExpToDrop(0);
        }
    }

    @SubscribeEvent
    public void onDrops(LivingDropsEvent event) {
        ItemStack stack;
        int looting;
        Entity entity = event.source.func_76364_f();
        if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K && (looting = this.getEffectStrength(stack = ((EntityPlayer)entity).func_70694_bm(), EnumAura.VIOLET_AURA, EnumAura.YELLOW_AURA)) > 0) {
            try {
                dropCommon.invoke((Object)event.entity, true, looting);
                int j = new Random().nextInt(200) - looting;
                if (j < 5) {
                    dropRare.invoke((Object)event.entity, j <= 0 ? 1 : 0);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onGetBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.entityPlayer.field_71071_by.func_70448_g() != null) {
            ItemStack tool = event.entityPlayer.field_71071_by.func_70448_g();
            int miningDebuff = this.getEffectStrength(tool, EnumAura.RED_AURA, EnumAura.GREEN_AURA);
            if (miningDebuff > 0) {
                event.newSpeed = (float)((double)event.newSpeed / Math.pow(3.0, miningDebuff));
            }
            if (ForgeHooks.canToolHarvestBlock((Block)event.block, (int)event.metadata, (ItemStack)tool)) {
                int logSpeed;
                int stone;
                int oreSpeed;
                Block block = event.block;
                int efficiency = this.getEffectStrength(tool, EnumAura.ORANGE_AURA, EnumAura.ORANGE_AURA);
                event.newSpeed = (float)((double)event.newSpeed * Math.pow(1.15, efficiency));
                int shatter = this.getEffectStrength(tool, EnumAura.ORANGE_AURA, EnumAura.VIOLET_AURA);
                if (shatter > 0 && event.block.func_149712_f(event.entity.field_70170_p, event.x, event.y, event.z) >= 3.0f) {
                    event.newSpeed = (float)((double)event.newSpeed * Math.pow(1.5, shatter));
                }
                if ((oreSpeed = this.getEffectStrength(tool, EnumAura.RED_AURA, EnumAura.ORANGE_AURA)) > 0 && (Arrays.asList(this.ores).contains(event.block) || this.containsOredict(block, "ore"))) {
                    event.newSpeed = (float)((double)event.newSpeed * Math.pow(1.25, oreSpeed));
                }
                if ((stone = this.getEffectStrength(tool, EnumAura.YELLOW_AURA, EnumAura.ORANGE_AURA)) > 0 && Blocks.field_150348_b == block) {
                    event.newSpeed = (float)((double)event.newSpeed * Math.pow(1.25, stone));
                }
                if ((logSpeed = this.getEffectStrength(tool, EnumAura.ORANGE_AURA, EnumAura.GREEN_AURA)) > 0 && block == Blocks.field_150364_r || block == Blocks.field_150363_s || this.containsOredict(block, "log")) {
                    event.newSpeed = (float)((double)event.newSpeed * Math.pow(1.25, logSpeed));
                }
                int digSpeed = this.getEffectStrength(tool, EnumAura.ORANGE_AURA, EnumAura.GREEN_AURA);
                if (block == Blocks.field_150349_c || block == Blocks.field_150346_d || block == Blocks.field_150351_n || block == Blocks.field_150354_m) {
                    event.newSpeed = (float)((double)event.newSpeed * Math.pow(1.25, digSpeed));
                }
            }
        }
    }

    public boolean containsOredict(Block block, String name) {
        String oreName = OreDictionary.getOreIDs((ItemStack)new ItemStack(block)).length != 0 ? OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)new ItemStack(block))[0]) : null;
        return oreName != null && oreName.contains(name);
    }

    public ItemStack createStackedBlock(Block block, int meta) {
        int j = 0;
        Item item = Item.func_150898_a((Block)block);
        if (item != null && item.func_77614_k()) {
            j = meta;
        }
        return new ItemStack(item, 1, j);
    }

    protected void dropBlockAsItem(World world, int x, int y, int z, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            double d0 = AuraUtil.getDropOffset(world);
            double d1 = AuraUtil.getDropOffset(world);
            double d2 = AuraUtil.getDropOffset(world);
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }
}

