/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.main;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Comparator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.BlockMonitor;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.item.AngelsteelToolHelper;
import pixlepix.auracascade.network.PacketBurst;

public class AuraUtil {
    public static Comparator<ItemStack> comparator = new Comparator<ItemStack>(){

        @Override
        public int compare(ItemStack itemStack1, ItemStack itemStack2) {
            if (itemStack1 != null && itemStack2 != null) {
                if (Item.func_150891_b((Item)itemStack1.func_77973_b()) - Item.func_150891_b((Item)itemStack2.func_77973_b()) == 0) {
                    if (itemStack1.func_77973_b() == itemStack2.func_77973_b()) {
                        if (itemStack1.func_77960_j() == itemStack2.func_77960_j()) {
                            if (itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                                if (ItemStack.func_77970_a((ItemStack)itemStack1, (ItemStack)itemStack2)) {
                                    return itemStack1.field_77994_a - itemStack2.field_77994_a;
                                }
                                return itemStack1.func_77978_p().hashCode() - itemStack2.func_77978_p().hashCode();
                            }
                            if (!itemStack1.func_77942_o() && itemStack2.func_77942_o()) {
                                return -1;
                            }
                            if (itemStack1.func_77942_o() && !itemStack2.func_77942_o()) {
                                return 1;
                            }
                            return itemStack1.field_77994_a - itemStack2.field_77994_a;
                        }
                        return itemStack1.func_77960_j() - itemStack2.func_77960_j();
                    }
                    return itemStack1.func_77973_b().func_77667_c(itemStack1).compareToIgnoreCase(itemStack2.func_77973_b().func_77667_c(itemStack2));
                }
                return Item.func_150891_b((Item)itemStack1.func_77973_b()) - Item.func_150891_b((Item)itemStack2.func_77973_b());
            }
            if (itemStack1 != null) {
                return -1;
            }
            if (itemStack2 != null) {
                return 1;
            }
            return 0;
        }
    };

    public static void keepAlive(TileEntity te, int range) {
        List nearbyItems = te.func_145831_w().func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(te.field_145851_c - range), (double)(te.field_145848_d - range), (double)(te.field_145849_e - range), (double)(te.field_145851_c + range), (double)(te.field_145848_d + range), (double)(te.field_145849_e + range)));
        for (EntityItem entityItem : nearbyItems) {
            entityItem.lifespan = Integer.MAX_VALUE;
            entityItem.field_70292_b = 0;
        }
    }

    public static String formatLocation(TileEntity te) {
        return te.field_145851_c + "|" + te.field_145848_d + "|" + te.field_145849_e;
    }

    public static String formatLocation(CoordTuple te) {
        return te.getX() + "|" + te.getY() + "|" + te.getZ();
    }

    public static String formatLocation(Entity entity) {
        return entity.field_70165_t + "|" + entity.field_70163_u + "|" + entity.field_70161_v;
    }

    public static void updateMonitor(World w, int x, int y, int z) {
        for (ForgeDirection d1 : ForgeDirection.VALID_DIRECTIONS) {
            Block b = new CoordTuple(x, y, z).add(d1).getBlock(w);
            if (!(b instanceof BlockMonitor)) continue;
            for (ForgeDirection d2 : ForgeDirection.VALID_DIRECTIONS) {
                CoordTuple tuple = new CoordTuple(x, y, z).add(d2).add(d1);
                Block b2 = tuple.getBlock(w);
                b2.func_149695_a(w, tuple.getX(), tuple.getY(), tuple.getZ(), b);
            }
        }
    }

    public static void respawnItemWithParticles(World worldObj, EntityItem oldItem, ItemStack stack) {
        EntityItem newEntity = new EntityItem(worldObj, oldItem.field_70165_t, oldItem.field_70163_u, oldItem.field_70161_v, stack);
        newEntity.field_145804_b = oldItem.field_145804_b;
        newEntity.field_70159_w = oldItem.field_70159_w;
        newEntity.field_70181_x = oldItem.field_70181_x;
        newEntity.field_70179_y = oldItem.field_70179_y;
        worldObj.func_72838_d((Entity)newEntity);
        AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(1, newEntity.field_70165_t, newEntity.field_70163_u, newEntity.field_70161_v), new NetworkRegistry.TargetPoint(worldObj.field_73011_w.field_76574_g, (double)((int)oldItem.field_70165_t), (double)((int)oldItem.field_70163_u), (double)((int)oldItem.field_70161_v), 32.0));
    }

    public static ItemStack decrStackSize(IInventory tile, int slot, int amt) {
        ItemStack stack = tile.func_70301_a(slot);
        if (stack != null) {
            if (stack.field_77994_a <= amt) {
                tile.func_70299_a(slot, null);
            } else {
                stack = stack.func_77979_a(amt);
                if (stack.field_77994_a == 0) {
                    tile.func_70299_a(slot, null);
                }
            }
        }
        ((TileEntity)tile).func_145831_w().func_147471_g(((TileEntity)tile).field_145851_c, ((TileEntity)tile).field_145848_d, ((TileEntity)tile).field_145849_e);
        return stack;
    }

    public static void addAngelsteelDesc(List infoList, ItemStack stack) {
        if (AngelsteelToolHelper.hasValidBuffs(stack)) {
            int[] buffs = AngelsteelToolHelper.readFromNBT(stack.field_77990_d);
            infoList.add("Angel's Efficiency: " + buffs[0]);
            infoList.add("Angel's Fortune: " + buffs[1]);
            infoList.add("Angel's Shatter: " + buffs[2]);
            infoList.add("Angel's Disintegrate: " + buffs[3]);
        }
    }

    public static double getDropOffset(World w) {
        return (double)w.field_73012_v.nextFloat() * 0.7 + 0.15000000000000002;
    }

    public static void diamondBurst(Entity entity, String particle) {
        CoordTuple centerTuple = new CoordTuple((int)entity.field_70165_t, (int)entity.field_70163_u + 1, (int)entity.field_70161_v);
        CoordTuple topTuple = centerTuple.add(ForgeDirection.UP, 5);
        ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.WEST, ForgeDirection.SOUTH};
        for (int i = 0; i < directions.length; ++i) {
            ForgeDirection primaryDirection = directions[i];
            ForgeDirection connectingDirection = directions[i + 1 < directions.length ? i + 1 : 0];
            CoordTuple corner = centerTuple.add(primaryDirection, 5);
            CoordTuple connectingCorner = centerTuple.add(connectingDirection, 5);
            AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(corner, centerTuple, particle, 1.0, 1.0, 1.0, 1.0), new NetworkRegistry.TargetPoint(entity.field_70170_p.field_73011_w.field_76574_g, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 32.0));
            AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(corner, connectingCorner, particle, 1.0, 1.0, 1.0, 1.0), new NetworkRegistry.TargetPoint(entity.field_70170_p.field_73011_w.field_76574_g, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 32.0));
            AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(corner, topTuple, particle, 1.0, 1.0, 1.0, 1.0), new NetworkRegistry.TargetPoint(entity.field_70170_p.field_73011_w.field_76574_g, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 32.0));
        }
    }
}

