/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.lexicon;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import pixlepix.auracascade.lexicon.ClientTickHandler;
import pixlepix.auracascade.lexicon.GuiLexicon;
import pixlepix.auracascade.lexicon.IGuiLexiconEntry;
import pixlepix.auracascade.lexicon.IParented;
import pixlepix.auracascade.lexicon.LexiconEntry;
import pixlepix.auracascade.lexicon.LexiconPage;
import pixlepix.auracascade.lexicon.button.GuiButtonBackWithShift;
import pixlepix.auracascade.lexicon.button.GuiButtonPage;

public class GuiLexiconEntry
extends GuiLexicon
implements IGuiLexiconEntry,
IParented {
    public int page = 0;
    LexiconEntry entry;
    GuiScreen parent;
    String title;
    String subtitle;
    GuiButton leftButton;
    GuiButton rightButton;
    GuiButton backButton;
    GuiButton shareButton;
    int fx = 0;
    boolean swiped = false;

    public GuiLexiconEntry(LexiconEntry entry, GuiScreen parent) {
        this.entry = entry;
        this.parent = parent;
        this.title = StatCollector.func_74838_a((String)entry.getUnlocalizedName()) + entry.getSuffix();
    }

    public void func_146285_a(ItemStack p_146285_1_, int p_146285_2_, int p_146285_3_) {
        List list = p_146285_1_.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, this.field_146297_k.field_71474_y.field_82882_x);
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, p_146285_1_.func_77953_t().field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, EnumChatFormatting.GRAY + (String)list.get(k));
        }
        FontRenderer font = p_146285_1_.func_77973_b().getFontRenderer(p_146285_1_);
        this.drawHoveringText(list, p_146285_2_, p_146285_3_, font == null ? this.field_146289_q : font);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.backButton = new GuiButtonBackWithShift(0, this.left + this.guiWidth / 2 - 8, this.top + this.guiHeight + 2);
        this.field_146292_n.add(this.backButton);
        this.leftButton = new GuiButtonPage(1, this.left, this.top + this.guiHeight - 10, false);
        this.field_146292_n.add(this.leftButton);
        this.rightButton = new GuiButtonPage(2, this.left + this.guiWidth - 18, this.top + this.guiHeight - 10, true);
        this.field_146292_n.add(this.rightButton);
        LexiconPage page = this.entry.pages.get(this.page);
        page.onOpened(this);
        this.updatePageButtons();
        this.positionTutorialArrow();
    }

    @Override
    public LexiconEntry getEntry() {
        return this.entry;
    }

    @Override
    public int getPageOn() {
        return this.page;
    }

    @Override
    void drawHeader() {
    }

    @Override
    String getTitle() {
        return String.format("%s " + EnumChatFormatting.ITALIC + "(%s/%s)", this.title, this.page + 1, this.entry.pages.size());
    }

    @Override
    String getSubtitle() {
        return this.subtitle;
    }

    @Override
    boolean isCategoryIndex() {
        return false;
    }

    @Override
    protected void func_146284_a(GuiButton par1GuiButton) {
        LexiconPage currentPage = this.entry.pages.get(this.page);
        if (par1GuiButton.field_146127_k >= 1337) {
            this.handleBookmark(par1GuiButton);
        } else {
            switch (par1GuiButton.field_146127_k) {
                case 0: {
                    currentPage.onClosed(this);
                    this.field_146297_k.func_147108_a((GuiScreen)(GuiScreen.func_146272_n() ? new GuiLexicon() : this.parent));
                    ClientTickHandler.notifyPageChange();
                    break;
                }
                case 1: {
                    currentPage.onClosed(this);
                    --this.page;
                    LexiconPage newPage = this.entry.pages.get(this.page);
                    newPage.onOpened(this);
                    ClientTickHandler.notifyPageChange();
                    break;
                }
                case 2: {
                    currentPage.onClosed(this);
                    ++this.page;
                    LexiconPage newPage = this.entry.pages.get(this.page);
                    newPage.onOpened(this);
                    ClientTickHandler.notifyPageChange();
                    break;
                }
                case 3: {
                    Minecraft mc = Minecraft.func_71410_x();
                    String cmd = "/botania-share " + this.entry.unlocalizedName;
                    mc.field_71456_v.func_146158_b().func_146239_a(cmd);
                    mc.field_71439_g.func_71165_d(cmd);
                }
            }
        }
        this.updatePageButtons();
        currentPage.onActionPerformed(par1GuiButton);
    }

    public void updatePageButtons() {
        this.leftButton.field_146124_l = this.page != 0;
        this.rightButton.field_146124_l = this.page + 1 < this.entry.pages.size();
    }

    @Override
    public void func_73863_a(int par1, int par2, float par3) {
        super.func_73863_a(par1, par2, par3);
        LexiconPage page = this.entry.pages.get(this.page);
        page.renderScreen(this, par1, par2);
    }

    public void func_73876_c() {
        LexiconEntry entry;
        LexiconPage page = this.entry.pages.get(this.page);
        page.updateScreen();
        if (this.page == this.entry.pages.size() - 1 && (entry = (LexiconEntry)tutorial.peek()) == this.entry) {
            tutorial.poll();
            this.positionTutorialArrow();
            if (tutorial.isEmpty()) {
                this.field_146297_k.field_71439_g.func_145747_a(new ChatComponentTranslation("aura.tutorialEnded", new Object[0]).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.RED)));
                this.hasTutorialArrow = false;
            }
        }
    }

    @Override
    public void positionTutorialArrow() {
        LexiconEntry entry = (LexiconEntry)tutorial.peek();
        if (this.backButton != null && entry != this.entry) {
            this.orientTutorialArrowWithButton(this.backButton);
            return;
        }
        if (this.rightButton != null && this.rightButton.field_146124_l && this.rightButton.field_146125_m) {
            this.orientTutorialArrowWithButton(this.rightButton);
        }
    }

    @Override
    public int getLeft() {
        return this.left;
    }

    @Override
    public int getTop() {
        return this.top;
    }

    @Override
    public int getWidth() {
        return this.guiWidth;
    }

    @Override
    public int getHeight() {
        return this.guiHeight;
    }

    @Override
    public float getZLevel() {
        return this.field_73735_i;
    }

    @Override
    public void setParent(GuiLexicon gui) {
        this.parent = gui;
    }

    protected void func_146273_a(int x, int y, int button, long time) {
        if (button == 0 && Math.abs(x - this.fx) > 100 && this.field_146297_k.field_71474_y.field_85185_A && !this.swiped) {
            double swipe = (double)(x - this.fx) / Math.max(1.0, (double)time);
            if (swipe < 0.5) {
                this.nextPage();
                this.swiped = true;
            } else if (swipe > 0.5) {
                this.prevPage();
                this.swiped = true;
            }
        }
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.fx = par1;
        if (par3 == 1) {
            this.back();
        }
    }

    public void func_146274_d() {
        int w;
        super.func_146274_d();
        if (Mouse.getEventButton() == 0) {
            this.swiped = false;
        }
        if ((w = Mouse.getEventDWheel()) < 0) {
            this.nextPage();
        } else if (w > 0) {
            this.prevPage();
        }
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        LexiconPage page = this.entry.pages.get(this.page);
        page.onKeyPressed(par1, par2);
        if (par2 == 203 || par2 == 200 || par2 == 201) {
            this.prevPage();
        } else if (par2 == 205 || par2 == 208 || par2 == 209) {
            this.nextPage();
        } else if (par2 == 14) {
            this.back();
        } else if (par2 == 199) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiLexicon());
            ClientTickHandler.notifyPageChange();
        }
        super.func_73869_a(par1, par2);
    }

    void back() {
        if (this.backButton.field_146124_l) {
            this.func_146284_a(this.backButton);
            this.backButton.func_146113_a(this.field_146297_k.func_147118_V());
        }
    }

    void nextPage() {
        if (this.rightButton.field_146124_l) {
            this.func_146284_a(this.rightButton);
            this.rightButton.func_146113_a(this.field_146297_k.func_147118_V());
        }
    }

    void prevPage() {
        if (this.leftButton.field_146124_l) {
            this.func_146284_a(this.leftButton);
            this.leftButton.func_146113_a(this.field_146297_k.func_147118_V());
        }
    }

    @Override
    public List<GuiButton> getButtonList() {
        return this.field_146292_n;
    }

    @Override
    public float getElapsedTicks() {
        return this.lastTime;
    }

    @Override
    public float getPartialTicks() {
        return this.partialTicks;
    }

    @Override
    public float getTickDelta() {
        return this.timeDelta;
    }
}

