/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.item;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.BlockStorageBookshelf;
import pixlepix.auracascade.block.tile.TileStorageBookshelf;
import pixlepix.auracascade.registry.BlockRegistry;
import pixlepix.auracascade.registry.ITTinkererItem;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;

public abstract class ItemStorageBook
extends Item
implements ITTinkererItem {
    public ItemStorageBook() {
        this.func_77625_d(1);
    }

    public static void setInventory(ItemStack stack, ArrayList<ItemStack> newInventory) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        NBTTagList list = new NBTTagList();
        for (ItemStack itemStack : newInventory) {
            NBTTagCompound nbt = new NBTTagCompound();
            if (itemStack != null) {
                itemStack.func_77955_b(nbt);
            }
            list.func_74742_a((NBTBase)nbt);
        }
        stack.field_77990_d.func_74782_a("items", (NBTBase)list);
    }

    public boolean isValid(ItemStack stack, Block[] blocks, Item[] items, String[] ores) {
        Item item = stack.func_77973_b();
        if (blocks != null && Block.func_149634_a((Item)item) != null) {
            Block block = Block.func_149634_a((Item)item);
            if (Arrays.asList(blocks).contains(block)) {
                return true;
            }
        }
        if (items != null && Arrays.asList(items).contains(item)) {
            return true;
        }
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        if (ores != null) {
            for (int i : ids) {
                String s = OreDictionary.getOreName((int)i);
                if (!Arrays.asList(ores).contains(s.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public ArrayList<ItemStack> getInventory(ItemStack stack) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        NBTTagCompound compound = stack.field_77990_d;
        if (compound != null) {
            NBTTagList itemsList = compound.func_150295_c("items", 10);
            for (int i = 0; i < itemsList.func_74745_c(); ++i) {
                NBTTagCompound itemCompound = itemsList.func_150305_b(i);
                result.add(itemCompound.func_74764_b("Count") ? ItemStack.func_77949_a((NBTTagCompound)itemCompound) : null);
            }
        }
        while (result.size() < this.getActualCount()) {
            result.add(null);
        }
        return result;
    }

    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a("aura:storageBook");
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        return null;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && (world.func_147439_a(x, y, z) != null && world.func_147439_a(x, y, z) == AuraCascade.proxy.chiselBookshelf || world.func_147439_a(x, y, z) == Blocks.field_150342_X)) {
            world.func_147449_b(x, y, z, BlockRegistry.getFirstBlockFromClass(BlockStorageBookshelf.class));
            TileStorageBookshelf te = (TileStorageBookshelf)world.func_147438_o(x, y, z);
            te.storedBook = stack.func_77946_l();
            te.func_70296_d();
            world.func_147471_g(x, y, z);
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
            return true;
        }
        return false;
    }

    public abstract int getMaxStackSize();

    public abstract int getHeldStacks();

    public abstract boolean isItemValid(ItemStack var1, TileStorageBookshelf var2);

    public int getActualCount() {
        return (int)(Math.ceil((float)this.getMaxStackSize() / 64.0f) * (double)this.getHeldStacks());
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        return null;
    }

    @Override
    public int getCreativeTabPriority() {
        return -18;
    }
}

