/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.item;

import java.util.ArrayList;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.EnumHelper;
import pixlepix.auracascade.item.ItemAngelsteelAxe;
import pixlepix.auracascade.item.ItemAngelsteelPickaxe;
import pixlepix.auracascade.item.ItemAngelsteelShovel;

public class AngelsteelToolHelper {
    public static final int MAX_DEGREE = 11;
    public static final String NBT_BUFF_ARRAY_NAME = "angelbuffs";
    public static final Item.ToolMaterial[] materials = new Item.ToolMaterial[11];

    public static ArrayList<Object> getDegreeList() {
        ArrayList<Object> integers = new ArrayList<Object>();
        for (int i = 1; i < 11; ++i) {
            integers.add(i);
        }
        return integers;
    }

    public static int[] getRandomBuffSet(int lvl) {
        int[] result = new int[4];
        Random rand = new Random();
        for (int i = 0; i < lvl * 2; ++i) {
            int n = rand.nextInt(4);
            result[n] = result[n] + 1;
        }
        return result;
    }

    public static void writeToNBT(NBTTagCompound nbtTagCompound, int[] buffs) {
        nbtTagCompound.func_74783_a(NBT_BUFF_ARRAY_NAME, buffs);
    }

    public static int[] readFromNBT(NBTTagCompound nbtTagCompound) {
        return nbtTagCompound.func_74759_k(NBT_BUFF_ARRAY_NAME);
    }

    public static boolean hasValidBuffs(ItemStack stack) {
        return stack.field_77990_d != null && stack.field_77990_d.func_74764_b(NBT_BUFF_ARRAY_NAME);
    }

    public static NBTTagCompound getRandomBuffCompound(int lvl) {
        NBTTagCompound compound = new NBTTagCompound();
        AngelsteelToolHelper.writeToNBT(compound, AngelsteelToolHelper.getRandomBuffSet(lvl));
        return compound;
    }

    public static boolean isAngelsteelTool(Item item) {
        return item instanceof ItemAngelsteelAxe || item instanceof ItemAngelsteelShovel || item instanceof ItemAngelsteelPickaxe;
    }

    public static void initMaterials() {
        for (int i = 0; i < 11; ++i) {
            AngelsteelToolHelper.materials[i] = EnumHelper.addToolMaterial((String)("ANGELSTEEL" + i), (int)5, (int)10, (float)((int)(5.0 * Math.pow(1.15, i))), (float)((int)(3.0 * Math.pow(1.15, i))), (int)10);
        }
    }
}

