/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.gui;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import pixlepix.auracascade.block.tile.TileBookshelfCoordinator;
import pixlepix.auracascade.block.tile.TileStorageBookshelf;
import pixlepix.auracascade.data.StorageItemStack;
import pixlepix.auracascade.gui.SlotCoordinator;

public class ContainerCoordinator
extends Container {
    public float lastScroll;
    protected TileBookshelfCoordinator tileEntity;
    private String lastFilter = "";

    public ContainerCoordinator(InventoryPlayer inventoryPlayer, TileBookshelfCoordinator te) {
        this.tileEntity = te;
        for (int i = 0; i < 21; ++i) {
            int x = i % 7;
            int y = i / 7;
            this.func_75146_a(new SlotCoordinator(i, 8 + x * 20, 17 + y * 18, te, null));
        }
        this.bindPlayerInventory(inventoryPlayer);
        this.scrollTo(0.0f);
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.tileEntity.neededPower <= this.tileEntity.lastPower;
    }

    protected void bindPlayerInventory(InventoryPlayer inventoryPlayer) {
        int x;
        int ys = 84;
        int xs = 8;
        for (x = 0; x < 3; ++x) {
            for (int y = 0; y < 9; ++y) {
                this.func_75146_a(new Slot((IInventory)inventoryPlayer, y + x * 9 + 9, xs + y * 18, ys + x * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)inventoryPlayer, x, xs + x * 18, ys + 58));
        }
    }

    public ItemStack func_82846_b(EntityPlayer player, int slot) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.field_75151_b.get(slot);
        if (slotObject != null && slotObject.func_75216_d()) {
            stack = slotObject.func_75211_c();
            if (slot < 21) {
                StorageItemStack storageItemStack = ((SlotCoordinator)((Object)this.field_75151_b.get((int)slot))).storage;
                storageItemStack.stackSize = storageItemStack.item.getItemStackLimit(storageItemStack.toItemStack());
                ItemStack stackLeftover = this.takeFromInventory(storageItemStack);
                if (stackLeftover != null) {
                    this.func_75135_a(stackLeftover, 21, 57, true);
                }
                if (stackLeftover != null) {
                    this.putIntoInventory(new StorageItemStack(stackLeftover));
                }
                this.update();
                slotObject.func_75220_a(stack, slotObject.func_75211_c());
                return null;
            }
            ItemStack stackToTransfer = slotObject.func_75211_c();
            ItemStack stackLeftover = this.putIntoInventory(new StorageItemStack(stackToTransfer));
            if (stackLeftover != null && stackLeftover.field_77994_a == stackToTransfer.field_77994_a) {
                return null;
            }
            slotObject.func_75215_d(stackLeftover);
            slotObject.func_75220_a(stack, stackLeftover);
        }
        this.update();
        return stack;
    }

    public void update() {
        this.scrollTo(this.lastScroll);
    }

    public void scrollTo(float scroll) {
        this.scrollTo(scroll, this.lastFilter);
    }

    public void scrollTo(float scroll, String filter) {
        if (!this.tileEntity.func_145831_w().field_72995_K) {
            this.tileEntity.func_145831_w().func_147471_g(this.tileEntity.field_145851_c, this.tileEntity.field_145848_d, this.tileEntity.field_145849_e);
        }
        this.lastFilter = filter;
        ArrayList stacks = (ArrayList)this.tileEntity.getAbstractInventory().clone();
        Iterator iter = stacks.iterator();
        while (iter.hasNext()) {
            StorageItemStack storageItemStack = (StorageItemStack)iter.next();
            String name = StatCollector.func_150826_b((String)(storageItemStack.toItemStack().func_77977_a() + ".name")).toUpperCase();
            if (name.contains(filter)) continue;
            iter.remove();
        }
        this.lastScroll = scroll;
        int i = stacks.size() / 7 - 2;
        int j = (int)((double)(scroll * (float)i) + 0.5);
        if (j < 0) {
            j = 0;
        }
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 7; ++l) {
                int i1 = l + (k + j) * 7;
                ((SlotCoordinator)this.func_75139_a((int)(l + k * 7))).storage = i1 >= 0 && i1 < stacks.size() ? (StorageItemStack)stacks.get(i1) : null;
            }
        }
    }

    public ItemStack takeFromInventory(StorageItemStack lost) {
        int amount = 0;
        block0: for (TileStorageBookshelf bookshelf : this.tileEntity.getBookshelves()) {
            for (int i = 0; i < bookshelf.func_70302_i_(); ++i) {
                ItemStack stackInShelf = bookshelf.func_70301_a(i);
                if (stackInShelf == null || !new StorageItemStack(stackInShelf).equalsType(lost)) continue;
                int delta = Math.min(lost.stackSize - amount, stackInShelf.field_77994_a);
                amount += delta;
                stackInShelf.field_77994_a -= delta;
                if (stackInShelf.field_77994_a == 0) {
                    bookshelf.func_70299_a(i, null);
                }
                bookshelf.func_70296_d();
                if (lost.stackSize <= 0) break block0;
            }
        }
        lost.stackSize = amount;
        return lost.stackSize != 0 ? lost.toItemStack() : null;
    }

    public ItemStack putIntoInventory(StorageItemStack gained) {
        int amount = gained.stackSize;
        if (amount != 0) {
            block0: for (TileStorageBookshelf bookshelf : this.tileEntity.getBookshelves()) {
                for (int i = 0; i < bookshelf.func_70302_i_(); ++i) {
                    ItemStack stackInShelf = bookshelf.func_70301_a(i);
                    ItemStack testStack = null;
                    if (stackInShelf != null && new StorageItemStack(stackInShelf).equalsType(gained)) {
                        testStack = stackInShelf.func_77946_l();
                    }
                    if (stackInShelf == null) {
                        testStack = gained.toItemStack();
                        testStack.field_77994_a = 0;
                    }
                    if (testStack != null) {
                        ItemStack nextTestStack = testStack.func_77946_l();
                        ++nextTestStack.field_77994_a;
                        while (amount > 0 && bookshelf.isItemValidForSlotSensitive(i, nextTestStack) && nextTestStack.field_77994_a <= testStack.func_77976_d()) {
                            testStack = nextTestStack.func_77946_l();
                            ++nextTestStack.field_77994_a;
                            --amount;
                        }
                        if (testStack.field_77994_a > 0) {
                            bookshelf.func_70299_a(i, testStack);
                        }
                        if (gained.stackSize <= 0) break block0;
                    }
                    if (bookshelf.func_70301_a(i) == null) continue block0;
                }
            }
        }
        StorageItemStack result = gained.copy();
        result.stackSize = amount;
        return result.toItemStack();
    }

    public ItemStack func_75144_a(int slot, int clickedButton, int mode, EntityPlayer player) {
        ItemStack itemstack = null;
        if (!(player.field_71071_by.func_70445_o() == null || slot != -999 || clickedButton != 0 && clickedButton != 1 || mode != 0 && mode != 1)) {
            if (clickedButton == 0) {
                player.func_71019_a(player.field_71071_by.func_70445_o(), true);
                player.field_71071_by.func_70437_b(null);
            }
            if (clickedButton == 1) {
                player.func_71019_a(player.field_71071_by.func_70445_o().func_77979_a(1), true);
                if (player.field_71071_by.func_70445_o().field_77994_a == 0) {
                    player.field_71071_by.func_70437_b(null);
                }
            }
        } else if (slot >= 0 && this.field_75151_b.get(slot) instanceof SlotCoordinator && mode != 1) {
            if (!(clickedButton != 0 && clickedButton != 1 || mode != 0 && mode != 5)) {
                StorageItemStack target = ((SlotCoordinator)((Object)this.field_75151_b.get((int)slot))).storage;
                if (target != null && player.field_71071_by.func_70445_o() == null) {
                    target = target.copy();
                    int maxStackSize = target.item.getItemStackLimit(target.toItemStack());
                    target.stackSize = clickedButton == 0 ? maxStackSize : maxStackSize / 2;
                    ItemStack result = this.takeFromInventory(target);
                    player.field_71071_by.func_70437_b(result);
                    ((SlotCoordinator)((Object)this.field_75151_b.get(slot))).func_82870_a(player, result);
                    this.update();
                } else if (player.field_71071_by.func_70445_o() != null) {
                    ItemStack leftovers;
                    ItemStack placedStack = player.field_71071_by.func_70445_o().func_77946_l();
                    int reservedItems = 0;
                    if (clickedButton == 1) {
                        reservedItems = placedStack.field_77994_a - 1;
                        placedStack.field_77994_a = 1;
                    }
                    if ((leftovers = this.putIntoInventory(new StorageItemStack(placedStack))) != null) {
                        leftovers.field_77994_a += reservedItems;
                    } else if (reservedItems > 0) {
                        leftovers = placedStack.func_77946_l();
                        leftovers.field_77994_a = reservedItems;
                    }
                    player.field_71071_by.func_70437_b(leftovers);
                    this.update();
                }
            }
        } else if (mode == 1) {
            ItemStack itemstack3;
            if (slot < 0) {
                return null;
            }
            Slot slot2 = (Slot)this.field_75151_b.get(slot);
            if (slot2 != null && slot2.func_82869_a(player) && (itemstack3 = this.func_82846_b(player, slot)) != null) {
                Item item = itemstack3.func_77973_b();
                itemstack = itemstack3.func_77946_l();
                if (slot2.func_75211_c() != null && slot2.func_75211_c().func_77973_b() == item) {
                    this.func_75133_b(slot, clickedButton, true, player);
                }
            }
        } else {
            if (slot < 0) {
                return null;
            }
            Slot slot2 = (Slot)this.field_75151_b.get(slot);
            if (slot2 != null) {
                ItemStack stackInSlot = slot2.func_75211_c();
                ItemStack stackInPlayer = player.field_71071_by.func_70445_o();
                if (stackInSlot != null) {
                    itemstack = stackInSlot.func_77946_l();
                }
                if (stackInSlot == null) {
                    if (stackInPlayer != null && slot2.func_75214_a(stackInPlayer)) {
                        int l1;
                        int n = l1 = clickedButton == 0 ? stackInPlayer.field_77994_a : 1;
                        if (l1 > slot2.func_75219_a()) {
                            l1 = slot2.func_75219_a();
                        }
                        if (stackInPlayer.field_77994_a >= l1) {
                            slot2.func_75215_d(stackInPlayer.func_77979_a(l1));
                        }
                        if (stackInPlayer.field_77994_a == 0) {
                            player.field_71071_by.func_70437_b(null);
                        }
                    }
                } else if (slot2.func_82869_a(player)) {
                    int l1;
                    if (stackInPlayer == null) {
                        int l12 = clickedButton == 0 ? stackInSlot.field_77994_a : (stackInSlot.field_77994_a + 1) / 2;
                        ItemStack stackPickedUp = slot2.func_75209_a(l12);
                        player.field_71071_by.func_70437_b(stackPickedUp);
                        if (stackInSlot.field_77994_a == 0) {
                            slot2.func_75215_d(null);
                        }
                        slot2.func_82870_a(player, player.field_71071_by.func_70445_o());
                    } else if (slot2.func_75214_a(stackInPlayer)) {
                        if (stackInSlot.func_77973_b() == stackInPlayer.func_77973_b() && stackInSlot.func_77960_j() == stackInPlayer.func_77960_j() && ItemStack.func_77970_a((ItemStack)stackInPlayer, (ItemStack)stackInSlot)) {
                            int l13;
                            int n = l13 = clickedButton == 0 ? stackInPlayer.field_77994_a : 1;
                            if (l13 > slot2.func_75219_a() - stackInSlot.field_77994_a) {
                                l13 = slot2.func_75219_a() - stackInSlot.field_77994_a;
                            }
                            if (l13 > stackInPlayer.func_77976_d() - stackInSlot.field_77994_a) {
                                l13 = stackInPlayer.func_77976_d() - stackInSlot.field_77994_a;
                            }
                            stackInPlayer.func_77979_a(l13);
                            if (stackInPlayer.field_77994_a == 0) {
                                player.field_71071_by.func_70437_b(null);
                            }
                            stackInSlot.field_77994_a += l13;
                        } else if (stackInPlayer.field_77994_a <= slot2.func_75219_a()) {
                            slot2.func_75215_d(stackInPlayer);
                            player.field_71071_by.func_70437_b(stackInSlot);
                        }
                    } else if (stackInSlot.func_77973_b() == stackInPlayer.func_77973_b() && stackInPlayer.func_77976_d() > 1 && (!stackInSlot.func_77981_g() || stackInSlot.func_77960_j() == stackInPlayer.func_77960_j()) && ItemStack.func_77970_a((ItemStack)stackInSlot, (ItemStack)stackInPlayer) && (l1 = stackInSlot.field_77994_a) > 0 && l1 + stackInPlayer.field_77994_a <= stackInPlayer.func_77976_d()) {
                        stackInPlayer.field_77994_a += l1;
                        stackInSlot = slot2.func_75209_a(l1);
                        if (stackInSlot.field_77994_a == 0) {
                            slot2.func_75215_d(null);
                        }
                        slot2.func_82870_a(player, player.field_71071_by.func_70445_o());
                    }
                }
                slot2.func_75218_e();
            }
        }
        return itemstack;
    }
}

