/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.data;

import java.util.ArrayList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.EnumAura;

public class AuraQuantityList
implements Cloneable {
    public static final String NBT_AURA_TYPE = "auraType";
    public static final String NBT_AURA_NUM = "auraNum";
    public ArrayList<AuraQuantity> quantityList;

    public AuraQuantityList(ArrayList<AuraQuantity> quantities) {
        this.quantityList = quantities;
    }

    public AuraQuantityList() {
        this.quantityList = new ArrayList();
        for (EnumAura type : EnumAura.values()) {
            this.quantityList.add(new AuraQuantity(type, 0));
        }
    }

    public int getTotalAura() {
        int sum = 0;
        for (EnumAura aura : EnumAura.values()) {
            sum += this.get(aura);
        }
        return sum;
    }

    public double getComposition(EnumAura aura) {
        if (this.getTotalAura() != 0) {
            return (double)this.get(aura) / (double)this.getTotalAura();
        }
        return 0.0;
    }

    public void subtract(AuraQuantityList other) {
        for (AuraQuantity quantity : this.quantityList) {
            for (AuraQuantity quantityOther : other.quantityList) {
                if (quantity.getType() != quantityOther.getType()) continue;
                quantity.setNum(quantity.getNum() - quantityOther.getNum());
            }
        }
    }

    public void add(AuraQuantityList other) {
        for (AuraQuantity quantity : this.quantityList) {
            for (AuraQuantity quantityOther : other.quantityList) {
                if (quantity.getType() != quantityOther.getType()) continue;
                quantity.setNum(quantity.getNum() + quantityOther.getNum());
            }
        }
    }

    public void add(AuraQuantity other) {
        for (AuraQuantity quantity : this.quantityList) {
            if (quantity.getType() != other.getType()) continue;
            quantity.setNum(quantity.getNum() + other.getNum());
        }
    }

    public int get(EnumAura aura) {
        for (AuraQuantity quantity : this.quantityList) {
            if (quantity.getType() != aura) continue;
            return quantity.getNum();
        }
        return 0;
    }

    public void set(EnumAura type, int num) {
        for (AuraQuantity quantity : this.quantityList) {
            if (quantity.getType() != type) continue;
            quantity.setNum(num);
        }
    }

    public void subtract(EnumAura type, int num) {
        this.set(type, this.get(type) - num);
    }

    public boolean empty() {
        for (AuraQuantity quantity : this.quantityList) {
            if (quantity.getNum() <= 0) continue;
            return false;
        }
        return true;
    }

    public AuraQuantityList percent(float percentage) {
        AuraQuantityList quantityList = new AuraQuantityList();
        for (AuraQuantity quantity : this.quantityList) {
            quantityList.quantityList.add(new AuraQuantity(quantity.getType(), (int)((float)quantity.getNum() * percentage)));
        }
        return quantityList;
    }

    public AuraQuantityList min(AuraQuantityList other) {
        AuraQuantityList result = new AuraQuantityList();
        for (EnumAura aura : EnumAura.values()) {
            result.set(aura, Math.min(this.get(aura), other.get(aura)));
        }
        return result;
    }

    public Object clone() {
        AuraQuantityList result = null;
        try {
            result = (AuraQuantityList)super.clone();
            result.quantityList = (ArrayList)this.quantityList.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void readFromNBT(NBTTagList nbt) {
        this.quantityList = new ArrayList();
        for (int i = 0; i < nbt.func_74745_c(); ++i) {
            NBTTagCompound auraCompound = nbt.func_150305_b(i);
            EnumAura type = EnumAura.values()[auraCompound.func_74771_c(NBT_AURA_TYPE)];
            int num = auraCompound.func_74762_e(NBT_AURA_NUM);
            this.quantityList.add(new AuraQuantity(type, num));
        }
    }

    public void writeToNBT(NBTTagList nbt) {
        for (AuraQuantity quantity : this.quantityList) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a(NBT_AURA_TYPE, (byte)quantity.getType().ordinal());
            compound.func_74768_a(NBT_AURA_NUM, quantity.getNum());
            nbt.func_74742_a((NBTBase)compound);
        }
    }

    public boolean greaterThan(AuraQuantityList list) {
        for (EnumAura aura : EnumAura.values()) {
            if (this.get(aura) >= list.get(aura)) continue;
            return false;
        }
        return true;
    }
}

