/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import pixlepix.auracascade.block.tile.TileBookshelfCoordinator;
import pixlepix.auracascade.data.ItemStackMapEntry;
import pixlepix.auracascade.data.StorageItemStack;
import pixlepix.auracascade.item.ItemStorageBook;
import pixlepix.auracascade.main.AuraUtil;

public class TileStorageBookshelf
extends TileEntity
implements IInventory {
    public ItemStack storedBook;
    public ArrayList<ItemStack> inv = new ArrayList();
    private HashMap<ItemStackMapEntry, Boolean> validCache = new HashMap();

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeCustomNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readCustomNBT(nbt);
    }

    public void readCustomNBT(NBTTagCompound nbt) {
        if (nbt.func_74781_a("book") != null) {
            this.storedBook = ItemStack.func_77949_a((NBTTagCompound)((NBTTagCompound)nbt.func_74781_a("book")));
        }
        if (this.storedBook != null) {
            ItemStorageBook itemStorageBook = (ItemStorageBook)this.storedBook.func_77973_b();
            this.inv = itemStorageBook.getInventory(this.storedBook);
        } else {
            this.inv = new ArrayList();
        }
        this.validCache = new HashMap();
    }

    public void writeCustomNBT(NBTTagCompound nbt) {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.storedBook != null) {
            compound = this.storedBook.func_77955_b(compound);
        }
        nbt.func_74782_a("book", (NBTBase)compound);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeCustomNBT(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    public int func_70302_i_() {
        return this.storedBook != null ? ((ItemStorageBook)this.storedBook.func_77973_b()).getActualCount() : 0;
    }

    public ItemStack func_70301_a(int i) {
        if (this.storedBook == null) {
            return null;
        }
        if (this.inv == null) {
            ItemStorageBook itemStorageBook = (ItemStorageBook)this.storedBook.func_77973_b();
            this.inv = itemStorageBook.getInventory(this.storedBook);
        }
        return this.inv.get(i);
    }

    public ItemStack func_70298_a(int slot, int amt) {
        this.func_70296_d();
        return AuraUtil.decrStackSize(this, slot, amt);
    }

    public ItemStack func_70304_b(int i) {
        return this.func_70301_a(i);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        if (this.storedBook == null) {
            return;
        }
        if (this.inv == null) {
            ItemStorageBook itemStorageBook = (ItemStorageBook)this.storedBook.func_77973_b();
            this.inv = itemStorageBook.getInventory(this.storedBook);
        }
        this.inv.set(slot, stack);
        this.func_70296_d();
    }

    public void onStoredBookChange() {
        if (this.storedBook != null) {
            ItemStorageBook itemStorageBook = (ItemStorageBook)this.storedBook.func_77973_b();
            this.inv = itemStorageBook.getInventory(this.storedBook);
        } else {
            this.inv = new ArrayList();
        }
        this.validCache = new HashMap();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.storedBook != null) {
            ItemStorageBook itemStorageBook = (ItemStorageBook)this.storedBook.func_77973_b();
            ItemStorageBook.setInventory(this.storedBook, this.inv);
            this.inv = itemStorageBook.getInventory(this.storedBook);
        } else {
            this.inv = new ArrayList();
        }
        this.validCache = new HashMap();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public String func_145825_b() {
        return "Storage Bookshelf";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.storedBook != null ? ((ItemStorageBook)this.storedBook.func_77973_b()).getMaxStackSize() : 0;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        if (this.storedBook == null) {
            return false;
        }
        if (this.validCache.containsKey(new ItemStackMapEntry(item))) {
            return this.validCache.get(new ItemStackMapEntry(item));
        }
        ItemStorageBook itemStorageBook = (ItemStorageBook)this.storedBook.func_77973_b();
        if (!((ItemStorageBook)this.storedBook.func_77973_b()).isItemValid(item, this)) {
            return false;
        }
        ArrayList<ItemStack> testInv = itemStorageBook.getInventory(this.storedBook);
        testInv.add(item);
        ArrayList<StorageItemStack> inv = new ArrayList<StorageItemStack>();
        for (ItemStack itemStack : testInv) {
            StorageItemStack remainingStorage;
            if (itemStack == null || (remainingStorage = this.mergeStack(itemStorageBook, inv, itemStack)) == null || remainingStorage.stackSize <= 0) continue;
            this.validCache.put(new ItemStackMapEntry(item), false);
            return false;
        }
        this.validCache.put(new ItemStackMapEntry(item), true);
        return true;
    }

    public boolean isItemValidForSlotSensitive(int slot, ItemStack item) {
        if (this.storedBook == null) {
            return false;
        }
        ItemStorageBook itemStorageBook = (ItemStorageBook)this.storedBook.func_77973_b();
        if (!((ItemStorageBook)this.storedBook.func_77973_b()).isItemValid(item, this)) {
            return false;
        }
        ArrayList<ItemStack> testInv = itemStorageBook.getInventory(this.storedBook);
        testInv.set(slot, item);
        ArrayList<StorageItemStack> inv = new ArrayList<StorageItemStack>();
        for (ItemStack itemStack : testInv) {
            StorageItemStack remainingStorage;
            if (itemStack == null || (remainingStorage = this.mergeStack(itemStorageBook, inv, itemStack)) == null || remainingStorage.stackSize <= 0) continue;
            return false;
        }
        return true;
    }

    public StorageItemStack mergeStack(ItemStorageBook itemStorageBook, ArrayList<StorageItemStack> inv, ItemStack itemStack) {
        StorageItemStack remainingStorage = new StorageItemStack(itemStack);
        for (StorageItemStack storageItemStack : inv) {
            remainingStorage = storageItemStack.merge(remainingStorage, itemStorageBook.getMaxStackSize());
        }
        while (inv.size() < itemStorageBook.getHeldStacks() && remainingStorage != null && remainingStorage.stackSize > 0) {
            StorageItemStack storageItemStack;
            int delta = Math.min(itemStorageBook.getMaxStackSize(), remainingStorage.stackSize);
            storageItemStack = new StorageItemStack(remainingStorage.item, delta, remainingStorage.damage, remainingStorage.compound);
            inv.add(storageItemStack);
            remainingStorage.stackSize -= delta;
        }
        return remainingStorage;
    }

    public ArrayList<StorageItemStack> getAbstractInventory() {
        ArrayList<ItemStack> startInv = this.inv;
        return TileBookshelfCoordinator.getAbstractInventoryFromInv(startInv);
    }
}

