/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import net.minecraft.block.BlockBookshelf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.tile.AuraTile;
import pixlepix.auracascade.block.tile.TileStorageBookshelf;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.data.StorageItemStack;
import pixlepix.auracascade.main.AuraUtil;
import pixlepix.auracascade.network.PacketBurst;

public class TileBookshelfCoordinator
extends TileEntity
implements IInventory {
    public ArrayList<TileStorageBookshelf> bookshelfLocations = new ArrayList();
    public boolean hasCheckedShelves;
    public int neededPower = 0;
    public int lastPower = 0;

    public static ArrayList<StorageItemStack> getAbstractInventoryFromInv(ArrayList<ItemStack> startInv) {
        ArrayList<StorageItemStack> inv = new ArrayList<StorageItemStack>();
        for (ItemStack itemStack : startInv) {
            if (itemStack == null) continue;
            StorageItemStack remainingStorage = new StorageItemStack(itemStack);
            for (StorageItemStack storageItemStack : inv) {
                remainingStorage = storageItemStack.merge(remainingStorage, Integer.MAX_VALUE);
            }
            while (remainingStorage != null && remainingStorage.stackSize > 0) {
                StorageItemStack storageItemStack;
                int delta = remainingStorage.stackSize;
                storageItemStack = new StorageItemStack(remainingStorage.item, delta, remainingStorage.damage, remainingStorage.compound);
                inv.add(storageItemStack);
                remainingStorage.stackSize -= delta;
            }
        }
        return inv;
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.writeCustomNBT(nbt);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.readCustomNBT(nbt);
    }

    public void readCustomNBT(NBTTagCompound nbt) {
        this.lastPower = nbt.func_74762_e("lastPower");
        this.neededPower = nbt.func_74762_e("neededPower");
    }

    public void writeCustomNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("lastPower", this.lastPower);
        nbt.func_74768_a("neededPower", this.neededPower);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeCustomNBT(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, -999, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.readCustomNBT(pkt.func_148857_g());
    }

    public boolean hasClearLineOfSight(CoordTuple tuple) {
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        Vec3 originalVector = Vec3.func_72443_a((double)(tuple.getX() - x), (double)(tuple.getY() - y), (double)(tuple.getZ() - z));
        Vec3 vec3 = originalVector.func_72432_b();
        double f = 0.0;
        while (true) {
            if (new CoordTuple(x = (int)((double)this.field_145851_c + (f += 0.1) * vec3.field_72450_a), y = (int)((double)this.field_145848_d + f * vec3.field_72448_b), z = (int)((double)this.field_145849_e + f * vec3.field_72449_c)).equals(tuple)) {
                return true;
            }
            if (new CoordTuple(x, y, z).equals(new CoordTuple(this.field_145851_c, this.field_145848_d, this.field_145849_e))) continue;
            if (!this.field_145850_b.func_147437_c(x, y, z)) {
                CoordTuple coordTuple = new CoordTuple(x, y, z);
                if (coordTuple.dist(this) >= 1.5) {
                    CoordTuple coordTuple2 = new CoordTuple(x, y, z);
                    if (coordTuple2.dist(tuple) >= 1.5) {
                        return false;
                    }
                }
            }
            if (f > originalVector.func_72433_c()) break;
        }
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 200L == 5L) {
            int numShelves = this.getBookshelves().size();
            AuraCascade.analytics.eventDesign("booshelfUsage", AuraUtil.formatLocation(this), numShelves);
            this.neededPower = (int)((double)(5 * numShelves) * Math.pow(1.05, numShelves));
            this.lastPower = 0;
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                if (!(tileEntity instanceof AuraTile)) continue;
                AuraTile auraTile = (AuraTile)tileEntity;
                if (auraTile.energy <= 0) continue;
                auraTile.burst(new CoordTuple(this), "magicCrit", EnumAura.WHITE_AURA, 1.0);
                this.lastPower += auraTile.energy;
                auraTile.energy = 0;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.field_145850_b.func_82737_E() % 200L == 0L || !this.hasCheckedShelves) {
            this.bookshelfLocations = new ArrayList();
            ArrayList<CoordTuple> checkedLocations = new ArrayList<CoordTuple>();
            ArrayList<CoordTuple> toSearch = new ArrayList<CoordTuple>();
            toSearch.add(new CoordTuple(this));
            while (toSearch.size() > 0) {
                CoordTuple nextTuple = (CoordTuple)toSearch.remove(0);
                for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                    CoordTuple newTuple = nextTuple.add(direction);
                    TileEntity storageBookshelf = newTuple.getTile(this.field_145850_b);
                    if (storageBookshelf instanceof TileStorageBookshelf && !checkedLocations.contains(newTuple)) {
                        toSearch.add(newTuple);
                        if (this.hasClearLineOfSight(newTuple)) {
                            this.bookshelfLocations.add((TileStorageBookshelf)newTuple.getTile(this.field_145850_b));
                            if (!this.field_145850_b.field_72995_K) {
                                this.burst(newTuple, "enchantmenttable", EnumAura.WHITE_AURA, 1.0);
                            }
                        }
                        checkedLocations.add(newTuple);
                    }
                    if (!(newTuple.getBlock(this.field_145850_b) instanceof BlockBookshelf) && (newTuple.getBlock(this.field_145850_b) == null || newTuple.getBlock(this.field_145850_b) != AuraCascade.proxy.chiselBookshelf) || checkedLocations.contains(newTuple)) continue;
                    toSearch.add(newTuple);
                    checkedLocations.add(newTuple);
                }
            }
            this.hasCheckedShelves = true;
        }
    }

    public ArrayList<TileStorageBookshelf> getBookshelves() {
        return this.bookshelfLocations;
    }

    public int func_70302_i_() {
        if (this.lastPower < this.neededPower) {
            return 0;
        }
        int result = 0;
        for (TileStorageBookshelf bookshelf : this.getBookshelves()) {
            result += bookshelf.func_70302_i_();
        }
        return result;
    }

    public ArrayList<ItemStack> getInv() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(this.func_70302_i_() + 2);
        for (TileStorageBookshelf bookshelf : this.getBookshelves()) {
            result.addAll(bookshelf.inv);
        }
        return result;
    }

    public ItemStack func_70301_a(int i) {
        return this.getInv().get(i);
    }

    public TileStorageBookshelf getBookshelfAtIndex(int i) {
        for (TileStorageBookshelf bookshelf : this.getBookshelves()) {
            if ((i -= bookshelf.func_70302_i_()) >= 0) continue;
            return bookshelf;
        }
        return null;
    }

    public int getIndexWithinBookshelf(int i) {
        for (TileStorageBookshelf bookshelf : this.getBookshelves()) {
            if ((i -= bookshelf.func_70302_i_()) >= 0) continue;
            return i + bookshelf.func_70302_i_();
        }
        return 0;
    }

    public ItemStack func_70298_a(int slot, int amt) {
        return AuraUtil.decrStackSize(this, slot, amt);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return null;
    }

    public void func_70299_a(int i, ItemStack stack) {
        TileStorageBookshelf bookshelf = this.getBookshelfAtIndex(i);
        bookshelf.func_70299_a(this.getIndexWithinBookshelf(i), stack);
        bookshelf.func_70296_d();
    }

    public void func_70296_d() {
        for (TileStorageBookshelf bookshelf : this.getBookshelves()) {
            bookshelf.func_70296_d();
        }
    }

    public String func_145825_b() {
        return "Bookshelf Coordinator";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ArrayList<StorageItemStack> getAbstractInventory() {
        ArrayList<ItemStack> startInv = this.getInv();
        return TileBookshelfCoordinator.getAbstractInventoryFromInv(startInv);
    }

    public void burst(CoordTuple target, String particle, EnumAura aura, double composition) {
        AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(new CoordTuple(this), target, particle, aura.r, aura.g, aura.b, composition), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0));
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (this.lastPower < this.neededPower) {
            return false;
        }
        TileStorageBookshelf bookshelf = this.getBookshelfAtIndex(i);
        return bookshelf.func_94041_b(this.getIndexWithinBookshelf(i), stack);
    }

    public boolean isItemValidForSlotSensitive(int i, ItemStack stack) {
        TileStorageBookshelf bookshelf = this.getBookshelfAtIndex(i);
        return bookshelf != null && bookshelf.isItemValidForSlotSensitive(this.getIndexWithinBookshelf(i), stack);
    }
}

