/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.tile.ConsumerTile;
import pixlepix.auracascade.main.AuraUtil;
import pixlepix.auracascade.network.PacketBurst;

public class PotionTile
extends ConsumerTile {
    public static int MAX_PROGRESS = 25;
    public static int POWER_PER_PROGRESS = 500;

    @Override
    public int getMaxProgress() {
        return MAX_PROGRESS;
    }

    @Override
    public int getPowerPerProgress() {
        return POWER_PER_PROGRESS;
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public boolean validItemsNearby() {
        int range = 3;
        List nearbyItems = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range), (double)(this.field_145848_d + range), (double)(this.field_145849_e + range)));
        for (EntityItem entityItem : nearbyItems) {
            ItemStack stack = entityItem.func_92059_d();
            ItemStack smeltingResult = this.getBrewResult(stack);
            if (smeltingResult == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void onUsePower() {
        AuraCascade.analytics.eventDesign("consumerBrew", AuraUtil.formatLocation(this));
        int range = 3;
        List nearbyItems = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - range), (double)(this.field_145848_d - range), (double)(this.field_145849_e - range), (double)(this.field_145851_c + range), (double)(this.field_145848_d + range), (double)(this.field_145849_e + range)));
        for (EntityItem entityItem : nearbyItems) {
            ItemStack stack = entityItem.func_92059_d();
            ItemStack smeltingResult = this.getBrewResult(stack);
            if (smeltingResult == null) continue;
            if (stack.field_77994_a == 0) {
                entityItem.func_70106_y();
            } else {
                --stack.field_77994_a;
            }
            EntityItem newEntity = new EntityItem(this.field_145850_b, entityItem.field_70165_t, entityItem.field_70163_u, entityItem.field_70161_v, smeltingResult.func_77946_l());
            newEntity.field_145804_b = entityItem.field_145804_b;
            newEntity.field_70159_w = entityItem.field_70159_w;
            newEntity.field_70181_x = entityItem.field_70181_x;
            newEntity.field_70179_y = entityItem.field_70179_y;
            this.field_145850_b.func_72838_d((Entity)newEntity);
            AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(6, newEntity.field_70165_t, newEntity.field_70163_u, newEntity.field_70161_v), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0));
            break;
        }
    }

    public ItemStack getBrewResult(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151068_bn) {
            int meta = stack.func_77960_j();
            Integer[] basePotions = new Integer[]{8193, 8194, 8195, 8196, 8197, 8198, 8200, 8201, 8202, 8204, 8205, 8206};
            int newMeta = -1;
            if (meta == 0) {
                newMeta = 16;
            } else if (meta == 16) {
                newMeta = basePotions[new Random().nextInt(basePotions.length)];
            } else if (Arrays.asList(basePotions).contains(meta)) {
                newMeta = meta ^ 1 << (new Random().nextBoolean() ? 5 : 6);
            }
            if (newMeta != -1) {
                return new ItemStack((Item)Items.field_151068_bn, 1, newMeta);
            }
        }
        return null;
    }
}

