/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.AuraCascade;
import pixlepix.auracascade.block.tile.AuraTilePedestal;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.data.recipe.PylonRecipe;
import pixlepix.auracascade.data.recipe.PylonRecipeRegistry;
import pixlepix.auracascade.network.PacketBurst;

public class CraftingCenterTile
extends TileEntity {
    public static List<ForgeDirection> pedestalRelativeLocations = Arrays.asList(ForgeDirection.EAST, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.WEST);

    public boolean pedestalsConnected() {
        for (ForgeDirection direction : pedestalRelativeLocations) {
            if (new CoordTuple(this).add(direction).getTile(this.field_145850_b) instanceof AuraTilePedestal) continue;
            return false;
        }
        return true;
    }

    public PylonRecipe getRecipe() {
        if (!this.pedestalsConnected()) {
            return null;
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ForgeDirection direction : pedestalRelativeLocations) {
            AuraTilePedestal pedestal = (AuraTilePedestal)new CoordTuple(this).add(direction).getTile(this.field_145850_b);
            stacks.add(pedestal.itemStack);
        }
        for (PylonRecipe recipe : PylonRecipeRegistry.recipes) {
            if (!recipe.matches(stacks)) continue;
            return recipe;
        }
        return null;
    }

    public void checkRecipeComplete() {
        AuraTilePedestal pedestal;
        PylonRecipe recipe = this.getRecipe();
        if (recipe == null) {
            return;
        }
        boolean valid = true;
        for (ForgeDirection direction : pedestalRelativeLocations) {
            pedestal = (AuraTilePedestal)new CoordTuple(this).add(direction).getTile(this.field_145850_b);
            AuraQuantity targetAura = recipe.getAuraFromItem(pedestal.itemStack);
            if (targetAura.getNum() <= pedestal.powerReceived) continue;
            valid = false;
        }
        if (valid) {
            for (ForgeDirection direction : pedestalRelativeLocations) {
                pedestal = (AuraTilePedestal)new CoordTuple(this).add(direction).getTile(this.field_145850_b);
                for (ForgeDirection beamDir : ForgeDirection.VALID_DIRECTIONS) {
                    if (beamDir == direction || beamDir == direction.getOpposite()) continue;
                    CoordTuple mid = new CoordTuple(pedestal).add(beamDir).add(direction);
                    EnumAura aura = recipe.getAuraFromItem(pedestal.itemStack).getType();
                    this.burst(mid, new CoordTuple(pedestal), "happyVillager", aura, 1.0);
                    this.burst(mid, new CoordTuple(this), "happyVillager", aura, 1.0);
                }
                pedestal.itemStack = null;
                pedestal.powerReceived = 0;
            }
            ItemStack loot = recipe.result.func_77946_l();
            AuraCascade.analytics.eventDesign("vortexCraft", loot.func_77977_a());
            EntityItem entityDrop = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 2), (double)this.field_145849_e + 0.5, loot);
            this.field_145850_b.func_72838_d((Entity)entityDrop);
            AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(3, (double)this.field_145851_c + 0.5, this.field_145848_d + 2, (double)this.field_145849_e + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0));
        }
    }

    public void burst(CoordTuple origin, CoordTuple target, String particle, EnumAura aura, double composition) {
        AuraCascade.proxy.networkWrapper.sendToAllAround((IMessage)new PacketBurst(origin, target, particle, aura.r, aura.g, aura.b, composition), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 32.0));
    }
}

