/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block.tile;

import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.block.tile.AuraTile;
import pixlepix.auracascade.block.tile.CraftingCenterTile;
import pixlepix.auracascade.data.AuraQuantity;
import pixlepix.auracascade.data.CoordTuple;
import pixlepix.auracascade.data.EnumAura;
import pixlepix.auracascade.data.recipe.PylonRecipe;

public class AuraTilePedestal
extends AuraTile
implements IInventory {
    public ItemStack itemStack;
    public ForgeDirection direction = ForgeDirection.UNKNOWN;
    public int powerReceived = 0;
    public EnumAura typeReceiving;
    public EntityItem entityItem;
    public long frames;

    @Override
    public void verifyConnections() {
        TileEntity tileEntity;
        super.verifyConnections();
        if (this.direction != ForgeDirection.UNKNOWN && !((tileEntity = this.field_145850_b.func_147438_o(this.field_145851_c + this.direction.offsetX, this.field_145848_d + this.direction.offsetY, this.field_145849_e + this.direction.offsetZ)) instanceof CraftingCenterTile)) {
            this.direction = ForgeDirection.UNKNOWN;
        }
        if (this.direction == ForgeDirection.UNKNOWN) {
            for (ForgeDirection searchDir : CraftingCenterTile.pedestalRelativeLocations) {
                TileEntity tileEntity2 = this.field_145850_b.func_147438_o(this.field_145851_c + searchDir.offsetX, this.field_145848_d + searchDir.offsetY, this.field_145849_e + searchDir.offsetZ);
                if (!(tileEntity2 instanceof CraftingCenterTile)) continue;
                this.direction = searchDir;
                break;
            }
        }
    }

    public CraftingCenterTile getCenter() {
        if (this.direction == ForgeDirection.UNKNOWN) {
            return null;
        }
        TileEntity te = new CoordTuple(this).add(this.direction).getTile(this.field_145850_b);
        return te instanceof CraftingCenterTile ? (CraftingCenterTile)te : null;
    }

    @Override
    public void receivePower(int power, EnumAura type) {
        PylonRecipe recipe;
        this.verifyConnections();
        CraftingCenterTile center = this.getCenter();
        if (center != null && (recipe = center.getRecipe()) != null) {
            AuraQuantity quantity = recipe.getAuraFromItem(this.itemStack);
            if (quantity != null && quantity.getType() != this.typeReceiving) {
                this.typeReceiving = quantity.getType();
                this.powerReceived = 0;
            }
            if (quantity != null && (quantity.getType() == EnumAura.WHITE_AURA || quantity.getType() == type)) {
                this.powerReceived += power;
                this.powerReceived = Math.min(this.powerReceived, quantity.getNum());
                if (this.powerReceived >= quantity.getNum()) {
                    center.checkRecipeComplete();
                }
            }
        }
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        super.readCustomNBT(nbt);
        this.itemStack = ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("itemStack"));
        this.direction = ForgeDirection.getOrientation((int)nbt.func_74762_e("direction"));
        this.powerReceived = nbt.func_74762_e("powerReceived");
        this.typeReceiving = nbt.func_74762_e("typeReceiving") == -1 ? null : EnumAura.values()[nbt.func_74762_e("typeReceiving")];
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt) {
        super.writeCustomNBT(nbt);
        if (this.itemStack != null) {
            NBTTagCompound compound = new NBTTagCompound();
            this.itemStack.func_77955_b(compound);
            nbt.func_74782_a("itemStack", (NBTBase)compound);
        }
        nbt.func_74768_a("direction", this.direction.ordinal());
        nbt.func_74768_a("powerReceived", this.powerReceived);
        nbt.func_74768_a("typeReceiving", this.typeReceiving == null ? -1 : this.typeReceiving.ordinal());
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        return this.itemStack;
    }

    public ItemStack func_70298_a(int slot, int amt) {
        if (this.itemStack != null) {
            if (this.itemStack.field_77994_a <= amt) {
                this.func_70299_a(slot, null);
            } else {
                this.itemStack = this.itemStack.func_77979_a(amt);
                if (this.itemStack.field_77994_a == 0) {
                    this.itemStack = null;
                }
            }
        }
        return this.itemStack;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        ItemStack stack = this.itemStack;
        this.itemStack = null;
        return stack;
    }

    public void func_70299_a(int p_70299_1_, ItemStack stack) {
        this.itemStack = stack;
    }

    public String func_145825_b() {
        return "craftingPedestal";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }
}

