/*
 * Decompiled with CFR 0.152.
 */
package pixlepix.auracascade.block;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import pixlepix.auracascade.block.AuraBlock;
import pixlepix.auracascade.block.tile.AuraTilePumpBase;
import pixlepix.auracascade.block.tile.ConsumerTile;
import pixlepix.auracascade.registry.CraftingBenchRecipe;
import pixlepix.auracascade.registry.ITTinkererBlock;
import pixlepix.auracascade.registry.ThaumicTinkererRecipe;

public class BlockMonitor
extends Block
implements ITTinkererBlock {
    public BlockMonitor() {
        super(Material.field_151591_t);
        this.func_149711_c(3.0f);
        this.setHarvestLevel("pickaxe", 2);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        ForgeDirection powerDirection = ForgeDirection.getOrientation((int)side).getOpposite();
        Block b = world.func_147439_a(x + powerDirection.offsetX, y + powerDirection.offsetY, z + powerDirection.offsetZ);
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (direction == powerDirection) continue;
            TileEntity auraTile = world.func_147438_o(x + direction.offsetX, y + direction.offsetY, z + direction.offsetZ);
            if (auraTile instanceof AuraTilePumpBase) {
                return ((AuraTilePumpBase)auraTile).pumpPower > 0 ? 0 : 15;
            }
            if (!(auraTile instanceof ConsumerTile)) continue;
            return ((ConsumerTile)auraTile).validItemsNearby() ? 0 : 15;
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    @Override
    public ArrayList<Object> getSpecialParameters() {
        return null;
    }

    @Override
    public String getBlockName() {
        return "monitor";
    }

    @Override
    public boolean shouldRegister() {
        return true;
    }

    @Override
    public boolean shouldDisplayInTab() {
        return true;
    }

    @Override
    public Class<? extends ItemBlock> getItemBlock() {
        return null;
    }

    @Override
    public Class<? extends TileEntity> getTileEntity() {
        return null;
    }

    @Override
    public ThaumicTinkererRecipe getRecipeItem() {
        return new CraftingBenchRecipe(new ItemStack((Block)this), "RRR", "RAR", "RRR", Character.valueOf('R'), new ItemStack(Items.field_151137_ax), Character.valueOf('A'), AuraBlock.getAuraNodeItemstack());
    }

    public void func_149651_a(IIconRegister icon) {
        this.field_149761_L = icon.func_94245_a("aura:monitor");
    }

    @Override
    public int getCreativeTabPriority() {
        return 3;
    }
}

