/*
 * Decompiled with CFR 0.152.
 */
package com.gekox.gekosLasers.items;

import com.gekox.gekosLasers.entity.projectile.laser.ProjectileLaser;
import com.gekox.gekosLasers.items.ItemLaserThing;
import com.gekox.gekosLasers.reference.Reference;
import com.gekox.gekosLasers.utility.Color;
import com.gekox.gekosLasers.utility.ColorUtils;
import com.gekox.gekosLasers.utility.LaserUtils;
import com.gekox.gekosLasers.utility.LogHelper;
import com.gekox.gekosLasers.utility.NBTHelper;
import com.gekox.gekosLasers.utility.StringUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemLaserGun
extends ItemLaserThing {
    private int laserDamage = 0;
    private int laserStrength = -1;
    private int laserBlockBreakRadius = 1;
    private float laserExplosionSize = 0.0f;
    private boolean laserDoExplosionDamage = false;
    private boolean laserDoFireDamage = false;
    private boolean laserDoTeleport = false;
    private int laserBurnTime = 0;
    private ProjectileLaser laser;
    private int numOfThingsBroken;
    private int currentBlockBreakRadius = 1;
    private int currentNumOfThingsBroken = 0;
    private String DEPTH_TAG = "CurrentDepth";
    private String RADIUS_TAG = "CurrentRadius";

    public ItemLaserGun() {
    }

    public ItemLaserGun(ProjectileLaser laser) {
        this.laser = laser;
    }

    public ItemLaserGun setLaser(ProjectileLaser laser) {
        this.laser = laser;
        return this;
    }

    public ProjectileLaser getLaser(ItemStack stack) {
        ItemLaserGun laserThing = (ItemLaserGun)this.getLaserThing(stack);
        return laserThing == null ? null : laserThing.laser;
    }

    public int getLaserDamage() {
        return this.laserDamage;
    }

    public void setLaserDamage(int laserDamage) {
        this.laserDamage = laserDamage;
    }

    public int getLaserStrength() {
        return this.laserStrength;
    }

    public void setLaserStrength(int laserStrength) {
        this.laserStrength = laserStrength;
    }

    public int getLaserBlockBreakRadius() {
        return this.laserBlockBreakRadius;
    }

    public void setLaserBlockBreakRadius(int laserBlockBreakRadius) {
        this.laserBlockBreakRadius = laserBlockBreakRadius;
        this.currentBlockBreakRadius = laserBlockBreakRadius;
    }

    public int getNumOfThingsBroken() {
        return this.numOfThingsBroken;
    }

    public void setNumOfThingsBroken(int numOfThingsBroken) {
        this.numOfThingsBroken = numOfThingsBroken;
        this.currentNumOfThingsBroken = numOfThingsBroken;
    }

    public int getCurrentNumOfThingsBroken() {
        return this.currentNumOfThingsBroken;
    }

    public int getCurrentBlockBreakRadius() {
        return this.currentBlockBreakRadius;
    }

    public boolean isLaserDoExplosionDamage() {
        return this.laserDoExplosionDamage;
    }

    public void setLaserDoExplosionDamage(boolean laserDoExplosionDamage) {
        this.laserDoExplosionDamage = laserDoExplosionDamage;
    }

    public float getLaserExplosionSize() {
        return this.laserExplosionSize;
    }

    public void setLaserExplosionSize(float laserExplosionSize) {
        this.laserExplosionSize = laserExplosionSize;
    }

    public boolean isLaserDoFireDamage() {
        return this.laserDoFireDamage;
    }

    public void setLaserDoFireDamage(boolean laserDoFireDamage) {
        this.laserDoFireDamage = laserDoFireDamage;
    }

    public int getLaserBurnTime() {
        return this.laserBurnTime;
    }

    public void setLaserBurnTime(int laserBurnTime) {
        this.laserBurnTime = laserBurnTime;
    }

    public boolean isLaserDoTeleport() {
        return this.laserDoTeleport;
    }

    public void setLaserDoTeleport(boolean laserDoTeleport) {
        this.laserDoTeleport = laserDoTeleport;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        Color color = Color.color[NBTHelper.getInt(stack, "LaserColor")];
        this.setLaser(LaserUtils.determineLaser(world, player, color).setupLaser(this.getLaserDamage(), this.getLaserStrength(), NBTHelper.getInt(stack, this.RADIUS_TAG), this.isLaserDoExplosionDamage(), this.getLaserExplosionSize(), this.isLaserDoFireDamage(), this.getLaserBurnTime(), this.isLaserDoTeleport()));
        this.laser.setColor(color);
        if (!world.field_72995_K && this.canFire(stack, world)) {
            this.shoot(stack, player, this.laser);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack p_77648_1_, EntityPlayer p_77648_2_, World p_77648_3_, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        return false;
    }

    public void shoot(ItemStack stack, EntityPlayer player, ProjectileLaser laser) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.useEnergy(stack, false);
        }
        laser.numOfThingsBroken = NBTHelper.getInt(stack, this.DEPTH_TAG);
        this.setNextShot(stack, player.field_70170_p);
        World world = player.field_70170_p;
        world.func_72838_d((Entity)laser);
        world.func_72956_a((Entity)player, Reference.RESOURCE_PREFIX + "laser.pew", 0.5f, 1.0f);
    }

    public void shoot(ItemStack stack, ProjectileLaser laser, World world, int x, int y, int z) {
        LogHelper.debug("Shooting: " + stack.toString());
        this.useEnergy(stack, false);
        laser.numOfThingsBroken = NBTHelper.getInt(stack, this.DEPTH_TAG);
        world.func_72838_d((Entity)laser);
        world.func_72908_a((double)x, (double)y, (double)z, Reference.RESOURCE_PREFIX + "laser.pew", 0.5f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77629_n_() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean b0) {
        String color = StringUtils.toTitleCase(ColorUtils.names[NBTHelper.getInt(stack, "LaserColor")]);
        String code = ColorUtils.codes[NBTHelper.getInt(stack, "LaserColor")];
        list.add(String.format("%s%s %slaser", code, color, "\u00a77"));
        int rad = (this.laserBlockBreakRadius - 1) * 2 + 1;
        int currentRad = (NBTHelper.getInt(stack, this.RADIUS_TAG) - 1) * 2 + 1;
        if (GuiScreen.func_146272_n()) {
            list.add(String.format("Energy: %d/%dRF", this.getEnergyStored(stack), this.getMaxEnergyStored(stack)));
            list.add(String.format("Uses left: %d", this.getEnergyStored(stack) / this.energyPerUse));
            list.add(String.format("Maximum area of effect: %dx%dx%d", rad, rad, this.numOfThingsBroken));
            list.add(String.format("Current area of effect: %dx%dx%d", currentRad, currentRad, NBTHelper.getInt(stack, this.DEPTH_TAG)));
        } else {
            list.add(String.format("%sPress %sSHIFT%s for details", "\u00a77", "\u00a7e", "\u00a77"));
        }
    }

    public void changeNumOfThingsBroken(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemLaserGun)) {
            return;
        }
        ItemLaserGun gun = (ItemLaserGun)stack.func_77973_b();
        NBTHelper.setInteger(stack, this.DEPTH_TAG, NBTHelper.getInt(stack, this.DEPTH_TAG) + 1);
        if (NBTHelper.getInt(stack, this.DEPTH_TAG) > gun.numOfThingsBroken) {
            NBTHelper.setInteger(stack, this.DEPTH_TAG, 0);
        }
    }

    public void changeBlockBreakRadius(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ItemLaserGun)) {
            return;
        }
        ItemLaserGun gun = (ItemLaserGun)stack.func_77973_b();
        NBTHelper.setInteger(stack, this.RADIUS_TAG, NBTHelper.getInt(stack, this.RADIUS_TAG) + 1);
        if (NBTHelper.getInt(stack, this.RADIUS_TAG) > gun.laserBlockBreakRadius) {
            NBTHelper.setInteger(stack, this.RADIUS_TAG, 0);
        }
    }
}

