/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardentrees.block;

import com.jaquadro.minecraft.gardenapi.api.connect.IChainSingleAttachable;
import com.jaquadro.minecraft.gardencore.api.WoodRegistry;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardentrees.block.tile.TileEntityWoodProxy;
import com.jaquadro.minecraft.gardentrees.core.ClientProxy;
import com.jaquadro.minecraft.gardentrees.core.ModBlocks;
import com.jaquadro.minecraft.gardentrees.core.ModCreativeTabs;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockLeavesBase;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockThinLog
extends BlockContainer
implements IChainSingleAttachable {
    public static final String[] subNames = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak"};
    private int orientation;
    private final Vec3[] attachPoints = new Vec3[]{Vec3.func_72443_a((double)0.5, (double)this.getMargin(), (double)0.5), Vec3.func_72443_a((double)0.5, (double)(1.0f - this.getMargin()), (double)0.5), Vec3.func_72443_a((double)0.5, (double)0.5, (double)this.getMargin()), Vec3.func_72443_a((double)0.5, (double)0.5, (double)(1.0f - this.getMargin())), Vec3.func_72443_a((double)this.getMargin(), (double)0.5, (double)0.5), Vec3.func_72443_a((double)(1.0f - this.getMargin()), (double)0.5, (double)0.5)};

    public BlockThinLog(String blockName) {
        super(Material.field_151575_d);
        this.func_149647_a(ModCreativeTabs.tabGardenTrees);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
        this.func_149713_g(0);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c(blockName);
        this.func_149683_g();
    }

    public float getMargin() {
        return 0.25f;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public void func_149683_g() {
        float margin = this.getMargin();
        this.func_149676_a(margin, 0.0f, margin, 1.0f - margin, 1.0f, 1.0f - margin);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        int connectFlags = this.calcConnectionFlags((IBlockAccess)world, x, y, z);
        float margin = this.getMargin();
        float ys = (connectFlags & 1) != 0 ? 0.0f : margin;
        float ye = (connectFlags & 2) != 0 ? 1.0f : 1.0f - margin;
        float zs = (connectFlags & 4) != 0 ? 0.0f : margin;
        float ze = (connectFlags & 8) != 0 ? 1.0f : 1.0f - margin;
        float xs = (connectFlags & 0x10) != 0 ? 0.0f : margin;
        float xe = (connectFlags & 0x20) != 0 ? 1.0f : 1.0f - margin;
        this.func_149676_a(xs, ys, zs, xe, ye, ze);
        super.func_149743_a(world, x, y, z, mask, list, colliding);
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int connectFlags = this.calcConnectionFlags(world, x, y, z);
        float margin = this.getMargin();
        float ys = (connectFlags & 1) != 0 ? 0.0f : margin;
        float ye = (connectFlags & 2) != 0 ? 1.0f : 1.0f - margin;
        float zs = (connectFlags & 4) != 0 ? 0.0f : margin;
        float ze = (connectFlags & 8) != 0 ? 1.0f : 1.0f - margin;
        float xs = (connectFlags & 0x10) != 0 ? 0.0f : margin;
        float xe = (connectFlags & 0x20) != 0 ? 1.0f : 1.0f - margin;
        this.func_149676_a(xs, ys, zs, xe, ye, ze);
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean canPlaceTorchOnTop(World world, int x, int y, int z) {
        return true;
    }

    public int func_149645_b() {
        return ClientProxy.thinLogRenderID;
    }

    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        int range = 4;
        int height = range + 1;
        if (world.func_72904_c(x - height, y - height, z - height, x + height, y + height, z + height)) {
            for (int dx = -range; dx <= range; ++dx) {
                for (int dy = -range; dy <= range; ++dy) {
                    for (int dz = -range; dz <= range; ++dz) {
                        Block leaf = world.func_147439_a(x + dx, y + dy, z + dz);
                        if (!leaf.isLeaves((IBlockAccess)world, x + dx, y + dy, z + dz)) continue;
                        leaf.beginLeavesDecay(world, x + dx, y + dy, z + dz);
                    }
                }
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        TileEntityWoodProxy tile = this.getTileEntity((IBlockAccess)world, x, y, z);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            int damage = this.func_149692_a(metadata);
            if (tile != null && tile.getProtoBlock() != null) {
                damage = TileEntityWoodProxy.composeMetadata(tile.getProtoBlock(), tile.getProtoMeta());
            }
            ItemStack stack = new ItemStack(item, 1, damage);
            ret.add(stack);
        }
        return ret;
    }

    public int calcConnectionFlags(IBlockAccess world, int x, int y, int z) {
        boolean connectXPos;
        boolean connectXNeg;
        boolean connectZPos;
        int flagsY = this.calcConnectYFlags(world, x, y, z);
        int flagsZNeg = this.calcConnectYFlags(world, x, y, z - 1);
        int flagsZPos = this.calcConnectYFlags(world, x, y, z + 1);
        int flagsXNeg = this.calcConnectYFlags(world, x - 1, y, z);
        int flagsXPos = this.calcConnectYFlags(world, x + 1, y, z);
        int connectFlagsY = flagsY & 3;
        int connectFlagsZNeg = flagsZNeg & 3;
        int connectFlagsZPos = flagsZPos & 3;
        int connectFlagsXNeg = flagsXNeg & 3;
        int connectFlagsXPos = flagsXPos & 3;
        Block blockZNeg = world.func_147439_a(x, y, z - 1);
        Block blockZPos = world.func_147439_a(x, y, z + 1);
        Block blockXNeg = world.func_147439_a(x - 1, y, z);
        Block blockXPos = world.func_147439_a(x + 1, y, z);
        boolean hardZNeg = this.isNeighborHardConnection(world, x, y, z - 1, blockZNeg, ForgeDirection.NORTH) || blockZNeg instanceof BlockTorch;
        boolean hardZPos = this.isNeighborHardConnection(world, x, y, z + 1, blockZPos, ForgeDirection.SOUTH) || blockZPos instanceof BlockTorch;
        boolean hardXNeg = this.isNeighborHardConnection(world, x - 1, y, z, blockXNeg, ForgeDirection.WEST) || blockXNeg instanceof BlockTorch;
        boolean hardXPos = this.isNeighborHardConnection(world, x + 1, y, z, blockXPos, ForgeDirection.EAST) || blockXPos instanceof BlockTorch;
        boolean hardConnection = (flagsY & 4) != 0;
        boolean hardConnectionZNeg = hardConnection && (flagsZNeg & 4) != 0;
        boolean hardConnectionZPos = hardConnection && (flagsZPos & 4) != 0;
        boolean hardConnectionXNeg = hardConnection && (flagsXNeg & 4) != 0;
        boolean hardConnectionXPos = hardConnection && (flagsXPos & 4) != 0;
        boolean connectZNeg = connectFlagsY == 0 && hardZNeg || blockZNeg == this && !hardConnectionZNeg && (connectFlagsY != 3 || connectFlagsZNeg != 3);
        boolean connectSide = connectZNeg | (connectZPos = connectFlagsY == 0 && hardZPos || blockZPos == this && !hardConnectionZPos && (connectFlagsY != 3 || connectFlagsZPos != 3)) | (connectXNeg = connectFlagsY == 0 && hardXNeg || blockXNeg == this && !hardConnectionXNeg && (connectFlagsY != 3 || connectFlagsXNeg != 3)) | (connectXPos = connectFlagsY == 0 && hardXPos || blockXPos == this && !hardConnectionXPos && (connectFlagsY != 3 || connectFlagsXPos != 3));
        if (!connectSide && (connectFlagsY & 1) == 0) {
            if (hardZNeg) {
                connectZNeg = true;
            }
            if (hardZPos) {
                connectZPos = true;
            }
            if (hardXNeg) {
                connectXNeg = true;
            }
            if (hardXPos) {
                connectXPos = true;
            }
        }
        if (!(connectZNeg | connectZPos | connectXNeg | connectXPos)) {
            connectFlagsY = 3;
        }
        if (connectFlagsY == 2 && hardZNeg) {
            connectZNeg = true;
        }
        if (connectFlagsY == 2 && hardZPos) {
            connectZPos = true;
        }
        if (connectFlagsY == 2 && hardXNeg) {
            connectXNeg = true;
        }
        if (connectFlagsY == 2 && hardXPos) {
            connectXPos = true;
        }
        return connectFlagsY | (connectZNeg ? 4 : 0) | (connectZPos ? 8 : 0) | (connectXNeg ? 16 : 0) | (connectXPos ? 32 : 0);
    }

    private int calcConnectYFlags(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != this) {
            return 0;
        }
        Block blockYNeg = world.func_147439_a(x, y - 1, z);
        boolean hardYNeg = this.isNeighborHardConnectionY(world, x, y - 1, z, blockYNeg, ForgeDirection.DOWN);
        boolean connectYNeg = hardYNeg || blockYNeg == this;
        Block blockYPos = world.func_147439_a(x, y + 1, z);
        boolean hardYPos = this.isNeighborHardConnectionY(world, x, y + 1, z, blockYPos, ForgeDirection.UP);
        boolean connectYPos = hardYPos || blockYPos == this || blockYPos instanceof BlockTorch;
        return (connectYNeg ? 1 : 0) | (connectYPos ? 2 : 0) | (hardYNeg ? 4 : 0) | (hardYPos ? 8 : 0);
    }

    private boolean isNeighborHardConnection(IBlockAccess world, int x, int y, int z, Block block, ForgeDirection side) {
        if (block.func_149688_o().func_76218_k() && block.func_149686_d()) {
            return true;
        }
        return block.isSideSolid(world, x, y, z, side.getOpposite());
    }

    private boolean isNeighborHardConnectionY(IBlockAccess world, int x, int y, int z, Block block, ForgeDirection side) {
        if (this.isNeighborHardConnection(world, x, y, z, block, side)) {
            return true;
        }
        return block instanceof BlockLeavesBase || block == ModBlocks.thinLogFence;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List blockList) {
        for (int i = 0; i < 6; ++i) {
            blockList.add(new ItemStack(item, 1, i));
        }
        for (Map.Entry<UniqueMetaIdentifier, Block> entry : WoodRegistry.instance().registeredTypes()) {
            if (entry.getValue() == Blocks.field_150364_r || entry.getValue() == Blocks.field_150363_s) continue;
            int id = TileEntityWoodProxy.composeMetadata(entry.getValue(), entry.getKey().meta);
            blockList.add(new ItemStack(item, 1, id));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        int ometa = 0;
        if (this.orientation == 1) {
            ometa |= 8;
        } else if (this.orientation == 2) {
            ometa |= 4;
        } else if (this.orientation == 3) {
            ometa |= 0xC;
        }
        int protoMeta = TileEntityWoodProxy.getMetaFromComposedMetadata(meta);
        Block protoBlock = TileEntityWoodProxy.getBlockFromComposedMetadata(meta);
        if (protoBlock == null) {
            protoBlock = this.getIconSource(meta);
        }
        return protoBlock.func_149691_a(side, protoMeta | ometa);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntityWoodProxy te = this.getTileEntity(blockAccess, x, y, z);
        if (te == null || te.getProtoBlock() == null) {
            return super.func_149673_e(blockAccess, x, y, z, side);
        }
        int ometa = 0;
        if (this.orientation == 1) {
            ometa |= 8;
        } else if (this.orientation == 2) {
            ometa |= 4;
        } else if (this.orientation == 3) {
            ometa |= 0xC;
        }
        int protoMeta = te.getProtoMeta();
        Block protoBlock = te.getProtoBlock();
        if (protoBlock == null) {
            protoBlock = Blocks.field_150364_r;
        }
        return protoBlock.func_149691_a(side, protoMeta | ometa);
    }

    private Block getIconSource(int meta) {
        switch (meta / 4) {
            case 0: {
                return Blocks.field_150364_r;
            }
            case 1: {
                return Blocks.field_150363_s;
            }
        }
        return Blocks.field_150364_r;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntityWoodProxy te = this.getTileEntity((IBlockAccess)worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        BlockThinLog block = this.getBlock((IBlockAccess)worldObj, target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (te == null || block == null) {
            return false;
        }
        int protoMeta = te.getProtoMeta();
        Block protoBlock = te.getProtoBlock();
        if (protoBlock == null) {
            protoBlock = Blocks.field_150364_r;
            protoMeta = worldObj.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        }
        float f = 0.1f;
        double xPos = (double)target.field_72311_b + worldObj.field_73012_v.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(f * 2.0f)) + (double)f + block.func_149704_x();
        double yPos = (double)target.field_72312_c + worldObj.field_73012_v.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(f * 2.0f)) + (double)f + block.func_149665_z();
        double zPos = (double)target.field_72309_d + worldObj.field_73012_v.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(f * 2.0f)) + (double)f + block.func_149706_B();
        if (target.field_72310_e == 0) {
            yPos = (double)target.field_72312_c + block.func_149665_z() - (double)f;
        }
        if (target.field_72310_e == 1) {
            yPos = (double)target.field_72312_c + block.func_149669_A() + (double)f;
        }
        if (target.field_72310_e == 2) {
            zPos = (double)target.field_72309_d + block.func_149706_B() - (double)f;
        }
        if (target.field_72310_e == 3) {
            zPos = (double)target.field_72309_d + block.func_149693_C() + (double)f;
        }
        if (target.field_72310_e == 4) {
            xPos = (double)target.field_72311_b + block.func_149704_x() - (double)f;
        }
        if (target.field_72310_e == 5) {
            xPos = (double)target.field_72311_b + block.func_149753_y() + (double)f;
        }
        EntityDiggingFX fx = new EntityDiggingFX(worldObj, xPos, yPos, zPos, 0.0, 0.0, 0.0, (Block)block, worldObj.func_72805_g(target.field_72311_b, target.field_72312_c, target.field_72309_d));
        fx.func_70596_a(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        fx.func_70543_e(0.2f).func_70541_f(0.6f);
        fx.func_110125_a(block.func_149691_a(worldObj.field_73012_v.nextInt(6), TileEntityWoodProxy.composeMetadata(protoBlock, protoMeta)));
        effectRenderer.func_78873_a((EntityFX)fx);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        TileEntityWoodProxy te = this.getTileEntity((IBlockAccess)world, x, y, z);
        BlockThinLog block = this.getBlock((IBlockAccess)world, x, y, z);
        if (te == null || block == null) {
            return false;
        }
        int protoMeta = te.getProtoMeta();
        Block protoBlock = te.getProtoBlock();
        if (protoBlock == null) {
            protoBlock = Blocks.field_150364_r;
            protoMeta = world.func_72805_g(x, y, z);
        }
        try {
            int count = 4;
            for (int ix = 0; ix < count; ++ix) {
                for (int iy = 0; iy < count; ++iy) {
                    for (int iz = 0; iz < count; ++iz) {
                        double xOff = (double)x + ((double)ix + 0.5) / (double)count;
                        double yOff = (double)y + ((double)iy + 0.5) / (double)count;
                        double zOff = (double)z + ((double)iz + 0.5) / (double)count;
                        EntityDiggingFX fx = new EntityDiggingFX(world, xOff, yOff, zOff, xOff - (double)x - 0.5, yOff - (double)y - 0.5, zOff - (double)z - 0.5, (Block)this, meta);
                        fx.func_110125_a(block.func_149691_a(world.field_73012_v.nextInt(6), TileEntityWoodProxy.composeMetadata(protoBlock, protoMeta)));
                        effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                    }
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    private TileEntityWoodProxy getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te != null && te instanceof TileEntityWoodProxy) {
            return (TileEntityWoodProxy)te;
        }
        return null;
    }

    private BlockThinLog getBlock(IBlockAccess blockAccess, int x, int y, int z) {
        Block block = blockAccess.func_147439_a(x, y, z);
        if (block != null && block instanceof BlockThinLog) {
            return (BlockThinLog)block;
        }
        return null;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityWoodProxy();
    }

    @Override
    public Vec3 getChainAttachPoint(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int connectFlags = this.calcConnectionFlags(blockAccess, x, y, z);
        switch (side) {
            case 0: {
                return (connectFlags & 1) == 0 ? this.attachPoints[0] : null;
            }
            case 1: {
                return (connectFlags & 2) == 0 ? this.attachPoints[1] : null;
            }
            case 2: {
                return (connectFlags & 4) == 0 ? this.attachPoints[2] : null;
            }
            case 3: {
                return (connectFlags & 8) == 0 ? this.attachPoints[3] : null;
            }
            case 4: {
                return (connectFlags & 0x10) == 0 ? this.attachPoints[4] : null;
            }
            case 5: {
                return (connectFlags & 0x20) == 0 ? this.attachPoints[5] : null;
            }
        }
        return null;
    }

    public void func_149651_a(IIconRegister register) {
    }
}

