/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.core.handlers;

import com.jaquadro.minecraft.gardencore.api.IPlantProxy;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.BlockSmallFire;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;

public class ForgeEventHandler {
    @SubscribeEvent
    public void applyBonemeal(BonemealEvent event) {
        IPlantProxy proxy;
        if (event.block instanceof IPlantProxy && (proxy = (IPlantProxy)event.block).applyBonemeal(event.world, event.x, event.y, event.z)) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void playerInteracts(PlayerInteractEvent event) {
        if (event.action == PlayerInteractEvent.Action.LEFT_CLICK_BLOCK) {
            if (event.entityPlayer.field_71075_bZ.field_75098_d) {
                if (BlockSmallFire.extinguishSmallFire(event.world, null, event.x, event.y, event.z, event.face)) {
                    event.setResult(Event.Result.ALLOW);
                    return;
                }
            } else {
                Block block = event.world.func_147439_a(event.x, event.y, event.z);
                if (!block.isAir((IBlockAccess)event.world, event.x, event.y, event.z) && BlockSmallFire.extinguishSmallFire(event.world, null, event.x, event.y, event.z, event.face)) {
                    event.setResult(Event.Result.ALLOW);
                    return;
                }
            }
        }
    }

    @SubscribeEvent
    public void useHoe(UseHoeEvent event) {
        Block block = event.world.func_147439_a(event.x, event.y, event.z);
        if (block instanceof BlockGarden && ((BlockGarden)block).applyHoe(event.world, event.x, event.y, event.z)) {
            event.setResult(Event.Result.ALLOW);
        }
    }
}

