/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block;

import com.jaquadro.minecraft.gardencore.api.GardenCoreAPI;
import com.jaquadro.minecraft.gardencore.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.core.ModBlocks;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class BlockSmallFire
extends Block {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public BlockSmallFire(String name) {
        super(Material.field_151581_o);
        this.func_149711_c(0.0f);
        this.func_149715_a(1.0f);
        this.func_149663_c(name);
        this.func_149658_d("fire");
        this.func_149649_H();
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.smallFireRenderID;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149698_L() {
        return false;
    }

    public boolean func_149703_v() {
        return false;
    }

    private static boolean blockCanHostSmallFlame(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        return GardenCoreAPI.instance().blockCanHostSmallFlame(block, metadata);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return BlockSmallFire.blockCanHostSmallFlame(world, x, y - 1, z);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!BlockSmallFire.blockCanHostSmallFlame(world, x, y - 1, z)) {
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (!BlockSmallFire.blockCanHostSmallFlame(world, x, y - 1, z)) {
            world.func_147468_f(x, y, z);
        } else {
            world.func_147464_a(x, y, z, (Block)this, this.func_149738_a(world) + world.field_73012_v.nextInt(10));
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        entity.func_70015_d(1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (random.nextInt(64) == 0) {
            world.func_72980_b((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "fire.fire", 0.3f + random.nextFloat() * 0.5f, random.nextFloat() * 0.5f + 0.2f, false);
        }
        for (int i = 0; i < 3; ++i) {
            float spawnX = (float)x + random.nextFloat();
            float spawnY = (float)y + random.nextFloat() * 0.5f + 0.2f;
            float spawnZ = (float)z + random.nextFloat();
            world.func_72869_a("smoke", (double)spawnX, (double)spawnY, (double)spawnZ, 0.0, 0.0, 0.0);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150480_ab.func_149691_a(side, meta);
    }

    public MapColor func_149728_f(int meta) {
        return MapColor.field_151656_f;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.icons = new IIcon[]{register.func_94245_a("GardenCore:" + this.func_149641_N() + "_layer_0"), register.func_94245_a("GardenCore:" + this.func_149641_N() + "_layer_1")};
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFireIcon(int layer) {
        return this.icons[layer];
    }

    public static boolean extinguishSmallFire(World world, EntityPlayer player, int x, int y, int z, int direction) {
        switch (direction) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        if (world.func_147439_a(x, y, z) == ModBlocks.smallFire) {
            world.func_72889_a(player, 1004, x, y, z, 0);
            world.func_147468_f(x, y, z);
            return true;
        }
        return false;
    }
}

