/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardencore.block;

import com.jaquadro.minecraft.gardencore.api.GardenCoreAPI;
import com.jaquadro.minecraft.gardencore.api.IBonemealHandler;
import com.jaquadro.minecraft.gardencore.api.IPlantProxy;
import com.jaquadro.minecraft.gardencore.block.BlockGarden;
import com.jaquadro.minecraft.gardencore.block.tile.TileEntityGarden;
import com.jaquadro.minecraft.gardencore.core.ClientProxy;
import com.jaquadro.minecraft.gardencore.util.BindingStack;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class BlockGardenProxy
extends Block
implements IPlantProxy {
    @SideOnly(value=Side.CLIENT)
    private IIcon transpIcon;
    private boolean applyingBonemeal;
    private BindingStack binding = new BindingStack();
    private int reeLightValue;

    public BlockGardenProxy(String blockName) {
        super(Material.field_151585_k);
        this.func_149711_c(0.0f);
        this.func_149713_g(0);
        this.func_149663_c(blockName);
    }

    public float getPlantOffsetX(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        BlockGarden gardenBlock = this.getGardenBlock(blockAccess, x, y, z);
        if (gardenBlock == null) {
            return 0.0f;
        }
        return gardenBlock.getSlotProfile().getPlantOffsetX(blockAccess, x, this.getBaseBlockYCoord(blockAccess, x, y, z), z, slot);
    }

    public float getPlantOffsetY(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        BlockGarden gardenBlock = this.getGardenBlock(blockAccess, x, y, z);
        if (gardenBlock == null) {
            return 0.0f;
        }
        return gardenBlock.getSlotProfile().getPlantOffsetY(blockAccess, x, this.getBaseBlockYCoord(blockAccess, x, y, z), z, slot);
    }

    public float getPlantOffsetZ(IBlockAccess blockAccess, int x, int y, int z, int slot) {
        BlockGarden gardenBlock = this.getGardenBlock(blockAccess, x, y, z);
        if (gardenBlock == null) {
            return 0.0f;
        }
        return gardenBlock.getSlotProfile().getPlantOffsetZ(blockAccess, x, this.getBaseBlockYCoord(blockAccess, x, y, z), z, slot);
    }

    public void bindSlot(World world, int x, int y, int z, TileEntityGarden te, int slot) {
        int data = 0;
        if (this.getPlantBlock(te, slot) != null) {
            data = this.getPlantData(te, slot);
        }
        this.binding.bind(world, x, y, z, slot, data);
    }

    public void unbindSlot(World world, int x, int y, int z, TileEntityGarden te) {
        this.binding.unbind(world, x, y, z);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.gardenProxyRenderID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
        if (te == null) {
            return null;
        }
        BlockGarden garden = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (garden == null) {
            return null;
        }
        int baseY = this.getBaseBlockYCoord((IBlockAccess)world, x, y, z);
        AxisAlignedBB aabb = null;
        for (int slot : garden.getSlotProfile().getPlantSlots()) {
            Block block = this.getPlantBlock(te, slot);
            if (block == null) continue;
            this.bindSlot(world, x, y, z, te, slot);
            try {
                AxisAlignedBB sub = block.func_149668_a(world, x, y, z);
                if (sub == null) continue;
                float offsetX = garden.getSlotProfile().getPlantOffsetX((IBlockAccess)world, x, baseY, z, slot);
                float offsetY = garden.getSlotProfile().getPlantOffsetY((IBlockAccess)world, x, baseY, z, slot);
                float offsetZ = garden.getSlotProfile().getPlantOffsetZ((IBlockAccess)world, x, baseY, z, slot);
                sub.func_72317_d((double)offsetX, (double)offsetY, (double)offsetZ);
                if (aabb == null) {
                    aabb = sub;
                    continue;
                }
                aabb = aabb.func_111270_a(sub);
            }
            catch (Exception e) {
            }
            finally {
                this.unbindSlot(world, x, y, z, te);
            }
        }
        return aabb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
        BlockGarden garden = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (te == null || garden == null) {
            return super.func_149633_g(world, x, y, z);
        }
        int baseY = this.getBaseBlockYCoord((IBlockAccess)world, x, y, z);
        AxisAlignedBB aabb = null;
        for (int slot : garden.getSlotProfile().getPlantSlots()) {
            Block block = this.getPlantBlock(te, slot);
            if (block == null) continue;
            this.bindSlot(world, x, y, z, te, slot);
            try {
                AxisAlignedBB sub = block.func_149633_g(world, x, y, z);
                if (sub == null) continue;
                float offsetX = garden.getSlotProfile().getPlantOffsetX((IBlockAccess)world, x, baseY, z, slot);
                float offsetY = garden.getSlotProfile().getPlantOffsetY((IBlockAccess)world, x, baseY, z, slot);
                float offsetZ = garden.getSlotProfile().getPlantOffsetZ((IBlockAccess)world, x, baseY, z, slot);
                sub.func_72317_d((double)offsetX, (double)offsetY, (double)offsetZ);
                if (aabb == null) {
                    aabb = sub;
                    continue;
                }
                aabb = aabb.func_111270_a(sub);
            }
            catch (Exception e) {
            }
            finally {
                this.unbindSlot(world, x, y, z, te);
            }
        }
        if (aabb == null) {
            aabb = super.func_149633_g(world, x, y, z);
        }
        return aabb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB mask, List list, Entity colliding) {
        TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
        BlockGarden garden = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (te == null || garden == null) {
            super.func_149743_a(world, x, y, z, mask, list, colliding);
            return;
        }
        int baseY = this.getBaseBlockYCoord((IBlockAccess)world, x, y, z);
        for (int slot : garden.getSlotProfile().getPlantSlots()) {
            Block block = this.getPlantBlock(te, slot);
            if (block == null) continue;
            this.bindSlot(world, x, y, z, te, slot);
            try {
                AxisAlignedBB sub = block.func_149668_a(world, x, y, z);
                if (sub == null) continue;
                float offsetX = garden.getSlotProfile().getPlantOffsetX((IBlockAccess)world, x, baseY, z, slot);
                float offsetY = garden.getSlotProfile().getPlantOffsetY((IBlockAccess)world, x, baseY, z, slot);
                float offsetZ = garden.getSlotProfile().getPlantOffsetZ((IBlockAccess)world, x, baseY, z, slot);
                sub.func_72317_d((double)offsetX, (double)offsetY, (double)offsetZ);
                if (!mask.func_72326_a(sub)) continue;
                list.add(sub);
            }
            catch (Exception e) {
            }
            finally {
                this.unbindSlot(world, x, y, z, te);
            }
        }
        if (list.isEmpty()) {
            super.func_149743_a(world, x, y, z, mask, list, colliding);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 startVec, Vec3 endVec) {
        TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
        BlockGarden garden = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (te == null || garden == null) {
            return super.func_149731_a(world, x, y, z, startVec, endVec);
        }
        int baseY = this.getBaseBlockYCoord((IBlockAccess)world, x, y, z);
        MovingObjectPosition mop = null;
        for (int slot : garden.getSlotProfile().getPlantSlots()) {
            Block block = this.getPlantBlock(te, slot);
            if (block == null) continue;
            this.bindSlot(world, x, y, z, te, slot);
            try {
                float offsetX = garden.getSlotProfile().getPlantOffsetX((IBlockAccess)world, x, baseY, z, slot);
                float offsetY = garden.getSlotProfile().getPlantOffsetY((IBlockAccess)world, x, baseY, z, slot);
                float offsetZ = garden.getSlotProfile().getPlantOffsetZ((IBlockAccess)world, x, baseY, z, slot);
                Vec3 slotStartVec = Vec3.func_72443_a((double)(startVec.field_72450_a - (double)offsetX), (double)(startVec.field_72448_b - (double)offsetY), (double)(startVec.field_72449_c - (double)offsetZ));
                Vec3 slotEndVec = Vec3.func_72443_a((double)(endVec.field_72450_a - (double)offsetX), (double)(endVec.field_72448_b - (double)offsetY), (double)(endVec.field_72449_c - (double)offsetZ));
                MovingObjectPosition sub = block.func_149731_a(world, x, y, z, slotStartVec, slotEndVec);
                if (mop != null && !(slotStartVec.func_72436_e(mop.field_72307_f) > slotStartVec.func_72436_e(sub.field_72307_f))) continue;
                mop = sub;
            }
            catch (Exception e) {
            }
            finally {
                this.unbindSlot(world, x, y, z, te);
            }
        }
        return mop;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
        if (te != null) {
            BlockGarden.validateBlockState(te);
        } else {
            world.func_147468_f(x, y, z);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float vx, float vy, float vz) {
        TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
        BlockGarden garden = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (te == null || garden == null) {
            return false;
        }
        boolean flag = false;
        for (int slot : garden.getSlotProfile().getPlantSlots()) {
            Block block = this.getPlantBlock(te, slot);
            if (block == null) continue;
            this.bindSlot(world, x, y, z, te, slot);
            try {
                flag |= block.func_149727_a(world, x, y, z, player, side, vx, vy, vz);
            }
            catch (Exception e) {
            }
            finally {
                this.unbindSlot(world, x, y, z, te);
            }
        }
        if (flag) {
            return true;
        }
        BlockGarden block = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (block != null) {
            y = this.getBaseBlockYCoord((IBlockAccess)world, x, y, z);
            return block.applyItemToGarden(world, x, y, z, player, null);
        }
        return false;
    }

    @Override
    public boolean applyBonemeal(World world, int x, int y, int z) {
        BlockGarden block = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (block == null) {
            return false;
        }
        y = this.getBaseBlockYCoord((IBlockAccess)world, x, y, z);
        TileEntityGarden te = block.getTileEntity((IBlockAccess)world, x, y, z);
        boolean handled = false;
        block0: for (int slot : block.getSlotProfile().getPlantSlots()) {
            for (IBonemealHandler handler : GardenCoreAPI.instance().getBonemealHandlers()) {
                if (!handler.applyBonemeal(world, x, y, z, block, slot)) continue;
                handled = true;
                continue block0;
            }
        }
        return handled;
    }

    public void func_149681_a(World world, int x, int y, int z, int p_149681_5_, EntityPlayer player) {
        TileEntityGarden te;
        super.func_149681_a(world, x, y, z, p_149681_5_, player);
        if (player.field_71075_bZ.field_75098_d && (te = this.getGardenEntity((IBlockAccess)world, x, y, z)) != null) {
            te.clearPlantedContents();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int data) {
        if (this.hasValidUnderBlock((IBlockAccess)world, x, y, z) && !this.isApplyingBonemealTo(x, y, z)) {
            TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
            BlockGarden garden = this.getGardenBlock((IBlockAccess)world, x, y, z);
            if (te != null && block != null) {
                for (int slot : garden.getSlotProfile().getPlantSlots()) {
                    ItemStack item = te.getPlantInSlot(slot);
                    if (item == null) continue;
                    this.func_149642_a(world, x, y, z, item);
                }
                te.clearPlantedContents();
            }
        }
        world.func_147460_e(x, y + 1, z, block);
        world.func_147460_e(x, y - 1, z, block);
        if (!this.isApplyingBonemealTo(x, y, z) && world.func_147439_a(x, y - 1, z) == this) {
            world.func_147468_f(x, y - 1, z);
        }
        super.func_149749_a(world, x, y, z, block, data);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        return drops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (this.reeLightValue > 0) {
            return -1;
        }
        ++this.reeLightValue;
        int value = 0;
        TileEntityGarden te = this.getGardenEntity(world, x, y, z);
        BlockGarden garden = this.getGardenBlock(world, x, y, z);
        if (te == null || garden == null) {
            value = super.getLightValue(world, x, y, z);
        } else {
            for (int slot : garden.getSlotProfile().getPlantSlots()) {
                Block block = this.getPlantBlock(te, slot);
                if (block == null) continue;
                this.bindSlot(te.func_145831_w(), x, y, z, te, slot);
                try {
                    int sub = block.getLightValue(world, x, y, z);
                    if (sub == -1) {
                        sub = block.func_149750_m();
                    }
                    if (sub == -1) {
                        sub = this.func_149750_m();
                    }
                    if (sub <= value) continue;
                    value = sub;
                }
                catch (Exception e) {
                }
                finally {
                    this.unbindSlot(te.func_145831_w(), x, y, z, te);
                }
            }
        }
        --this.reeLightValue;
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
        BlockGarden garden = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (te == null || garden == null) {
            return;
        }
        for (int slot : garden.getSlotProfile().getPlantSlots()) {
            Block block = this.getPlantBlock(te, slot);
            if (block == null) continue;
            this.bindSlot(world, x, y, z, te, slot);
            try {
                block.func_149670_a(world, x, y, z, entity);
            }
            catch (Exception e) {
            }
            finally {
                this.unbindSlot(world, x, y, z, te);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
        BlockGarden garden = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (te == null || garden == null) {
            return;
        }
        for (int slot : garden.getSlotProfile().getPlantSlots()) {
            Block block = this.getPlantBlock(te, slot);
            if (block == null) continue;
            this.bindSlot(world, x, y, z, te, slot);
            try {
                block.func_149734_b(world, x, y, z, random);
            }
            catch (Exception e) {
            }
            finally {
                this.unbindSlot(world, x, y, z, te);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess blockAccess, int x, int y, int z) {
        int slot = this.binding.getSlot();
        TileEntityGarden te = this.getGardenEntity(blockAccess, x, y, z);
        if (te == null || slot == -1) {
            return super.func_149720_d(blockAccess, x, y, z);
        }
        Block block = this.getPlantBlockRestricted(te, slot);
        if (block == null) {
            return super.func_149720_d(blockAccess, x, y, z);
        }
        try {
            return block.func_149720_d(blockAccess, x, y, z);
        }
        catch (Exception e) {
            return super.func_149720_d(blockAccess, x, y, z);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int slot = this.binding.getSlot();
        TileEntityGarden te = this.getGardenEntity(blockAccess, x, y, z);
        if (te == null || slot == -1) {
            return super.func_149673_e(blockAccess, x, y, z, side);
        }
        Block block = this.getPlantBlockRestricted(te, slot);
        if (block == null) {
            return super.func_149673_e(blockAccess, x, y, z, side);
        }
        try {
            return block.func_149673_e(blockAccess, x, y, z, side);
        }
        catch (Exception e) {
            return super.func_149673_e(blockAccess, x, y, z, side);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int data) {
        return this.transpIcon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        TileEntityGarden te = this.getGardenEntity((IBlockAccess)world, x, y, z);
        BlockGarden garden = this.getGardenBlock((IBlockAccess)world, x, y, z);
        if (te == null || garden == null) {
            return true;
        }
        for (int slot : garden.getSlotProfile().getPlantSlots()) {
            Block block = this.getPlantBlock(te, slot);
            int blockData = this.getPlantData(te, slot);
            if (block == null) continue;
            this.bindSlot(world, x, y, z, te, slot);
            try {
                int count = 4;
                for (int ix = 0; ix < count; ++ix) {
                    for (int iy = 0; iy < count; ++iy) {
                        for (int iz = 0; iz < count; ++iz) {
                            double xOff = (double)x + ((double)ix + 0.5) / (double)count;
                            double yOff = (double)y + ((double)iy + 0.5) / (double)count;
                            double zOff = (double)z + ((double)iz + 0.5) / (double)count;
                            EntityDiggingFX fx = new EntityDiggingFX(world, xOff, yOff, zOff, xOff - (double)x - 0.5, yOff - (double)y - 0.5, zOff - (double)z - 0.5, (Block)this, meta);
                            fx.func_110125_a(block.func_149691_a(world.field_73012_v.nextInt(6), blockData));
                            effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                        }
                    }
                }
            }
            catch (Exception e) {
            }
            finally {
                this.unbindSlot(world, x, y, z, te);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.transpIcon = iconRegister.func_94245_a("GardenCore:proxy_transp");
    }

    private boolean hasValidUnderBlock(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return false;
        }
        Block underBlock = world.func_147439_a(x, y - 1, z);
        return underBlock instanceof BlockGarden || underBlock instanceof IPlantProxy;
    }

    private int getBaseBlockYCoord(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return 0;
        }
        Block underBlock = world.func_147439_a(x, --y, z);
        while (y > 0 && underBlock instanceof IPlantProxy) {
            underBlock = world.func_147439_a(x, --y, z);
        }
        return y;
    }

    public BlockGarden getGardenBlock(IBlockAccess world, int x, int y, int z) {
        if (y == 0) {
            return null;
        }
        Block underBlock = world.func_147439_a(x, y = this.getBaseBlockYCoord(world, x, y, z), z);
        if (!(underBlock instanceof BlockGarden)) {
            return null;
        }
        return (BlockGarden)underBlock;
    }

    @Override
    public TileEntityGarden getGardenEntity(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y = this.getBaseBlockYCoord(world, x, y, z), z);
        if (!(tileEntity instanceof TileEntityGarden)) {
            return null;
        }
        return (TileEntityGarden)tileEntity;
    }

    public Block getPlantBlock(TileEntityGarden tileEntity, int slot) {
        ItemStack itemStack = tileEntity.getPlantInSlot(slot);
        if (itemStack == null) {
            return null;
        }
        return this.getPlantBlock(tileEntity, itemStack.func_77973_b());
    }

    public Block getPlantBlockRestricted(TileEntityGarden tileEntity, int slot) {
        ItemStack itemStack = tileEntity.getStackInSlotIsolated(slot);
        if (itemStack == null) {
            return null;
        }
        return this.getPlantBlock(tileEntity, itemStack.func_77973_b());
    }

    private Block getPlantBlock(TileEntityGarden tileEntity, Item item) {
        if (item == null) {
            return null;
        }
        if (item instanceof IPlantable) {
            return ((IPlantable)item).getPlant((IBlockAccess)tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
        }
        if (item instanceof ItemBlock) {
            return Block.func_149634_a((Item)item);
        }
        return null;
    }

    public int getPlantData(TileEntityGarden tileEntity, int slot) {
        ItemStack itemStack = tileEntity.getPlantInSlot(slot);
        if (itemStack == null) {
            return 0;
        }
        return itemStack.func_77960_j();
    }

    private void setPlantData(TileEntityGarden tileEntity, int slot, int data) {
        ItemStack itemStack = tileEntity.getPlantInSlot(slot);
        if (itemStack != null) {
            itemStack.func_77964_b(data);
            tileEntity.func_70299_a(slot, itemStack);
        }
    }

    private boolean isApplyingBonemealTo(int x, int y, int z) {
        return this.applyingBonemeal;
    }
}

