/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.gardenapi.internal.registry;

import com.jaquadro.minecraft.gardenapi.api.connect.IAttachable;
import com.jaquadro.minecraft.gardenapi.api.connect.IAttachableRegistry;
import com.jaquadro.minecraft.gardenapi.api.connect.StandardAttachable;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaIdentifier;
import com.jaquadro.minecraft.gardencore.util.UniqueMetaRegistry;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class AttachableRegistry
implements IAttachableRegistry {
    private UniqueMetaRegistry<IAttachable> registry = new UniqueMetaRegistry();

    public AttachableRegistry() {
        this.init();
    }

    private void init() {
        int i;
        for (i = 0; i < 8; ++i) {
            this.registerAttachable((Block)Blocks.field_150333_U, i, (IAttachable)StandardAttachable.createTop(0.5));
            this.registerAttachable((Block)Blocks.field_150376_bx, i, (IAttachable)StandardAttachable.createTop(0.5));
        }
        for (i = 8; i < 16; ++i) {
            this.registerAttachable((Block)Blocks.field_150333_U, i, (IAttachable)StandardAttachable.createBottom(0.5));
            this.registerAttachable((Block)Blocks.field_150376_bx, i, (IAttachable)StandardAttachable.createBottom(0.5));
        }
    }

    @Override
    public void registerAttachable(String modId, String blockId, int meta, IAttachable attachable) {
        if (modId != null && blockId != null && attachable != null) {
            UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, blockId, meta);
            this.registry.register(id, attachable);
        }
    }

    @Override
    public void registerAttachable(String modId, String blockId, IAttachable attachable) {
        if (modId != null && blockId != null && attachable != null) {
            UniqueMetaIdentifier id = new UniqueMetaIdentifier(modId, blockId);
            this.registry.register(id, attachable);
        }
    }

    @Override
    public void registerAttachable(Block block, int meta, IAttachable attachable) {
        if (block != null && attachable != null) {
            UniqueMetaIdentifier id = UniqueMetaIdentifier.createFor(block, meta);
            this.registry.register(id, attachable);
        }
    }

    @Override
    public void registerAttachable(Block block, IAttachable attachable) {
        if (block != null && attachable != null) {
            UniqueMetaIdentifier id = UniqueMetaIdentifier.createFor(block);
            this.registry.register(id, attachable);
        }
    }

    @Override
    public void registerAttachable(ItemStack blockItemStack, IAttachable attachable) {
        UniqueMetaIdentifier id = UniqueMetaIdentifier.createFor(blockItemStack);
        if (id != null && attachable != null) {
            this.registry.register(id, attachable);
        }
    }

    @Override
    public IAttachable getAttachable(Block block, int meta) {
        UniqueMetaIdentifier id = UniqueMetaIdentifier.createFor(block, meta);
        if (id != null) {
            return this.registry.getEntry(id);
        }
        return null;
    }
}

