/*
 * Decompiled with CFR 0.152.
 */
package org.mod.luaj.vm2.luajc;

import java.util.HashMap;
import java.util.Map;
import org.mod.luaj.vm2.LuaFunction;
import org.mod.luaj.vm2.LuaValue;
import org.mod.luaj.vm2.Prototype;
import org.mod.luaj.vm2.luajc.JavaGen;

public class JavaLoader
extends ClassLoader {
    private Map<String, byte[]> unloaded = new HashMap<String, byte[]>();

    public LuaFunction load(Prototype p, String classname, String filename, LuaValue env) {
        JavaGen jg = new JavaGen(p, classname, filename, false);
        return this.load(jg, env);
    }

    public LuaFunction load(JavaGen jg, LuaValue env) {
        this.include(jg);
        return this.load(jg.classname, env);
    }

    public LuaFunction load(String classname, LuaValue env) {
        try {
            Class<?> c = this.loadClass(classname);
            LuaFunction v = (LuaFunction)c.newInstance();
            v.initupvalue1(env);
            return v;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("bad class gen: " + e);
        }
    }

    public void include(JavaGen jg) {
        int n;
        this.unloaded.put(jg.classname, jg.bytecode);
        int n2 = n = jg.inners != null ? jg.inners.length : 0;
        for (int i = 0; i < n; ++i) {
            this.include(jg.inners[i]);
        }
    }

    public Class findClass(String classname) throws ClassNotFoundException {
        byte[] bytes = this.unloaded.get(classname);
        if (bytes != null) {
            return this.defineClass(classname, bytes, 0, bytes.length);
        }
        return super.findClass(classname);
    }
}

