/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.carts;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mods.railcraft.api.carts.IItemTransfer;
import mods.railcraft.api.carts.ILinkageManager;
import mods.railcraft.api.core.items.IMinecartItem;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class CartTools {
    private static final GameProfile railcraftProfile = new GameProfile(UUID.nameUUIDFromBytes("[Railcraft]".getBytes()), "[Railcraft]");
    public static ILinkageManager linkageManager;

    public static ILinkageManager getLinkageManager(World world) {
        return linkageManager;
    }

    public static void setCartOwner(EntityMinecart cart, EntityPlayer owner) {
        CartTools.setCartOwner(cart, owner.func_146103_bH());
    }

    public static void setCartOwner(EntityMinecart cart, GameProfile owner) {
        if (!cart.field_70170_p.field_72995_K) {
            NBTTagCompound data = cart.getEntityData();
            if (owner.getName() != null) {
                data.func_74778_a("owner", owner.getName());
            }
            if (owner.getId() != null) {
                data.func_74778_a("ownerId", owner.getId().toString());
            }
        }
    }

    public static GameProfile getCartOwner(EntityMinecart cart) {
        NBTTagCompound data = cart.getEntityData();
        String ownerName = "[Unknown]";
        if (data.func_74764_b("owner")) {
            ownerName = data.func_74779_i("owner");
        }
        UUID ownerId = null;
        if (data.func_74764_b("ownerId")) {
            ownerId = UUID.fromString(data.func_74779_i("ownerId"));
        }
        return new GameProfile(ownerId, ownerName);
    }

    public static boolean doesCartHaveOwner(EntityMinecart cart) {
        NBTTagCompound data = cart.getEntityData();
        return data.func_74764_b("owner");
    }

    public static EntityMinecart placeCart(GameProfile owner, ItemStack cart, WorldServer world, int x, int y, int z) {
        if (cart == null) {
            return null;
        }
        if ((cart = cart.func_77946_l()).func_77973_b() instanceof IMinecartItem) {
            IMinecartItem mi = (IMinecartItem)cart.func_77973_b();
            return mi.placeCart(owner, cart, (World)world, x, y, z);
        }
        if (cart.func_77973_b() instanceof ItemMinecart) {
            try {
                List<EntityMinecart> carts;
                boolean placed = cart.func_77973_b().func_77648_a(cart, (EntityPlayer)FakePlayerFactory.get((WorldServer)world, (GameProfile)railcraftProfile), (World)world, x, y, z, 0, 0.0f, 0.0f, 0.0f);
                if (placed && (carts = CartTools.getMinecartsAt((World)world, x, y, z, 0.3f)).size() > 0) {
                    CartTools.setCartOwner(carts.get(0), owner);
                    return carts.get(0);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static void offerOrDropItem(EntityMinecart cart, ItemStack stack) {
        EntityMinecart link_A = CartTools.getLinkageManager(cart.field_70170_p).getLinkedCartA(cart);
        EntityMinecart link_B = CartTools.getLinkageManager(cart.field_70170_p).getLinkedCartB(cart);
        if (stack != null && stack.field_77994_a > 0 && link_A instanceof IItemTransfer) {
            stack = ((IItemTransfer)link_A).offerItem(cart, stack);
        }
        if (stack != null && stack.field_77994_a > 0 && link_B instanceof IItemTransfer) {
            stack = ((IItemTransfer)link_B).offerItem(cart, stack);
        }
        if (stack != null && stack.field_77994_a > 0) {
            cart.func_70099_a(stack, 1.0f);
        }
    }

    public static boolean isMinecartOnRailAt(World world, int i, int j, int k, float sensitivity) {
        return CartTools.isMinecartOnRailAt(world, i, j, k, sensitivity, null, true);
    }

    public static boolean isMinecartOnRailAt(World world, int i, int j, int k, float sensitivity, Class<? extends EntityMinecart> type2, boolean subclass) {
        if (BlockRailBase.func_150049_b_((World)world, (int)i, (int)j, (int)k)) {
            return CartTools.isMinecartAt(world, i, j, k, sensitivity, type2, subclass);
        }
        return false;
    }

    public static boolean isMinecartOnAnySide(World world, int i, int j, int k, float sensitivity) {
        return CartTools.isMinecartOnAnySide(world, i, j, k, sensitivity, null, true);
    }

    public static boolean isMinecartOnAnySide(World world, int i, int j, int k, float sensitivity, Class<? extends EntityMinecart> type2, boolean subclass) {
        ArrayList<EntityMinecart> list = new ArrayList<EntityMinecart>();
        for (int side = 0; side < 6; ++side) {
            list.addAll(CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, ForgeDirection.getOrientation((int)side)));
        }
        if (type2 == null) {
            return !list.isEmpty();
        }
        for (EntityMinecart cart : list) {
            if ((!subclass || !type2.isInstance(cart)) && cart.getClass() != type2) continue;
            return true;
        }
        return false;
    }

    public static boolean isMinecartAt(World world, int i, int j, int k, float sensitivity) {
        return CartTools.isMinecartAt(world, i, j, k, sensitivity, null, true);
    }

    public static boolean isMinecartAt(World world, int i, int j, int k, float sensitivity, Class<? extends EntityMinecart> type2, boolean subclass) {
        List<EntityMinecart> list = CartTools.getMinecartsAt(world, i, j, k, sensitivity);
        if (type2 == null) {
            return !list.isEmpty();
        }
        for (EntityMinecart cart : list) {
            if ((!subclass || !type2.isInstance(cart)) && cart.getClass() != type2) continue;
            return true;
        }
        return false;
    }

    public static List<EntityMinecart> getMinecartsOnAllSides(World world, int i, int j, int k, float sensitivity) {
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (int side = 0; side < 6; ++side) {
            carts.addAll(CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, ForgeDirection.getOrientation((int)side)));
        }
        return carts;
    }

    public static List<EntityMinecart> getMinecartsOnAllSides(World world, int i, int j, int k, float sensitivity, Class<? extends EntityMinecart> type2, boolean subclass) {
        ArrayList<EntityMinecart> list = new ArrayList<EntityMinecart>();
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (int side = 0; side < 6; ++side) {
            list.addAll(CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, ForgeDirection.getOrientation((int)side)));
        }
        for (EntityMinecart cart : list) {
            if ((!subclass || !type2.isInstance(cart)) && cart.getClass() != type2) continue;
            carts.add(cart);
        }
        return carts;
    }

    private static int getYOnSide(int y, ForgeDirection side) {
        switch (side) {
            case UP: {
                return y + 1;
            }
            case DOWN: {
                return y - 1;
            }
        }
        return y;
    }

    private static int getXOnSide(int x, ForgeDirection side) {
        switch (side) {
            case EAST: {
                return x + 1;
            }
            case WEST: {
                return x - 1;
            }
        }
        return x;
    }

    private static int getZOnSide(int z, ForgeDirection side) {
        switch (side) {
            case NORTH: {
                return z - 1;
            }
            case SOUTH: {
                return z + 1;
            }
        }
        return z;
    }

    public static List<EntityMinecart> getMinecartsOnSide(World world, int i, int j, int k, float sensitivity, ForgeDirection side) {
        return CartTools.getMinecartsAt(world, CartTools.getXOnSide(i, side), CartTools.getYOnSide(j, side), CartTools.getZOnSide(k, side), sensitivity);
    }

    public static boolean isMinecartOnSide(World world, int i, int j, int k, float sensitivity, ForgeDirection side) {
        return CartTools.getMinecartOnSide(world, i, j, k, sensitivity, side) != null;
    }

    public static EntityMinecart getMinecartOnSide(World world, int i, int j, int k, float sensitivity, ForgeDirection side) {
        Iterator<EntityMinecart> i$ = CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, side).iterator();
        if (i$.hasNext()) {
            EntityMinecart cart = i$.next();
            return cart;
        }
        return null;
    }

    public static boolean isMinecartOnSide(World world, int i, int j, int k, float sensitivity, ForgeDirection side, Class<? extends EntityMinecart> type2, boolean subclass) {
        return CartTools.getMinecartOnSide(world, i, j, k, sensitivity, side, type2, subclass) != null;
    }

    public static <T extends EntityMinecart> T getMinecartOnSide(World world, int i, int j, int k, float sensitivity, ForgeDirection side, Class<T> type2, boolean subclass) {
        for (EntityMinecart cart : CartTools.getMinecartsOnSide(world, i, j, k, sensitivity, side)) {
            if (type2 != null && (!subclass || !type2.isInstance(cart)) && cart.getClass() != type2) continue;
            return (T)cart;
        }
        return null;
    }

    public static List<EntityMinecart> getMinecartsAt(World world, int i, int j, int k, float sensitivity) {
        sensitivity = Math.min(sensitivity, 0.49f);
        List entities = world.func_72872_a(EntityMinecart.class, AxisAlignedBB.func_72330_a((double)((float)i + sensitivity), (double)((float)j + sensitivity), (double)((float)k + sensitivity), (double)((float)(i + 1) - sensitivity), (double)((float)(j + 1) - sensitivity), (double)((float)(k + 1) - sensitivity)));
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (Object o : entities) {
            EntityMinecart cart = (EntityMinecart)o;
            if (cart.field_70128_L) continue;
            carts.add((EntityMinecart)o);
        }
        return carts;
    }

    public static List<EntityMinecart> getMinecartsIn(World world, int i1, int j1, int k1, int i2, int j2, int k2) {
        List entities = world.func_72872_a(EntityMinecart.class, AxisAlignedBB.func_72330_a((double)i1, (double)j1, (double)k1, (double)i2, (double)j2, (double)k2));
        ArrayList<EntityMinecart> carts = new ArrayList<EntityMinecart>();
        for (Object o : entities) {
            EntityMinecart cart = (EntityMinecart)o;
            if (cart.field_70128_L) continue;
            carts.add((EntityMinecart)o);
        }
        return carts;
    }

    public static double getCartSpeedUncapped(EntityMinecart cart) {
        return Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
    }

    public static boolean cartVelocityIsLessThan(EntityMinecart cart, float vel) {
        return Math.abs(cart.field_70159_w) < (double)vel && Math.abs(cart.field_70179_y) < (double)vel;
    }
}

