/*
 * Decompiled with CFR 0.152.
 */
package emasher.tileentities;

import emasher.tileentities.TileAdapterBase;
import emasher.util.Config;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileMiniPortal
extends TileAdapterBase
implements IFluidHandler {
    public static final int CAPACITY = 8000;
    public FluidTank tank = new FluidTank(8000);
    public int partnerX;
    public int partnerY;
    public int partnerZ;

    @Override
    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.tank.writeToNBT(data);
        data.func_74768_a("partnerX", this.partnerX);
        data.func_74768_a("partnerY", this.partnerY);
        data.func_74768_a("partnerZ", this.partnerZ);
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tank.readFromNBT(data);
        if (data.func_74764_b("partnerX")) {
            this.partnerX = data.func_74762_e("partnerX");
        }
        if (data.func_74764_b("partnerY")) {
            this.partnerY = data.func_74762_e("partnerY");
        }
        if (data.func_74764_b("partnerZ")) {
            this.partnerZ = data.func_74762_e("partnerZ");
        }
    }

    public void func_145845_h() {
        for (int i = 0; i < 6; ++i) {
            if (!this.outputs[i]) continue;
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            int xo = this.field_145851_c + d.offsetX;
            int yo = this.field_145848_d + d.offsetY;
            int zo = this.field_145849_e + d.offsetZ;
            TileEntity te = this.field_145850_b.func_147438_o(xo, yo, zo);
            if (te == null || !(te instanceof IFluidHandler)) continue;
            int amnt = ((IFluidHandler)te).fill(d.getOpposite(), this.drain(d, 16000, false), true);
            this.drain(d, amnt, true);
        }
    }

    public World getOtherWorld() {
        if (this.field_145850_b.field_73011_w.field_76574_g == 0) {
            return MinecraftServer.func_71276_C().func_71218_a(-1);
        }
        if (this.field_145850_b.field_73011_w.field_76574_g == -1) {
            return MinecraftServer.func_71276_C().func_71218_a(0);
        }
        return null;
    }

    public void setPartner(int x, int y, int z) {
        this.partnerX = x;
        this.partnerY = y;
        this.partnerZ = z;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        TileEntity te;
        World other;
        int result = this.tank.fill(resource, doFill);
        FluidStack resource2 = resource.copy();
        resource2.amount -= result;
        if (resource2.amount > 0 && (other = this.getOtherWorld()) != null && (te = other.func_147438_o(this.partnerX, this.partnerY, this.partnerZ)) != null && te instanceof TileMiniPortal) {
            TileMiniPortal partner = (TileMiniPortal)te;
            result = partner.tank.fill(resource2, doFill);
        }
        return result;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null || !resource.isFluidEqual(this.tank.getFluid())) {
            return null;
        }
        FluidStack result = this.tank.drain(resource.amount, doDrain);
        if (result == null || result != null && result.amount < resource.amount) {
            TileEntity te;
            int newAmnt = result != null ? resource.amount - result.amount : resource.amount;
            World other = this.getOtherWorld();
            if (other != null && (te = other.func_147438_o(this.partnerX, this.partnerY, this.partnerZ)) != null && te instanceof TileMiniPortal) {
                TileMiniPortal partner = (TileMiniPortal)te;
                if (resource.isFluidEqual(partner.tank.getFluid())) {
                    if (result != null) {
                        result.amount += partner.tank.drain((int)newAmnt, (boolean)doDrain).amount;
                    } else {
                        result = partner.tank.drain(newAmnt, doDrain);
                    }
                }
            }
        }
        return result;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack result = this.tank.drain(maxDrain, doDrain);
        if (result == null || result != null && result.amount < maxDrain) {
            TileEntity te;
            int newAmnt = result == null ? maxDrain : maxDrain - result.amount;
            World other = this.getOtherWorld();
            if (other != null && (te = other.func_147438_o(this.partnerX, this.partnerY, this.partnerZ)) != null && te instanceof TileMiniPortal) {
                TileMiniPortal partner = (TileMiniPortal)te;
                if (result == null || result != null && result.isFluidEqual(partner.tank.getFluid())) {
                    if (result != null) {
                        result.amount += partner.tank.drain((int)newAmnt, (boolean)doDrain).amount;
                    } else {
                        result = partner.tank.drain(newAmnt, doDrain);
                    }
                }
            }
        }
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.getID() != FluidRegistry.LAVA.getID() || Config.miniPortalLava();
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.tank.getInfo()};
    }
}

