/*
 * Decompiled with CFR 0.152.
 */
package emasher.modules;

import cpw.mods.fml.common.registry.GameRegistry;
import emasher.api.SideConfig;
import emasher.api.SocketModule;
import emasher.api.SocketTileAccess;
import emasher.items.Items;
import emasher.util.Config;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public class ModWaterMill
extends SocketModule {
    public ModWaterMill(int id) {
        super(id, "eng_toolbox:waterMill");
    }

    @Override
    public String getLocalizedName() {
        return "Hydroelectric Turbine";
    }

    public void getToolTip(List l) {
        l.add("Generates power in a river");
    }

    public void getIndicatorKey(List l) {
        l.add(Config.PREF_AQUA() + "Generates 10 RF/t");
        l.add("Can only be installed on the sides of a socket");
        l.add("Only one can be installed per socket");
        l.add("Only generates power when in some sort of river biome");
        l.add("Only generates power for y = [64, 40]");
        l.add("Only generates power when adjacent to a water source block");
    }

    @Override
    public void addRecipe() {
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Items.module(), 1, this.moduleID), (Object[])new Object[]{"sps", "sps", "sbs", Character.valueOf('s'), Blocks.field_150443_bT, Character.valueOf('p'), Items.psu(), Character.valueOf('u'), Blocks.field_150484_ah, Character.valueOf('b'), new ItemStack(Items.module(), 1, 7)});
    }

    @Override
    public boolean canBeInstalled(SocketTileAccess ts, ForgeDirection side) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            ForgeDirection d = ForgeDirection.getOrientation((int)i);
            if (d == side) continue;
            SocketModule m = ts.getSide(d);
            if (m.moduleID != this.moduleID) continue;
            return false;
        }
        return true;
    }

    @Override
    public void updateSide(SideConfig config, SocketTileAccess ts, ForgeDirection side) {
        if (ts.getMaxEnergyStored() - ts.getEnergyStored() >= 10) {
            int xo = ts.field_145851_c + side.offsetX;
            int yo = ts.field_145848_d + side.offsetY;
            int zo = ts.field_145849_e + side.offsetZ;
            Block block = ts.func_145831_w().func_147439_a(xo, yo, zo);
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                int biomeID = ts.func_145831_w().func_72807_a((int)xo, (int)zo).field_76756_M;
                String biomeName = ts.func_145831_w().func_72807_a((int)xo, (int)zo).field_76791_y;
                if ((biomeID == BiomeGenBase.field_76781_i.field_76756_M || biomeID == BiomeGenBase.field_76777_m.field_76756_M || biomeName.contains("iver") || biomeName.contains("tream")) && ts.field_145848_d <= 64 && ts.field_145848_d >= 40 && side != ForgeDirection.UP && side != ForgeDirection.DOWN) {
                    ts.addEnergy(10, false);
                }
            }
        }
    }
}

