/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.wiiemc.providers;

import com.pahimar.ee3.api.exchange.EnergyValue;
import com.pahimar.ee3.api.exchange.EnergyValueRegistryProxy;
import java.text.DecimalFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.lomeli.wiiemc.WIIEMC;
import net.lomeli.wiiemc.config.ModConfig;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class BlockEMCDataProvider
implements IWailaDataProvider {
    private static DecimalFormat energyValueDecimalFormat = new DecimalFormat("###,###,###,###,###.###");

    public ItemStack getWailaStack(IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return null;
    }

    public List<String> getWailaHead(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        Block block = accessor.getBlock();
        int meta = accessor.getMetadata();
        MovingObjectPosition pos = accessor.getPosition();
        if (block != null) {
            Item item;
            ItemStack stack = new ItemStack(block, 1, meta);
            boolean isKnown = WIIEMC.proxy.doesPlayerKnow(stack);
            boolean canBeLearned = WIIEMC.proxy.canPlayerLearn(stack);
            EnergyValue value = EnergyValueRegistryProxy.getEnergyValue((Object)stack);
            if (value == null && (item = block == Blocks.field_150488_af ? Items.field_151137_ax : (block instanceof BlockBush ? block.func_149694_d(accessor.getWorld(), pos.field_72311_b, pos.field_72312_c, pos.field_72309_d) : (block == Blocks.field_150466_ao ? Items.field_151135_aq : (block == Blocks.field_150454_av ? Items.field_151139_aw : Item.func_150898_a((Block)block))))) != null) {
                stack = new ItemStack(item);
                value = EnergyValueRegistryProxy.getEnergyValue((Object)stack);
                isKnown = WIIEMC.proxy.doesPlayerKnow(stack);
                canBeLearned = WIIEMC.proxy.canPlayerLearn(stack);
            }
            if (value != null && value.getValue() > 0.0f) {
                if (ModConfig.showEMC) {
                    String tip = StatCollector.func_74838_a((String)"tooltip.wiiemc.energy.value");
                    String energy = energyValueDecimalFormat.format(value.getValue());
                    tooltip.add(String.format(tip, energy));
                }
            } else if (ModConfig.showNoEMC) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wiiemc.energy.none"));
            }
            if (canBeLearned) {
                if (ModConfig.showCanLearn) {
                    tooltip.add(StatCollector.func_74838_a((String)"tooltip.wiiemc.knowledge.isunknown"));
                }
            } else if (isKnown && ModConfig.showIsLearned) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wiiemc.knowledge.isknown"));
            } else if (ModConfig.showCantLearn) {
                tooltip.add(StatCollector.func_74838_a((String)"tooltip.wiiemc.knowledge.cantlearn"));
            }
        }
        return tooltip;
    }

    public List<String> getWailaTail(ItemStack itemStack, List<String> tooltip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        return tooltip;
    }

    public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity te, NBTTagCompound tag, World world, int x, int y, int z) {
        return tag;
    }

    public static void callbackRegister(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new BlockEMCDataProvider(), Block.class);
    }
}

