/*
 * Decompiled with CFR 0.152.
 */
package net.lomeli.wiiemc.core.network;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Set;
import net.lomeli.wiiemc.WIIEMC;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MessageKnowledge
implements IMessage,
IMessageHandler<MessageKnowledge, IMessage> {
    private List<ItemStack> knownTransmutations = Lists.newArrayList();

    public MessageKnowledge() {
    }

    public MessageKnowledge(Set<ItemStack> knowledge) {
        this();
        this.knownTransmutations.addAll(knowledge);
    }

    public void fromBytes(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        if (tag != null && tag.func_150297_b("KnownItems", 9)) {
            NBTTagList tagList = tag.func_150295_c("KnownItems", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = tagList.func_150305_b(i);
                this.knownTransmutations.add(ItemStack.func_77949_a((NBTTagCompound)itemTag));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        for (ItemStack stack : this.knownTransmutations) {
            if (stack == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            stack.func_77955_b(itemTag);
            tagList.func_74742_a((NBTBase)itemTag);
        }
        tag.func_74782_a("KnownItems", (NBTBase)tagList);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public IMessage onMessage(MessageKnowledge message, MessageContext ctx) {
        if (message.knownTransmutations != null) {
            WIIEMC.proxy.setKnowledge(message.knownTransmutations);
        }
        return null;
    }
}

