/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.replacement;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.FMLControlledNamespacedRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.util.replacement.ReplacementHandler;
import net.malisis.core.util.replacement.ShapedOreRecipeHandler;
import net.malisis.core.util.replacement.ShapedRecipesHandler;
import net.malisis.core.util.replacement.ShapelessOreRecipeHandler;
import net.malisis.core.util.replacement.ShapelessRecipesHandler;
import net.malisis.core.util.replacement.StatCraftingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.stats.StatList;
import net.minecraft.util.RegistryNamespaced;
import net.minecraftforge.client.event.TextureStitchEvent;

public class ReplacementTool {
    private static ReplacementTool instance = new ReplacementTool();
    private HashMap<Block, Block> originalBlocks = new HashMap();
    private HashMap<Item, Item> originalItems = new HashMap();
    private Class[] types = new Class[]{Integer.TYPE, String.class, Object.class};
    private Method method = ReflectionHelper.findMethod(FMLControlledNamespacedRegistry.class, (Object)null, (String[])new String[]{"addObjectRaw"}, (Class[])this.types);

    private ReplacementTool() {
        new ShapedOreRecipeHandler();
        new ShapedRecipesHandler();
        new ShapelessRecipesHandler();
        new ShapelessOreRecipeHandler();
        new StatCraftingHandler();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
        if (event.map.func_130086_a() == 1) {
            return;
        }
        for (Map.Entry<Block, Block> entry : this.originalBlocks.entrySet()) {
            Block block = entry.getValue();
            block.func_149651_a((IIconRegister)event.map);
        }
    }

    public static ReplacementTool instance() {
        return instance;
    }

    private void replaceVanilla(int id, String name, String srgFieldName, Object replacement, Object vanilla) {
        boolean block = replacement instanceof Block;
        RegistryNamespaced registry = block ? Block.field_149771_c : Item.field_150901_e;
        ItemBlock ib = block ? (ItemBlock)Item.func_150898_a((Block)((Block)vanilla)) : null;
        Class clazz = block ? Blocks.class : Items.class;
        HashMap<Block, Block> map = block ? this.originalBlocks : this.originalItems;
        try {
            this.method.invoke((Object)registry, id, "minecraft:" + name, replacement);
            Field f = AsmUtils.changeAccess(clazz, name, srgFieldName);
            f.set(null, replacement);
            if (ib != null) {
                AsmUtils.changeAccess(ItemBlock.class, "blockInstance", "field_150939_a").set(ib, replacement);
            }
            map.put((Block)replacement, (Block)vanilla);
            this.replaceIn(CraftingManager.func_77594_a().func_77592_b(), vanilla, replacement);
            this.replaceIn(StatList.field_75940_b, vanilla, replacement);
        }
        catch (ReflectiveOperationException e) {
            e.printStackTrace();
        }
    }

    public void replaceIn(List<?> list, Object vanilla, Object replacement) throws ReflectiveOperationException {
        for (Object object : list) {
            ReplacementHandler rh = ReplacementHandler.getHandler(object);
            if (rh == null || !rh.replace(object, vanilla, replacement)) continue;
            MalisisCore.log.info("Replaced {} by {} in {}", new Object[]{vanilla.getClass().getSimpleName(), replacement.getClass().getSimpleName(), object.getClass().getSimpleName()});
        }
    }

    public static void replaceVanillaBlock(int id, String name, String srgFieldName, Block replacement, Block vanilla) {
        ReplacementTool.instance().replaceVanilla(id, name, srgFieldName, replacement, vanilla);
    }

    public static void replaceVanillaItem(int id, String name, String srgFieldName, Item replacement, Item vanilla) {
        ReplacementTool.instance().replaceVanilla(id, name, srgFieldName, replacement, vanilla);
    }

    public static Block orignalBlock(Block block) {
        return ReplacementTool.instance.originalBlocks.get(block);
    }

    public static Item originalItem(Item item) {
        return ReplacementTool.instance.originalItems.get(item);
    }
}

