/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import java.util.LinkedList;
import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.IScrollable;
import net.malisis.core.client.gui.component.control.UIScrollBar;
import net.malisis.core.client.gui.component.control.UISlimScrollbar;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.component.ContentUpdateEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.util.MouseButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.IIcon;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class UITextField
extends UIComponent<UITextField>
implements IScrollable {
    protected StringBuilder text = new StringBuilder();
    protected List<String> lines = new LinkedList<String>();
    protected boolean multiLine = false;
    protected int charOffset = 0;
    protected int lineOffset = 0;
    protected int lineSpacing = 1;
    protected float fontScale = 1.0f;
    protected boolean selectingText = false;
    protected CursorPosition cursorPosition;
    protected CursorPosition selectionPosition;
    protected long startTimer;
    private boolean selectAllOnRelease = false;
    protected boolean autoSelectOnFocus = false;
    protected boolean editable = true;
    protected UISlimScrollbar scrollBar;
    protected int textColor = 0xFFFFFF;
    protected int bgColor = 0xFFFFFF;
    protected int cursorColor = 0xD0D0D0;
    protected int selectColor = 255;
    protected boolean textShadow = true;
    protected GuiShape cursorShape;
    protected GuiShape selectShape;
    protected GuiIcon iconTextfield;
    protected GuiIcon iconTextfieldDisabled;

    public UITextField(MalisisGui gui, String text, boolean multiLine) {
        super(gui);
        this.multiLine = multiLine;
        this.cursorPosition = new CursorPosition();
        this.selectionPosition = new CursorPosition();
        if (text != null) {
            this.setText(text);
        }
        this.createShape(gui);
        if (multiLine) {
            this.scrollBar = new UISlimScrollbar(gui, this, UIScrollBar.Type.VERTICAL);
        }
    }

    public UITextField(MalisisGui gui, String text) {
        this(gui, text, false);
    }

    public UITextField(MalisisGui gui, boolean multiLine) {
        this(gui, null, multiLine);
    }

    protected void createShape(MalisisGui gui) {
        this.shape = new XYResizableGuiShape(1);
        this.cursorShape = new SimpleGuiShape();
        this.selectShape = new SimpleGuiShape();
        this.iconTextfield = gui.getGuiTexture().getXYResizableIcon(200, 30, 9, 12, 1);
        this.iconTextfieldDisabled = gui.getGuiTexture().getXYResizableIcon(200, 42, 9, 12, 1);
    }

    public String getText() {
        return this.text.toString();
    }

    public void setText(String text) {
        if (!this.validateText(text)) {
            return;
        }
        this.text.setLength(0);
        this.text.append(text);
        this.buildLines();
        this.selectingText = false;
        this.charOffset = 0;
        this.lineOffset = 0;
        if (this.focused) {
            this.cursorPosition.jumpToEnd();
        }
    }

    public String getSelectedText() {
        if (!this.selectingText) {
            return "";
        }
        int start = Math.min(this.selectionPosition.textPosition, this.cursorPosition.textPosition);
        int end = Math.max(this.selectionPosition.textPosition, this.cursorPosition.textPosition);
        return this.text.substring(start, end);
    }

    public int getTextColor() {
        return this.textColor;
    }

    public UITextField setTextColor(int color) {
        this.textColor = color;
        return this;
    }

    public int getCursorColor() {
        return this.cursorColor;
    }

    public UITextField setCursorColor(int cursorColor) {
        this.cursorColor = cursorColor;
        return this;
    }

    public int getSelectColor() {
        return this.selectColor;
    }

    public UITextField setSelectColor(int selectColor) {
        this.selectColor = selectColor;
        return this;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public UITextField setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public UITextField setOptions(int textColor, int bgColor, int cursorColor, int selectColor, boolean textShadow) {
        this.textColor = textColor;
        this.bgColor = bgColor;
        this.cursorColor = cursorColor;
        this.selectColor = selectColor;
        this.textShadow = textShadow;
        return this;
    }

    @Override
    public UITextField setSize(int width, int height) {
        return (UITextField)super.setSize(width, this.multiLine ? height : 12);
    }

    @Override
    public void setFocused(boolean focused) {
        if (this.isDisabled() || !this.isVisible()) {
            return;
        }
        if (!this.focused) {
            this.selectAllOnRelease = true;
        }
        super.setFocused(focused);
    }

    public UITextField setFontScale(float fontScale) {
        this.fontScale = fontScale;
        this.buildLines();
        return this;
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public int getLineSpacing() {
        return this.lineSpacing;
    }

    public UITextField setLineSpacing(int lineSpacing) {
        this.lineSpacing = lineSpacing;
        return this;
    }

    public void setLineOffset(int line) {
        this.lineOffset = line;
    }

    public CursorPosition getCursorPosition() {
        return this.cursorPosition;
    }

    public CursorPosition getSelectionPosition() {
        return this.selectionPosition;
    }

    public void setCursorPosition(int x, int y) {
        this.cursorPosition.setPosition(x, y);
        this.startTimer = System.currentTimeMillis();
    }

    public UITextField setAutoSelectOnFocus(boolean auto) {
        this.autoSelectOnFocus = auto;
        return this;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public UITextField setEditable(boolean editable) {
        this.editable = editable;
        return this;
    }

    public UISlimScrollbar getScrollbar() {
        return this.scrollBar;
    }

    @Override
    public int getContentWidth() {
        return this.getWidth();
    }

    @Override
    public int getContentHeight() {
        return this.multiLine ? this.lines.size() * this.getLineHeight() + 4 : 12;
    }

    @Override
    public float getOffsetX() {
        return 0.0f;
    }

    @Override
    public void setOffsetX(float offsetX, int delta) {
    }

    @Override
    public float getOffsetY() {
        return (float)this.lineOffset / (float)(this.lines.size() - this.getVisibleLines());
    }

    @Override
    public void setOffsetY(float offsetY, int delta) {
        this.lineOffset = Math.round(offsetY / this.getScrollStep());
        this.lineOffset = Math.max(0, Math.min(this.lines.size(), this.lineOffset));
    }

    @Override
    public float getScrollStep() {
        float step = 1.0f / (float)(this.lines.size() - this.getVisibleLines());
        return GuiScreen.func_146271_m() ? 5.0f * step : step;
    }

    @Override
    public int getVerticalPadding() {
        return 1;
    }

    @Override
    public int getHorizontalPadding() {
        return 1;
    }

    public int getVisibleLines() {
        return this.multiLine ? (this.getHeight() - 4) / this.getLineHeight() : 1;
    }

    public int getLineHeight() {
        return (int)Math.ceil((float)(GuiRenderer.FONT_HEIGHT + this.lineSpacing) * this.fontScale);
    }

    protected void buildLines() {
        this.lines.clear();
        if (!StringUtils.isEmpty((CharSequence)this.text)) {
            if (!this.multiLine) {
                this.lines.add(this.text.toString());
            } else {
                this.lines = GuiRenderer.wrapText(this.text.toString(), this.getWidth() - 4, this.fontScale);
                if (this.text.charAt(this.text.length() - 1) == '\n') {
                    this.lines.add("");
                }
            }
        }
        this.fireEvent(new ContentUpdateEvent<UITextField>(this));
    }

    protected boolean validateText(String text) {
        return true;
    }

    public void addText(String str) {
        if (this.selectingText) {
            this.deleteSelectedText();
        }
        int position = this.cursorPosition.textPosition;
        String oldValue = this.text.toString();
        String newValue = new StringBuilder(oldValue).insert(position, str).toString();
        if (!this.validateText(newValue)) {
            return;
        }
        if (!this.fireEvent(new ComponentEvent.ValueChange<UITextField, String>(this, oldValue, newValue))) {
            return;
        }
        this.text.insert(position, str);
        this.buildLines();
        this.cursorPosition.jumpBy(str.length());
    }

    public void deleteSelectedText() {
        String newValue;
        if (!this.selectingText) {
            return;
        }
        int start = Math.min(this.selectionPosition.textPosition, this.cursorPosition.textPosition);
        int end = Math.max(this.selectionPosition.textPosition, this.cursorPosition.textPosition);
        String oldValue = this.text.toString();
        if (!this.fireEvent(new ComponentEvent.ValueChange<UITextField, String>(this, oldValue, newValue = new StringBuilder(oldValue).delete(start, end).toString()))) {
            return;
        }
        this.text.delete(start, end);
        this.buildLines();
        this.selectingText = false;
        this.cursorPosition.jumpTo(start);
    }

    public void deleteFromCursor(int amount) {
        if (!this.selectingText) {
            this.selectingText = true;
            this.selectionPosition.set(this.cursorPosition);
            this.selectionPosition.jumpBy(amount);
        }
        this.deleteSelectedText();
    }

    public void deleteWord(boolean backwards) {
        if (!this.selectingText) {
            this.selectingText = true;
            this.selectionPosition.set(this.cursorPosition);
            this.cursorPosition.jumpToNextSpace(backwards);
        }
        this.deleteSelectedText();
    }

    public void selectWord() {
        this.selectWord(this.cursorPosition.textPosition);
    }

    public void selectWord(int position) {
        if (this.text.length() == 0) {
            return;
        }
        this.selectingText = true;
        this.selectionPosition.jumpTo(position);
        this.selectionPosition.jumpToNextSpace(true);
        if (Character.isWhitespace(this.text.charAt(this.selectionPosition.textPosition))) {
            this.selectionPosition.shiftRight();
        }
        this.cursorPosition.jumpTo(position);
        this.cursorPosition.jumpToNextSpace(false);
    }

    protected void onCursorUpdated() {
        if (!this.multiLine) {
            if (this.cursorPosition.character < this.charOffset) {
                this.charOffset = this.cursorPosition.character;
            } else if (this.text.length() != 0) {
                while (GuiRenderer.getStringWidth(this.text.substring(this.charOffset, this.cursorPosition.textPosition), this.fontScale) >= this.getWidth() - 4) {
                    ++this.charOffset;
                }
            }
        } else if (this.cursorPosition.line < this.lineOffset) {
            this.setLineOffset(this.cursorPosition.line);
        } else if (this.cursorPosition.line > this.lineOffset + this.getVisibleLines() - 1) {
            this.setLineOffset(this.cursorPosition.line - this.getVisibleLines() + 1);
        }
        this.startTimer = System.currentTimeMillis();
    }

    protected void startSelecting() {
        if (GuiScreen.func_146272_n()) {
            if (!this.selectingText) {
                this.selectionPosition.set(this.cursorPosition);
            }
            this.selectingText = true;
        } else {
            this.selectingText = false;
        }
    }

    @Override
    public boolean onButtonPress(int x, int y, MouseButton button) {
        if (button != MouseButton.LEFT) {
            return super.onButtonRelease(x, y, button);
        }
        x = this.relativeX(x);
        y = this.relativeY(y);
        if (GuiScreen.func_146272_n()) {
            if (!this.selectingText) {
                this.selectingText = true;
                this.selectionPosition.set(this.cursorPosition);
            }
        } else {
            this.selectingText = false;
        }
        this.cursorPosition.setPosition(x, y);
        return true;
    }

    @Override
    public boolean onButtonRelease(int x, int y, MouseButton button) {
        if (!this.autoSelectOnFocus || !this.selectAllOnRelease || button != MouseButton.LEFT) {
            return super.onButtonRelease(x, y, button);
        }
        this.selectingText = true;
        this.selectionPosition.jumpTo(0);
        this.cursorPosition.jumpTo(this.text.length());
        this.selectAllOnRelease = false;
        return true;
    }

    @Override
    public boolean onDrag(int lastX, int lastY, int x, int y, MouseButton button) {
        if (!this.isFocused() || button != MouseButton.LEFT) {
            return super.onDrag(lastX, lastY, x, y, button);
        }
        if (!this.selectingText) {
            this.selectingText = true;
            this.selectionPosition.set(this.cursorPosition);
        }
        x = this.relativeX(x);
        y = this.relativeY(y);
        this.cursorPosition.setPosition(x, y);
        this.selectAllOnRelease = false;
        return true;
    }

    @Override
    public boolean onDoubleClick(int x, int y, MouseButton button) {
        this.selectWord();
        return true;
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (!this.isFocused()) {
            return false;
        }
        if (keyCode == 1) {
            this.setFocused(false);
            return true;
        }
        if (this.handleCtrlKeyDown(keyCode)) {
            return true;
        }
        switch (keyCode) {
            case 203: {
                this.startSelecting();
                this.cursorPosition.shiftLeft();
                break;
            }
            case 205: {
                this.startSelecting();
                this.cursorPosition.shiftRight();
                break;
            }
            case 200: {
                if (!this.multiLine) break;
                this.startSelecting();
                this.cursorPosition.jumpLine(true);
                break;
            }
            case 208: {
                if (!this.multiLine) break;
                this.startSelecting();
                this.cursorPosition.jumpLine(false);
                break;
            }
            case 199: {
                this.startSelecting();
                this.cursorPosition.jumpToLineStart();
                break;
            }
            case 207: {
                this.startSelecting();
                this.cursorPosition.jumpToLineEnd();
                break;
            }
            case 14: {
                if (!this.isEditable()) break;
                this.deleteFromCursor(-1);
                break;
            }
            case 211: {
                if (!this.isEditable()) break;
                this.deleteFromCursor(1);
                break;
            }
            case 28: {
                if (!this.multiLine || !this.isEditable()) break;
                this.addText("\n");
                break;
            }
            case 15: {
                if (!this.isEditable()) break;
                this.addText("\t");
                break;
            }
            default: {
                if (ChatAllowedCharacters.func_71566_a((char)keyChar) && this.isEditable()) {
                    this.addText(Character.toString(keyChar));
                    break;
                }
                return super.onKeyTyped(keyChar, keyCode);
            }
        }
        return true;
    }

    protected boolean handleCtrlKeyDown(int keyCode) {
        if (!GuiScreen.func_146271_m()) {
            return false;
        }
        switch (keyCode) {
            case 203: {
                this.startSelecting();
                this.cursorPosition.jumpToNextSpace(true);
                return true;
            }
            case 205: {
                this.startSelecting();
                this.cursorPosition.jumpToNextSpace(false);
                return true;
            }
            case 14: {
                if (this.isEditable()) {
                    this.deleteWord(true);
                }
                return true;
            }
            case 211: {
                if (this.isEditable()) {
                    this.deleteWord(false);
                }
                return true;
            }
            case 199: {
                this.startSelecting();
                this.cursorPosition.jumpToBeginning();
                return true;
            }
            case 207: {
                this.startSelecting();
                this.cursorPosition.jumpToEnd();
                return true;
            }
            case 30: {
                this.selectingText = true;
                this.selectionPosition.jumpToBeginning();
                this.cursorPosition.jumpToEnd();
                return true;
            }
            case 46: {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                return true;
            }
            case 47: {
                if (this.isEditable()) {
                    this.addText(GuiScreen.func_146277_j());
                }
                return true;
            }
            case 45: {
                GuiScreen.func_146275_d((String)this.getSelectedText());
                if (this.isEditable()) {
                    this.addText("");
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.rp.useTexture.reset();
        this.rp.colorMultiplier.reset();
        this.rp.icon.set((IIcon)(this.isDisabled() ? this.iconTextfieldDisabled : this.iconTextfield));
        this.rp.colorMultiplier.set(this.bgColor);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.text.length() != 0) {
            this.drawText(renderer);
        }
        if (this.selectingText && this.selectionPosition.textPosition != this.cursorPosition.textPosition) {
            this.drawSelectionBox(renderer);
        }
        if (this.focused) {
            this.drawCursor(renderer);
        }
    }

    public void drawText(GuiRenderer renderer) {
        renderer.setFontScale(this.fontScale);
        if (!this.multiLine) {
            int end = this.text.length();
            int w = GuiRenderer.getStringWidth(this.text.substring(this.charOffset, end), this.fontScale);
            while (w > this.getWidth()) {
                w = GuiRenderer.getStringWidth(this.text.substring(this.charOffset, end--), this.fontScale);
            }
            renderer.drawText(this.text.substring(this.charOffset, end), 2, 2, this.isDisabled() ? 0xAAAAAA : this.textColor, this.textShadow);
        } else {
            for (int i = this.lineOffset; i < this.lineOffset + this.getVisibleLines() && i < this.lines.size(); ++i) {
                int h = (i - this.lineOffset) * this.getLineHeight();
                renderer.drawText(this.lines.get(i), 2, h + 2, this.isDisabled() ? 0xAAAAAA : this.textColor, this.textShadow);
            }
        }
        renderer.setFontScale(1.0f);
    }

    public void drawCursor(GuiRenderer renderer) {
        long elaspedTime = this.startTimer - System.currentTimeMillis();
        if (elaspedTime / 500L % 2L != 0L) {
            return;
        }
        if (this.cursorPosition.line < this.lineOffset || this.cursorPosition.line >= this.lineOffset + this.getVisibleLines()) {
            return;
        }
        renderer.drawRectangle(this.cursorPosition.getXOffset() + 1, this.cursorPosition.getYOffset() + 1, this.getZIndex(), 1, this.getLineHeight(), this.cursorColor, 255, true);
    }

    public void drawSelectionBox(GuiRenderer renderer) {
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3058);
        GL11.glLogicOp((int)5387);
        CursorPosition first = this.cursorPosition.textPosition < this.selectionPosition.textPosition ? this.cursorPosition : this.selectionPosition;
        CursorPosition last = this.cursorPosition == first ? this.selectionPosition : this.cursorPosition;
        for (int i = first.line; i <= last.line; ++i) {
            if (i < this.lineOffset || i >= this.lineOffset + this.getVisibleLines() || i >= this.lines.size()) continue;
            int x = 0;
            int y = (i - this.lineOffset) * this.getLineHeight();
            int X = GuiRenderer.getStringWidth(this.lines.get(i), this.fontScale);
            if (i == first.line) {
                x = first.getXOffset();
            }
            if (i == last.line) {
                X = last.getXOffset();
            }
            this.selectShape.resetState();
            this.selectShape.setSize(Math.min(this.getWidth() - 2, X) - x, this.getLineHeight());
            this.selectShape.setPosition(x + 2, y + 1);
            this.rp.useTexture.set(false);
            this.rp.colorMultiplier.set(this.selectColor);
            renderer.drawShape(this.selectShape, this.rp);
        }
        renderer.next();
        GL11.glDisable((int)3058);
        GL11.glEnable((int)3553);
    }

    @Override
    public String getPropertyString() {
        return this.text + " | " + super.getPropertyString();
    }

    public class CursorPosition {
        protected int textPosition;
        protected int character;
        protected int line;

        public void set(CursorPosition position) {
            this.textPosition = position.textPosition;
            this.character = position.character;
            this.line = position.line;
        }

        public int getPosition() {
            return this.textPosition;
        }

        public void jumpTo(int pos) {
            if (UITextField.this.text.length() == 0) {
                this.textPosition = 0;
                this.line = 0;
                this.character = 0;
                return;
            }
            if (pos < 0) {
                pos = 0;
            }
            if (pos >= UITextField.this.text.length()) {
                this.textPosition = UITextField.this.text.length();
                this.line = UITextField.this.lines.size() - 1;
                this.character = this.currentLineText().length();
                UITextField.this.onCursorUpdated();
                return;
            }
            this.textPosition = pos;
            this.line = 0;
            if (!UITextField.this.multiLine) {
                this.character = pos;
                UITextField.this.onCursorUpdated();
                return;
            }
            while (this.line < UITextField.this.lines.size() && pos >= this.currentLineText().length()) {
                pos -= this.currentLineText().length();
                ++this.line;
            }
            this.character = pos;
            UITextField.this.onCursorUpdated();
        }

        public void jumpBy(int amount) {
            this.jumpTo(this.textPosition + amount);
        }

        public void jumpToBeginning() {
            this.jumpTo(0);
        }

        public void jumpToEnd() {
            this.jumpTo(UITextField.this.text.length());
        }

        public void jumpToLineStart() {
            this.jumpBy(-this.character);
        }

        public void jumpToLineEnd() {
            this.textPosition -= this.character;
            this.character = this.currentLineText().length() - (this.currentLineText().endsWith("\n") ? 1 : 0);
            this.textPosition += this.character;
            UITextField.this.onCursorUpdated();
        }

        public void shiftLeft() {
            if (this.textPosition == 0) {
                return;
            }
            if (this.character == 0 && this.line > 0) {
                --this.line;
                this.character = this.currentLineText().length();
                if (this.currentLineText().endsWith("\n")) {
                    --this.character;
                    --this.textPosition;
                }
            } else {
                this.jumpBy(-1);
            }
            UITextField.this.onCursorUpdated();
        }

        public void shiftRight() {
            if (this.textPosition == UITextField.this.text.length()) {
                return;
            }
            if (this.currentLineText().endsWith("\n")) {
                this.jumpBy(1);
            } else if (this.character++ >= this.currentLineText().length() && this.line < UITextField.this.lines.size() - 1) {
                ++this.line;
                this.character = 0;
            } else {
                ++this.textPosition;
            }
            UITextField.this.onCursorUpdated();
        }

        public void jumpToNextSpace(boolean backwards) {
            int pos = this.textPosition;
            int step = backwards ? -1 : 1;
            pos += step;
            while (pos > 0 && pos < UITextField.this.text.length() && Character.isLetterOrDigit(UITextField.this.text.charAt(pos))) {
                pos += step;
            }
            this.jumpTo(pos);
        }

        public void jumpLine(boolean backwards) {
            this.line = backwards ? Math.max(0, this.line - 1) : Math.min(this.line + 1, UITextField.this.lines.size() - 1);
            this.character = Math.min(this.character, this.currentLineText().length());
            this.updateTextPosition();
        }

        private String currentLineText() {
            if (this.line < 0 || this.line >= UITextField.this.lines.size()) {
                return "";
            }
            return UITextField.this.lines.get(this.line);
        }

        public void setPosition(int x, int y) {
            this.line = this.lineFromY(y);
            this.character = this.characterFromX(x);
            this.updateTextPosition();
        }

        private void updateTextPosition() {
            this.textPosition = this.character;
            if (!UITextField.this.multiLine) {
                return;
            }
            for (int i = 0; i < this.line && i < UITextField.this.lines.size(); ++i) {
                this.textPosition += UITextField.this.lines.get(i).length();
            }
            UITextField.this.onCursorUpdated();
        }

        private int lineFromY(int y) {
            return UITextField.this.multiLine ? Math.max(0, Math.min(y / UITextField.this.getLineHeight() + UITextField.this.lineOffset, UITextField.this.lines.size() - 1)) : 0;
        }

        private int characterFromX(int x) {
            if (StringUtils.isEmpty((CharSequence)this.currentLineText())) {
                return 0;
            }
            int pos = 0;
            int width = 0;
            for (int i = UITextField.this.charOffset; i < this.currentLineText().length(); ++i) {
                float w = GuiRenderer.getCharWidth(this.currentLineText().charAt(i), UITextField.this.fontScale);
                if ((float)width + w / 2.0f > (float)x) {
                    return pos + UITextField.this.charOffset;
                }
                width = (int)((float)width + w);
                ++pos;
            }
            return pos + UITextField.this.charOffset;
        }

        public int getXOffset() {
            if (this.textPosition == UITextField.this.text.length() && UITextField.this.multiLine) {
                return GuiRenderer.getStringWidth(this.currentLineText(), UITextField.this.fontScale);
            }
            if (this.currentLineText().length() == 0) {
                return 0;
            }
            if (UITextField.this.charOffset >= this.character || UITextField.this.charOffset >= this.currentLineText().length()) {
                return 0;
            }
            return GuiRenderer.getStringWidth(this.currentLineText().substring(UITextField.this.charOffset, this.character), UITextField.this.fontScale);
        }

        public int getYOffset() {
            return (this.line - UITextField.this.lineOffset) * UITextField.this.getLineHeight();
        }
    }
}

