/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import net.malisis.core.client.gui.ComponentPosition;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UITabGroup;
import net.malisis.core.client.gui.component.decoration.UIImage;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.minecraft.util.IIcon;

public class UITab
extends UIComponent<UITab> {
    protected String label;
    protected UIImage image;
    protected boolean autoWidth = false;
    protected boolean autoHeight = false;
    protected UIContainer container;
    protected boolean active = false;
    protected int textColor = 0x404040;
    protected int activeTextColor = 0xFFFFFF;
    protected int hoverTextColor = 0xFFFFA0;
    protected boolean textShadow = false;
    protected boolean activeTextShadow = true;
    protected int bgColor = 0xFFFFFF;

    public UITab(MalisisGui gui, String label) {
        super(gui);
        this.setSize(0, 0);
        this.setLabel(label);
        this.shape = new XYResizableGuiShape();
    }

    public UITab(MalisisGui gui, UIImage image) {
        super(gui);
        this.setSize(0, 0);
        this.setImage(image);
        this.shape = new XYResizableGuiShape();
    }

    public UITab setLabel(String label) {
        this.image = null;
        this.label = label;
        if (this.autoWidth) {
            this.width = this.calcAutoWidth();
        }
        if (this.autoHeight) {
            this.height = this.calcAutoHeight();
        }
        return this;
    }

    public UITab setImage(UIImage image) {
        this.label = null;
        this.image = image;
        if (this.autoWidth) {
            this.width = this.calcAutoWidth();
        }
        if (this.autoHeight) {
            this.height = this.calcAutoHeight();
        }
        return this;
    }

    @Override
    public void setParent(UIComponent parent) {
        if (!(parent instanceof UITabGroup)) {
            throw new IllegalArgumentException("UITabs can only be added to UITabGroup");
        }
        super.setParent(parent);
    }

    @Override
    public UITab setSize(int width, int height) {
        this.autoWidth = width == 0;
        this.width = this.autoWidth ? this.calcAutoWidth() : width;
        this.autoHeight = height == 0;
        int n = this.height = this.autoHeight ? this.calcAutoHeight() : height;
        if (this.shape != null) {
            this.shape.setSize(this.width, this.height);
        }
        return this;
    }

    public boolean isAutoWidth() {
        return this.autoWidth;
    }

    public boolean isAutoHeight() {
        return this.autoHeight;
    }

    public UITab setContainer(UIContainer container) {
        this.container = container;
        return this;
    }

    public ComponentPosition getTabPosition() {
        return ((UITabGroup)this.parent).getTabPosition();
    }

    public int getTextColor() {
        return this.textColor;
    }

    public UITab setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public int getActiveTextColor() {
        return this.activeTextColor;
    }

    public UITab setActiveTextColor(int activeTextColor) {
        this.activeTextColor = activeTextColor;
        return this;
    }

    public int getHoverTextColor() {
        return this.hoverTextColor;
    }

    public UITab setHoveredTextColor(int hovertextColor) {
        this.hoverTextColor = hovertextColor;
        return this;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public UITab setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public boolean isActiveTextShadow() {
        return this.activeTextShadow;
    }

    public UITab setActiveTextShadow(boolean activeTextShadow) {
        this.activeTextShadow = activeTextShadow;
        return this;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public UITab setBgColor(int color) {
        UIContainer cont;
        this.bgColor = color;
        if (this.parent != null && (cont = ((UITabGroup)this.parent).getAttachedContainer()) instanceof ITransformable.Color) {
            ((ITransformable.Color)((Object)cont)).setColor(color);
        }
        return this;
    }

    public UITab setOptions(int textColor, int activeTextColor, int hoverTextColor, int bgColor, boolean textShadow, boolean activeTextShadow) {
        this.textColor = textColor;
        this.activeTextColor = activeTextColor;
        this.hoverTextColor = hoverTextColor;
        this.textShadow = textShadow;
        this.activeTextShadow = activeTextShadow;
        this.setBgColor(bgColor);
        return this;
    }

    public boolean isActive() {
        return this.active;
    }

    public UITab setActive(boolean active) {
        if (this.container == null) {
            this.active = active;
            return this;
        }
        if (this.active != active) {
            switch (this.getTabPosition()) {
                case TOP: 
                case BOTTOM: {
                    this.y += active ? -1 : 1;
                    this.height += active ? 2 : -2;
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    this.x += active ? -1 : 1;
                    this.width += active ? 2 : -2;
                }
            }
        }
        this.active = active;
        this.container.setVisible(active);
        this.container.setDisabled(!active);
        this.zIndex = this.container.getZIndex() + (active ? 1 : 0);
        this.fireEvent(new StateChangeEvent.ActiveStateChange<UITab>(this, active));
        return this;
    }

    private IIcon getIcon() {
        if (this.parent == null) {
            return null;
        }
        return ((UITabGroup)this.parent).getIcons();
    }

    protected boolean isHorizontal() {
        if (this.parent == null) {
            return true;
        }
        ComponentPosition pos = ((UITabGroup)this.parent).getTabPosition();
        return pos == ComponentPosition.TOP || pos == ComponentPosition.BOTTOM;
    }

    private int calcAutoWidth() {
        if (this.label != null) {
            return GuiRenderer.getStringWidth(this.label) + (this.isHorizontal() ? 10 : 8);
        }
        if (this.image != null) {
            return this.image.getWidth() + 10;
        }
        return 8;
    }

    private int calcAutoHeight() {
        if (this.label != null) {
            return GuiRenderer.FONT_HEIGHT + (this.isHorizontal() ? 8 : 10);
        }
        if (this.image != null) {
            return this.image.getHeight() + 10;
        }
        return 8;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.rp.colorMultiplier.set(this.bgColor);
        this.rp.icon.set(this.getIcon());
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int w = this.label != null ? GuiRenderer.getStringWidth(this.label) : this.image.getWidth();
        int h = this.label != null ? GuiRenderer.FONT_HEIGHT : this.image.getHeight();
        int x = (this.getWidth() - w) / 2;
        int y = (this.getHeight() - h) / 2 + 1;
        if (this.active) {
            switch (this.getTabPosition()) {
                case TOP: {
                    --y;
                    break;
                }
                case BOTTOM: {
                    ++y;
                    break;
                }
                case LEFT: {
                    --x;
                    break;
                }
                case RIGHT: {
                    ++x;
                }
            }
        }
        if (this.label != null) {
            int color = this.isHovered() ? this.hoverTextColor : (this.active ? this.activeTextColor : this.textColor);
            boolean shadow = this.active ? this.activeTextShadow : this.textShadow;
            renderer.drawText(this.label, x, y, 1, color, shadow, true);
        } else if (this.image != null) {
            this.image.setPosition(this.screenX() + x, this.screenY() + y);
            this.image.setZIndex(this.zIndex);
            this.image.draw(renderer, mouseX, mouseY, partialTick);
        }
    }

    @Override
    public boolean onClick(int x, int y) {
        if (!(this.parent instanceof UITabGroup)) {
            return super.onClick(x, y);
        }
        if (!this.fireEvent(new UITabGroup.TabChangeEvent((UITabGroup)this.parent, this))) {
            return super.onClick(x, y);
        }
        ((UITabGroup)this.parent).setActiveTab(this);
        return true;
    }

    @Override
    public String getPropertyString() {
        return "Label : " + this.label + " | " + super.getPropertyString();
    }
}

