/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.decoration.UIImage;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.util.MouseButton;
import net.minecraft.util.IIcon;

public class UIButton
extends UIComponent<UIButton> {
    protected GuiIcon iconHovered;
    protected GuiIcon iconDisabled;
    protected GuiIcon iconPressed;
    protected String text;
    protected UIImage image;
    protected boolean autoSize = true;
    protected boolean isPressed = false;
    protected int bgColor = 0xFFFFFF;
    protected int textColor = 0xFFFFFF;
    protected int hoverTextColor = 0xFFFFA0;
    protected boolean textShadow = true;
    protected int offsetX;
    protected int offsetY;

    public UIButton(MalisisGui gui) {
        super(gui);
        this.shape = new XYResizableGuiShape();
        this.icon = gui.getGuiTexture().getXYResizableIcon(0, 20, 200, 20, 5);
        this.iconHovered = gui.getGuiTexture().getXYResizableIcon(0, 40, 200, 20, 5);
        this.iconDisabled = gui.getGuiTexture().getXYResizableIcon(0, 0, 200, 20, 5);
        this.iconPressed = (GuiIcon)gui.getGuiTexture().getXYResizableIcon(0, 40, 200, 20, 5).flip(true, true);
    }

    public UIButton(MalisisGui gui, String text) {
        this(gui);
        this.setText(text);
    }

    public UIButton(MalisisGui gui, UIImage image) {
        this(gui);
        this.setImage(image);
    }

    public String getText() {
        return this.text;
    }

    public UIButton setText(String text) {
        this.text = text;
        this.setSize(this.width, this.height);
        this.image = null;
        return this;
    }

    public UIImage getImage() {
        return this.image;
    }

    public UIButton setImage(UIImage image) {
        this.image = image;
        image.setParent(this);
        this.setSize(this.width, this.height);
        this.text = null;
        return this;
    }

    public UIButton setSize(int width) {
        return this.setSize(width, 20);
    }

    @Override
    public UIButton setSize(int width, int height) {
        if (this.autoSize) {
            if (this.image != null) {
                int w = this.image.getRawWidth();
                int h = this.image.getRawHeight();
                width = Math.max(width, w + 2);
                height = Math.max(height, h + 2);
            } else {
                int w = GuiRenderer.getStringWidth(this.text);
                int h = GuiRenderer.getStringHeight();
                width = Math.max(width, w + 6);
                height = Math.max(height, h + 6);
            }
        }
        this.width = width;
        this.height = height;
        return this;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public UIButton setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        this.setSize(this.width, this.height);
        return this;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public UIButton setBgColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public int getTextColor() {
        return this.textColor;
    }

    public UIButton setTextColor(int textColor) {
        this.textColor = textColor;
        return this;
    }

    public int getHoverTextColor() {
        return this.hoverTextColor;
    }

    public UIButton setHoverTextColor(int hoverTextColor) {
        this.hoverTextColor = hoverTextColor;
        return this;
    }

    public boolean isTextShadow() {
        return this.textShadow;
    }

    public UIButton setTextShadow(boolean textShadow) {
        this.textShadow = textShadow;
        return this;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public UIButton setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    public UIButton setOptions(int textColor, int hoverTextColor, int bgColor, boolean textShadow) {
        this.textColor = textColor;
        this.hoverTextColor = hoverTextColor;
        this.bgColor = bgColor;
        this.textShadow = textShadow;
        return this;
    }

    @Override
    public boolean onClick(int x, int y) {
        MalisisGui.playSound("gui.button.press");
        this.fireEvent(new ClickEvent(this, x, y));
        return true;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        GuiIcon icon = this.isDisabled() ? this.iconDisabled : (this.isPressed && this.isHovered() ? this.iconPressed : (this.isHovered() ? this.iconHovered : this.icon));
        this.rp.icon.set((IIcon)icon);
        this.rp.colorMultiplier.set(this.bgColor);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int w = 0;
        int h = 0;
        if (this.image != null) {
            w = this.image.getWidth();
            h = this.image.getHeight();
        } else {
            w = GuiRenderer.getStringWidth(this.text);
            h = GuiRenderer.getStringHeight();
        }
        int x = (this.width - w) / 2;
        int y = (this.height - h) / 2;
        if (x == 0) {
            x = 1;
        }
        if (y == 0) {
            y = 1;
        }
        if (this.isPressed && this.isHovered()) {
            ++x;
            ++y;
        }
        x += this.offsetX;
        y += this.offsetY;
        if (this.image != null) {
            this.image.setPosition(x, y);
            this.image.setZIndex(this.zIndex);
            this.image.draw(renderer, mouseX, mouseY, partialTick);
        } else {
            renderer.drawText(this.text, x, y, this.isHovered() ? this.hoverTextColor : this.textColor, this.textShadow);
        }
    }

    @Override
    public boolean onButtonPress(int x, int y, MouseButton button) {
        if (button == MouseButton.LEFT) {
            this.isPressed = true;
        }
        return super.onButtonPress(x, y, button);
    }

    @Override
    public boolean onButtonRelease(int x, int y, MouseButton button) {
        if (button == MouseButton.LEFT) {
            this.isPressed = false;
        }
        return super.onButtonRelease(x, y, button);
    }

    @Override
    public String getPropertyString() {
        return (this.image != null ? "{" + this.image + "}" : this.text) + " , " + super.getPropertyString();
    }

    public static class ClickEvent
    extends ComponentEvent<UIButton> {
        private int x;
        private int y;

        public ClickEvent(UIButton component, int x, int y) {
            super(component);
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

