/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import java.util.Arrays;
import java.util.List;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.renderer.animation.Animation;
import net.malisis.core.renderer.animation.transformation.AlphaTransform;
import net.malisis.core.renderer.animation.transformation.Transformation;
import net.minecraft.util.IIcon;

public class UITooltip
extends UIComponent {
    protected List<String> lines;
    protected int padding = 4;
    protected int delay = 0;
    protected Animation animation;

    public UITooltip(MalisisGui gui) {
        super(gui);
        this.setSize(16, 16);
        this.zIndex = 300;
        this.shape = new XYResizableGuiShape();
        this.icon = gui.getGuiTexture().getXYResizableIcon(227, 31, 15, 15, 5);
        this.animation = new Animation(this, (Transformation)new AlphaTransform(0, 255).forTicks(2));
    }

    public UITooltip(MalisisGui gui, String text) {
        this(gui);
        this.setText(text);
    }

    public UITooltip(MalisisGui gui, int delay) {
        this(gui);
        this.setDelay(delay);
    }

    public UITooltip(MalisisGui gui, String text, int delay) {
        this(gui);
        this.setText(text);
        this.setDelay(delay);
    }

    public UITooltip setText(String text) {
        this.lines = Arrays.asList(text.split("\\n"));
        this.calcSize();
        return this;
    }

    public UITooltip setText(List<String> lines) {
        this.lines = lines;
        this.calcSize();
        return this;
    }

    public UITooltip setDelay(int delay) {
        this.delay = delay;
        return this;
    }

    public int getDelay() {
        return this.delay;
    }

    protected void calcSize() {
        this.width = Math.max(16, GuiRenderer.getMaxStringWidth(this.lines));
        this.width += this.padding * 2;
        this.height = this.lines.size() > 1 ? (GuiRenderer.FONT_HEIGHT + 1) * this.lines.size() : 8;
        this.height += this.padding * 2;
    }

    protected int getOffsetX() {
        return 8;
    }

    protected int getOffsetY() {
        return -16;
    }

    public void animate() {
        if (this.delay == 0) {
            return;
        }
        this.setAlpha(0);
        this.getGui().animate(this.animation, this.delay);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.setPosition(mouseX + this.getOffsetX(), mouseY + this.getOffsetY());
        this.rp.icon.set((IIcon)this.icon);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int x = mouseX + this.getOffsetX() + this.padding;
        int y = mouseY + this.getOffsetY() + this.padding;
        int i = 0;
        for (String s : this.lines) {
            int sy = y;
            if (i > 0) {
                sy += 2;
            }
            renderer.drawText(s, x, sy + (GuiRenderer.FONT_HEIGHT + 1) * i, this.zIndex + 1, 0xFFFFFF, true, false);
            ++i;
        }
    }
}

