/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.decoration.UITooltip;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.icon.GuiIcon;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.opengl.GL11;

public class GuiRenderer
extends MalisisRenderer {
    public static RenderItem itemRenderer = new RenderItem();
    public static int FONT_HEIGHT = MalisisRenderer.getFontRenderer().field_78288_b;
    public static Map<Character, EnumChatFormatting> charFormats = new HashMap<Character, EnumChatFormatting>();
    public UIComponent currentComponent;
    private int displayWidth;
    private int displayHeight;
    private int scaleFactor;
    private boolean ignoreScale = false;
    private float fontScale = 1.0f;
    public int mouseX;
    public int mouseY;
    private GuiTexture defaultGuiTexture = new GuiTexture(new ResourceLocation("malisiscore", "textures/gui/gui.png"), 300, 100);
    private GuiTexture currentTexture;
    private static GuiShape rectangle = new SimpleGuiShape();

    public GuiRenderer() {
        this.updateGuiScale();
    }

    private void calcScaleFactor(int guiScale) {
        this.scaleFactor = 1;
        if (guiScale == 0) {
            guiScale = 1000;
        }
        while (this.scaleFactor < guiScale && this.displayWidth / (this.scaleFactor + 1) >= 320 && this.displayHeight / (this.scaleFactor + 1) >= 240) {
            ++this.scaleFactor;
        }
    }

    public GuiTexture getDefaultTexture() {
        return this.defaultGuiTexture;
    }

    public void setDefaultTexture(GuiTexture texture) {
        this.defaultGuiTexture = texture;
    }

    public void setIgnoreScale(boolean ignore) {
        this.ignoreScale = ignore;
    }

    public boolean isIgnoreScale() {
        return this.ignoreScale;
    }

    public void setFontScale(float scale) {
        this.fontScale = scale;
    }

    public int updateGuiScale() {
        Minecraft mc = Minecraft.func_71410_x();
        this.displayWidth = mc.field_71443_c;
        this.displayHeight = mc.field_71440_d;
        this.calcScaleFactor(mc.field_71474_y.field_74335_Z);
        return this.scaleFactor;
    }

    public void set(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.partialTick = partialTicks;
    }

    @Override
    public void prepare(RenderType renderType, double ... data) {
        this._initialize();
        this.renderType = renderType;
        this.currentTexture = null;
        this.bindDefaultTexture();
        if (this.ignoreScale) {
            GL11.glPushMatrix();
            GL11.glScalef((float)(1.0f / (float)this.scaleFactor), (float)(1.0f / (float)this.scaleFactor), (float)1.0f);
        }
        this.enableBlending();
        this.startDrawing();
    }

    @Override
    public void clean() {
        this.draw();
        if (this.ignoreScale) {
            GL11.glPopMatrix();
        }
        this.reset();
    }

    @Override
    public void next() {
        super.next();
        this.bindDefaultTexture();
    }

    public void bindTexture(GuiTexture texture) {
        if (texture == null || texture == this.currentTexture) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture.getResourceLocation());
        this.currentTexture = texture;
    }

    public void bindDefaultTexture() {
        this.bindTexture(this.defaultGuiTexture);
    }

    @Override
    public void applyTexture(Shape shape, RenderParameters parameters) {
        if (parameters.icon.get() == null) {
            return;
        }
        Face[] faces = shape.getFaces();
        IIcon icon = parameters.icon.get();
        boolean isGuiIcon = icon instanceof GuiIcon;
        for (int i = 0; i < faces.length; ++i) {
            faces[i].setTexture((IIcon)(isGuiIcon ? ((GuiIcon)icon).getIcon(i) : icon), false, false, false);
        }
    }

    public void drawScreen(UIContainer container, int mouseX, int mouseY, float partialTick) {
        if (container == null) {
            return;
        }
        this.set(mouseX, mouseY, partialTick);
        this.prepare(RenderType.GUI, new double[0]);
        container.draw(this, mouseX, mouseY, partialTick);
        this.clean();
    }

    public void drawShape(GuiShape s, RenderParameters params) {
        if (s == null) {
            return;
        }
        this.shape = s;
        this.rp = params != null ? params : new RenderParameters();
        this.shape.translate(this.currentComponent.screenX(), this.currentComponent.screenY(), this.currentComponent.getZIndex());
        this.shape.applyMatrix();
        this.applyTexture(this.shape, this.rp);
        for (Face face : s.getFaces()) {
            this.drawFace(face, face.getParameters());
        }
    }

    public void drawRectangle(int x, int y, int z, int width, int height, int color, int alpha) {
        this.drawRectangle(x, y, z, width, height, color, alpha, true);
    }

    public void drawRectangle(int x, int y, int z, int width, int height, int color, int alpha, boolean relative) {
        if (relative && this.currentComponent != null) {
            x += this.currentComponent.screenX();
            y += this.currentComponent.screenY();
            z += this.currentComponent.getZIndex();
        }
        rectangle.resetState();
        rectangle.setSize(width, height);
        rectangle.setPosition(x, y);
        GuiRenderer.rectangle.getFaces()[0].getParameters().colorMultiplier.set(color);
        GuiRenderer.rectangle.getFaces()[0].getParameters().alpha.set(alpha);
        GL11.glPushAttrib((int)1048575);
        GL11.glPushMatrix();
        GL11.glTranslated((double)0.0, (double)0.0, (double)z);
        this.disableTextures();
        this.enableBlending();
        this.drawShape(rectangle);
        this.next();
        this.enableTextures();
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    public void drawTooltip(UITooltip tooltip) {
        if (tooltip != null) {
            this.t.func_78382_b();
            tooltip.draw(this, this.mouseX, this.mouseY, this.partialTick);
            this.t.func_78381_a();
        }
    }

    public void drawText(String text) {
        this.drawText(text, 0, 0, 0, 0xFFFFFF, false, true);
    }

    public void drawText(String text, int color, boolean shadow) {
        this.drawText(text, 0, 0, 0, color, shadow, true);
    }

    public void drawText(String text, int x, int y) {
        this.drawText(text, x, y, 0, 0xFFFFFF, false, true);
    }

    public void drawText(String text, int x, int y, int color, boolean shadow) {
        this.drawText(text, x, y, 0, color, shadow, true);
    }

    public void drawText(String text, int x, int y, int z, int color, boolean shadow, boolean relative) {
        if (MalisisRenderer.getFontRenderer() == null) {
            return;
        }
        if (relative && this.currentComponent != null) {
            x += this.currentComponent.screenX();
            y += this.currentComponent.screenY();
            z += this.currentComponent.getZIndex();
        }
        this.draw();
        text = GuiRenderer.processString(text);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x * (1.0f - this.fontScale)), (float)((float)y * (1.0f - this.fontScale)), (float)0.0f);
        GL11.glScalef((float)this.fontScale, (float)this.fontScale, (float)1.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)z);
        GL11.glDisable((int)32826);
        MalisisRenderer.getFontRenderer().func_85187_a(text, x, y, color, shadow);
        GL11.glPopMatrix();
        GL11.glEnable((int)32826);
        this.currentTexture = null;
        this.bindDefaultTexture();
        this.startDrawing();
    }

    public void drawItemStack(ItemStack itemStack) {
        this.drawItemStack(itemStack, 0, 0, null, null, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y) {
        this.drawItemStack(itemStack, x, y, null, null, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, EnumChatFormatting format) {
        this.drawItemStack(itemStack, x, y, null, format, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, String label) {
        this.drawItemStack(itemStack, x, y, label, null, true);
    }

    public void drawItemStack(ItemStack itemStack, int x, int y, String label, EnumChatFormatting format, boolean relative) {
        FontRenderer fontRenderer;
        if (itemStack == null) {
            return;
        }
        if (relative && this.currentComponent != null) {
            x += this.currentComponent.screenX();
            y += this.currentComponent.screenY();
        }
        if ((fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack)) == null) {
            fontRenderer = MalisisRenderer.getFontRenderer();
        }
        if (label == null && (itemStack.field_77994_a > 1 || format != null)) {
            label = Integer.toString(itemStack.field_77994_a);
        }
        if (label == null) {
            label = "";
        }
        if (format != null) {
            label = format + label;
        }
        this.t.func_78381_a();
        RenderHelper.func_74520_c();
        GL11.glEnable((int)32826);
        itemRenderer.func_82406_b(fontRenderer, Minecraft.func_71410_x().func_110434_K(), itemStack, x, y);
        itemRenderer.func_94148_a(fontRenderer, Minecraft.func_71410_x().func_110434_K(), itemStack, x, y, label);
        RenderHelper.func_74518_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.currentTexture = null;
        this.bindDefaultTexture();
        this.t.func_78382_b();
    }

    public void renderPickedItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            return;
        }
        GuiRenderer.itemRenderer.field_77023_b = 100.0f;
        this.t.func_78382_b();
        this.drawItemStack(itemStack, this.mouseX - 8, this.mouseY - 8, null, (EnumChatFormatting)(itemStack.field_77994_a == 0 ? EnumChatFormatting.YELLOW : null), false);
        this.t.func_78381_a();
        GuiRenderer.itemRenderer.field_77023_b = 0.0f;
    }

    public void startClipping(ClipArea area) {
        if (area.noClip || area.width() <= 0 || area.height() <= 0) {
            return;
        }
        GL11.glPushAttrib((int)524288);
        GL11.glEnable((int)3089);
        int f = this.ignoreScale ? 1 : this.scaleFactor;
        int x = area.x * f;
        int y = this.displayHeight - (area.y + area.height()) * f;
        int w = area.width() * f;
        int h = area.height() * f;
        GL11.glScissor((int)x, (int)y, (int)w, (int)h);
    }

    public void endClipping(ClipArea area) {
        if (area.noClip || area.width() <= 0 || area.height() <= 0) {
            return;
        }
        GL11.glDisable((int)3089);
        GL11.glPopAttrib();
    }

    public static String processString(String str) {
        EnumChatFormatting ecf = GuiRenderer.getFormatting(str, 0);
        if (ecf != null) {
            str = str.substring(2);
        }
        str = StatCollector.func_74838_a((String)str);
        str = str.replaceAll("\r?\n", "").replaceAll("\t", "    ");
        return (ecf != null ? ecf : "") + str;
    }

    public static String clipString(String text, int width) {
        return GuiRenderer.clipString(text, width, 1.0f, false);
    }

    public static String clipString(String text, int width, float fontScale) {
        return GuiRenderer.clipString(text, width, fontScale, false);
    }

    public static String clipString(String text, int width, float fontScale, boolean appendPeriods) {
        text = StatCollector.func_74838_a((String)text);
        StringBuilder ret = new StringBuilder();
        float strWidth = 0.0f;
        int index = 0;
        if (appendPeriods) {
            width -= 4;
        }
        while (index < text.length()) {
            char c = text.charAt(index);
            if (!((strWidth += GuiRenderer.getCharWidth(c, fontScale)) < (float)width)) {
                if (appendPeriods) {
                    ret.append("...");
                }
                return ret.toString();
            }
            ret.append(c);
            ++index;
        }
        return ret.toString();
    }

    public static int getStringWidth(String str) {
        return GuiRenderer.getStringWidth(str, 1.0f);
    }

    public static int getStringWidth(String str, float fontScale) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0;
        }
        str = GuiRenderer.processString(str);
        return (int)Math.ceil((float)MalisisRenderer.getFontRenderer().func_78256_a(str) * fontScale);
    }

    public static int getStringHeight() {
        return GuiRenderer.getStringHeight(1.0f);
    }

    public static int getStringHeight(float fontScale) {
        return (int)Math.ceil((float)FONT_HEIGHT * fontScale);
    }

    public static int getMaxStringWidth(List<String> strings) {
        return GuiRenderer.getMaxStringWidth(strings, 1.0f);
    }

    public static int getMaxStringWidth(List<String> strings, float fontScale) {
        int width = 0;
        for (String str : strings) {
            width = Math.max(width, GuiRenderer.getStringWidth(str, fontScale));
        }
        return width;
    }

    public static float getCharWidth(char c) {
        return GuiRenderer.getCharWidth(c, 1.0f);
    }

    public static float getCharWidth(char c, float fontScale) {
        if (c == '\r' || c == '\n') {
            return 0.0f;
        }
        if (c == '\t') {
            return GuiRenderer.getCharWidth(' ', fontScale) * 4.0f;
        }
        float s = (float)MalisisRenderer.getFontRenderer().func_78263_a(c) * fontScale;
        return s >= 0.0f ? s : 0.0f;
    }

    public static List<String> wrapText(String text, int maxWidth) {
        return GuiRenderer.wrapText(text, maxWidth, 1.0f);
    }

    public static List<String> wrapText(String text, int maxWidth, float fontScale) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] texts = text.split("\r?(?<=\n)");
        if (texts.length > 1) {
            for (String str : texts) {
                lines.addAll(GuiRenderer.wrapText(str, maxWidth, fontScale));
            }
            return lines;
        }
        LinkedList<EnumChatFormatting> modifiers = new LinkedList<EnumChatFormatting>();
        StringBuilder line = new StringBuilder();
        StringBuilder word = new StringBuilder();
        float lineWidth = 0.0f;
        float wordWidth = 0.0f;
        text = StatCollector.func_74838_a((String)text);
        for (int index = 0; index < text.length(); ++index) {
            EnumChatFormatting ecf;
            while ((ecf = GuiRenderer.getFormatting(text, index)) != null) {
                if (ecf == EnumChatFormatting.RESET || ecf.func_96302_c()) {
                    modifiers.clear();
                }
                if (ecf != EnumChatFormatting.RESET) {
                    modifiers.add(ecf);
                }
                word.append(ecf.toString());
                if ((index += 2) < text.length()) continue;
            }
            char c = text.charAt(index);
            float w = GuiRenderer.getCharWidth(c, fontScale);
            lineWidth += w;
            wordWidth += w;
            word.append(c);
            if (c == ' ' || c == '-' || c == '.') {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0.0f;
            }
            if (!(lineWidth >= (float)maxWidth)) continue;
            if (line.length() == 0) {
                line.append((CharSequence)word);
                word.setLength(0);
                wordWidth = 0.0f;
            }
            lines.add(line.toString());
            line.setLength(0);
            for (int i = 0; i < modifiers.size(); ++i) {
                line.insert(i * 2, modifiers.get(i));
            }
            lineWidth = wordWidth;
        }
        line.append((CharSequence)word);
        lines.add(line.toString());
        return lines;
    }

    private static EnumChatFormatting getFormatting(String text, int index) {
        if (text == null || index >= text.length() - 3) {
            return null;
        }
        char c = text.charAt(index);
        if (c != '\u00a7') {
            return null;
        }
        return charFormats.get(Character.valueOf(text.charAt(index + 1)));
    }

    static {
        for (EnumChatFormatting ecf : EnumChatFormatting.values()) {
            charFormats.put(Character.valueOf(ecf.func_96298_a()), ecf);
        }
    }
}

