/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui;

import net.malisis.core.client.gui.component.IClipable;

public class ClipArea {
    public boolean noClip = false;
    public int x;
    public int y;
    public int X;
    public int Y;

    public ClipArea(IClipable container) {
        this(container, 0, true);
    }

    public ClipArea(IClipable container, int clipPadding) {
        this(container, clipPadding, true);
    }

    public ClipArea(IClipable container, int clipPadding, boolean intersect) {
        this(container, container.screenX() + clipPadding, container.screenY() + clipPadding, container.screenX() + container.getWidth() - clipPadding, container.screenY() + container.getHeight() - clipPadding, intersect);
    }

    public ClipArea(IClipable container, int x, int y, int X, int Y, boolean intersect) {
        if (!container.shouldClipContent()) {
            this.noClip = true;
        } else {
            this.x = x;
            this.y = y;
            this.X = X;
            this.Y = Y;
        }
        if (intersect && container.getParent() instanceof IClipable) {
            this.intersect(((IClipable)((Object)container.getParent())).getClipArea());
        }
    }

    public void intersect(ClipArea area) {
        if (this.noClip) {
            this.x = area.x;
            this.y = area.y;
            this.X = area.X;
            this.Y = area.Y;
        } else if (!area.noClip) {
            this.x = Math.max(this.x, area.x);
            this.y = Math.max(this.y, area.y);
            this.X = Math.min(this.X, area.X);
            this.Y = Math.min(this.Y, area.Y);
        }
    }

    public int width() {
        return this.X - this.x;
    }

    public int height() {
        return this.Y - this.y;
    }

    public String toString() {
        return this.x + "->" + this.X + " , " + this.y + "->" + this.Y + " (" + this.width() + "," + this.height() + ")";
    }
}

